/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.schema.registries.helper;

import java.util.List;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.NameForm;
import org.apache.directory.shared.ldap.model.schema.ObjectClass;
import org.apache.directory.shared.ldap.model.schema.registries.AttributeTypeRegistry;
import org.apache.directory.shared.ldap.model.schema.registries.Registries;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameFormHelper {
    private static final Logger LOG = LoggerFactory.getLogger(NameFormHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToRegistries(NameForm nameForm, List<Throwable> errors, Registries registries) throws LdapException {
        if (registries != null) {
            try {
                nameForm.unlock();
                AttributeTypeRegistry atRegistry = registries.getAttributeTypeRegistry();
                ObjectClass structuralObjectClass = (ObjectClass)registries.getObjectClassRegistry().lookup(nameForm.getStructuralObjectClassOid());
                nameForm.setStructuralObjectClass(structuralObjectClass);
                nameForm.getMayAttributeTypes().clear();
                for (String oid : nameForm.getMayAttributeTypeOids()) {
                    nameForm.getMayAttributeTypes().add((AttributeType)atRegistry.lookup(oid));
                }
                nameForm.getMustAttributeTypes().clear();
                for (String oid : nameForm.getMustAttributeTypeOids()) {
                    nameForm.getMustAttributeTypes().add((AttributeType)atRegistry.lookup(oid));
                }
            }
            finally {
                nameForm.lock();
            }
        }
    }
}

