/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1;

import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.Asn1Object;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.codec.EncoderException;

public abstract class AbstractAsn1Object
implements Asn1Object {
    private int currentLength;
    private int expectedLength;
    protected AbstractAsn1Object parent;
    private int tlvId;

    protected AbstractAsn1Object(int tlvId) {
        this.tlvId = tlvId;
    }

    protected AbstractAsn1Object() {
        this.tlvId = -1;
    }

    public int getCurrentLength() {
        return this.currentLength;
    }

    public abstract int computeLength();

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        return null;
    }

    public int getExpectedLength() {
        return this.expectedLength;
    }

    public void addLength(int length) throws DecoderException {
        this.currentLength += length;
        if (this.currentLength > this.expectedLength) {
            throw new DecoderException("Current Length is above expected Length");
        }
    }

    public void setExpectedLength(int expectedLength) {
        this.expectedLength = expectedLength;
    }

    public void setCurrentLength(int currentLength) {
        this.currentLength = currentLength;
    }

    public AbstractAsn1Object getParent() {
        return this.parent;
    }

    public void setParent(AbstractAsn1Object parent) {
        this.parent = parent;
    }

    public int getTlvId() {
        return this.tlvId;
    }
}

