/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.aci;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.directory.shared.ldap.aci.GrantAndDenial;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Permission
implements Serializable {
    private final int precedence;
    private final Set<GrantAndDenial> grantsAndDenials;
    private final Set<GrantAndDenial> grants;
    private final Set<GrantAndDenial> denials;

    protected Permission(int precedence, Collection<GrantAndDenial> grantsAndDenials) {
        if (precedence < 0 || precedence > 255) {
            precedence = -1;
        }
        this.precedence = precedence;
        HashSet<GrantAndDenial> tmpGrantsAndDenials = new HashSet<GrantAndDenial>();
        HashSet<GrantAndDenial> tmpGrants = new HashSet<GrantAndDenial>();
        HashSet<GrantAndDenial> tmpDenials = new HashSet<GrantAndDenial>();
        for (GrantAndDenial gad : grantsAndDenials) {
            if (gad.isGrant()) {
                tmpGrants.add(gad);
            } else {
                tmpDenials.add(gad);
            }
            tmpGrantsAndDenials.add(gad);
        }
        this.grants = Collections.unmodifiableSet(tmpGrants);
        this.denials = Collections.unmodifiableSet(tmpDenials);
        this.grantsAndDenials = Collections.unmodifiableSet(tmpGrantsAndDenials);
    }

    public int getPrecedence() {
        return this.precedence;
    }

    public Set<GrantAndDenial> getGrantsAndDenials() {
        return this.grantsAndDenials;
    }

    public Set<GrantAndDenial> getGrants() {
        return this.grants;
    }

    public Set<GrantAndDenial> getDenials() {
        return this.denials;
    }
}

