/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.exception;

import javax.naming.OperationNotSupportedException;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;

public class LdapOperationNotSupportedException
extends OperationNotSupportedException
implements LdapException {
    private static final long serialVersionUID = 1L;
    private final ResultCodeEnum resultCode;

    public LdapOperationNotSupportedException(String description, ResultCodeEnum resultCode) {
        super(description);
        this.checkResultCode(resultCode);
        this.resultCode = resultCode;
    }

    public LdapOperationNotSupportedException(ResultCodeEnum resultCode) {
        this.checkResultCode(resultCode);
        this.resultCode = resultCode;
    }

    private void checkResultCode(ResultCodeEnum resultCode) {
        if (!resultCode.equals((Object)ResultCodeEnum.UNWILLING_TO_PERFORM) && !resultCode.equals((Object)ResultCodeEnum.UNAVAILABLE_CRITICAL_EXTENSION)) {
            throw new IllegalArgumentException("Only UNWILLING_TO_PERFORM and UNAVAILABLE_CRITICAL_EXTENSION result codes are allowed to be used with this exception");
        }
    }

    public ResultCodeEnum getResultCode() {
        return this.resultCode;
    }
}

