/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.syntax;

import org.apache.directory.shared.ldap.schema.syntax.AbstractSyntaxChecker;
import org.apache.directory.shared.ldap.util.StringTools;

public class DSAQualitySyntaxSyntaxChecker
extends AbstractSyntaxChecker {
    private static final String SC_OID = "1.3.6.1.4.1.1466.115.121.1.19";

    public DSAQualitySyntaxSyntaxChecker() {
        super(SC_OID);
    }

    protected DSAQualitySyntaxSyntaxChecker(String oid) {
        super(oid);
    }

    public boolean isValidSyntax(Object value) {
        String strValue = null;
        if (value == null) {
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? StringTools.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() < 7) {
            return false;
        }
        String remaining = null;
        switch (strValue.charAt(0)) {
            case 'B': {
                if (!strValue.startsWith("BEST-EFFORT")) {
                    return false;
                }
                remaining = strValue.substring("BEST-EFFORT".length());
                break;
            }
            case 'D': {
                if (!strValue.startsWith("DEFUNCT")) {
                    return false;
                }
                remaining = strValue.substring("DEFUNCT".length());
                break;
            }
            case 'E': {
                if (!strValue.startsWith("EXPERIMENTAL")) {
                    return false;
                }
                remaining = strValue.substring("EXPERIMENTAL".length());
                break;
            }
            case 'F': {
                if (!strValue.startsWith("FULL-SERVICE")) {
                    return false;
                }
                remaining = strValue.substring("FULL-SERVICE".length());
                break;
            }
            case 'P': {
                if (!strValue.startsWith("PILOT-SERVICE")) {
                    return false;
                }
                remaining = strValue.substring("PILOT-SERVICE".length());
                break;
            }
            default: {
                return false;
            }
        }
        if (remaining.length() == 0) {
            return true;
        }
        if (remaining.charAt(0) != '#') {
            return false;
        }
        return StringTools.isPrintableString(remaining.substring(1));
    }
}

