/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.filter;

import java.util.List;
import org.apache.directory.shared.ldap.filter.AssertionType;
import org.apache.directory.shared.ldap.filter.BranchNode;
import org.apache.directory.shared.ldap.filter.ExprNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrNode
extends BranchNode {
    public OrNode(List<ExprNode> childList) {
        super(childList, AssertionType.OR);
    }

    public OrNode() {
        this((List<ExprNode>)null);
    }

    public AssertionType getOperator() {
        return AssertionType.OR;
    }

    public boolean isDisjunction() {
        return true;
    }

    public boolean isConjunction() {
        return false;
    }

    public boolean isNegation() {
        return false;
    }

    @Override
    public StringBuilder printRefinementToBuffer(StringBuilder buf) {
        buf.append("or: {");
        boolean isFirst = true;
        for (ExprNode node : this.children) {
            if (isFirst) {
                isFirst = false;
            } else {
                buf.append(", ");
            }
            node.printRefinementToBuffer(buf);
        }
        buf.append('}');
        return buf;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("(|");
        buf.append(super.toString());
        for (ExprNode child : this.getChildren()) {
            buf.append(child);
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public int hashCode() {
        int hash = 37;
        hash = hash * 17 + AssertionType.OR.hashCode();
        hash = hash * 17 + (this.annotations == null ? 0 : ((Object)this.annotations).hashCode());
        return hash;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OrNode)) {
            return false;
        }
        OrNode otherExprNode = (OrNode)other;
        List<ExprNode> otherChildren = otherExprNode.getChildren();
        if (otherChildren == this.children) {
            return true;
        }
        if (this.children.size() != otherChildren.size()) {
            return false;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            ExprNode otherChild;
            ExprNode child = (ExprNode)this.children.get(i);
            if (child.equals(otherChild = (ExprNode)this.children.get(i))) continue;
            return false;
        }
        return true;
    }
}

