/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.syntax;

import org.apache.directory.shared.asn1.primitives.OID;
import org.apache.directory.shared.ldap.schema.syntax.AbstractSyntaxChecker;
import org.apache.directory.shared.ldap.util.StringTools;

public class NumericOidSyntaxChecker
extends AbstractSyntaxChecker {
    private static final String SC_OID = "1.3.6.1.4.1.18060.0.4.0.0.2";

    public NumericOidSyntaxChecker() {
        super(SC_OID);
    }

    protected NumericOidSyntaxChecker(String oid) {
        super(oid);
    }

    public boolean isValidSyntax(Object value) {
        String strValue = null;
        if (value == null) {
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? StringTools.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() == 0) {
            return false;
        }
        return OID.isOID((String)strValue);
    }
}

