/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.syntax;

import org.apache.directory.shared.ldap.schema.syntax.AbstractSyntaxChecker;
import org.apache.directory.shared.ldap.util.StringTools;

public class TelexNumberSyntaxChecker
extends AbstractSyntaxChecker {
    private static final String SC_OID = "1.3.6.1.4.1.1466.115.121.1.52";

    public TelexNumberSyntaxChecker() {
        super(SC_OID);
    }

    protected TelexNumberSyntaxChecker(String oid) {
        super(oid);
    }

    public boolean isValidSyntax(Object value) {
        String strValue = null;
        if (value == null) {
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? StringTools.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() == 0) {
            return false;
        }
        int dollar = strValue.indexOf(36);
        if (dollar <= 0) {
            return false;
        }
        String actualNumber = strValue.substring(0, dollar);
        if (actualNumber.length() == 0) {
            return false;
        }
        if (!StringTools.isPrintableString(actualNumber)) {
            return false;
        }
        int dollar2 = strValue.indexOf(36, dollar + 1);
        if (dollar2 == -1) {
            return false;
        }
        String countryCode = strValue.substring(dollar + 1, dollar2);
        if (countryCode.length() == 0) {
            return false;
        }
        if (!StringTools.isPrintableString(countryCode)) {
            return false;
        }
        if (dollar2 + 1 == strValue.length()) {
            return false;
        }
        String answerBack = strValue.substring(dollar2 + 1);
        if (!StringTools.isPrintableString(answerBack)) {
            return false;
        }
        return StringTools.isPrintableString(answerBack);
    }
}

