/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.ldap.codec.LdapMessageCodec;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.LdapResponseCodec;
import org.apache.directory.shared.ldap.codec.LdapResultCodec;
import org.apache.directory.shared.ldap.codec.util.LdapURLEncodingException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.util.LdapURL;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferralAction
extends GrammarAction {
    private static final Logger log = LoggerFactory.getLogger(ReferralAction.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();

    public ReferralAction() {
        super("Add a referral");
    }

    public void action(IAsn1Container container) throws DecoderException {
        LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
        LdapMessageCodec ldapMessage = ldapMessageContainer.getLdapMessage();
        LdapResponseCodec response = ldapMessage.getLdapResponse();
        LdapResultCodec ldapResult = response.getLdapResult();
        TLV tlv = ldapMessageContainer.getCurrentTLV();
        if (tlv.getLength() == 0) {
            ldapResult.addReferral(LdapURL.EMPTY_URL);
        } else if (ldapResult.getResultCode() == ResultCodeEnum.REFERRAL) {
            try {
                ldapResult.addReferral(new LdapURL(tlv.getValue().getData()));
            }
            catch (LdapURLEncodingException luee) {
                String badUrl = StringTools.utf8ToString(tlv.getValue().getData());
                log.error("The URL " + badUrl + " is not valid : " + luee.getMessage());
                throw new DecoderException("Invalid URL : " + luee.getMessage());
            }
        } else {
            log.warn("The Referral error message is not allowed when havind an error code no equals to REFERRAL");
            ldapResult.addReferral(LdapURL.EMPTY_URL);
        }
        ldapMessageContainer.grammarEndAllowed(true);
        if (IS_DEBUG) {
            StringBuffer sb = new StringBuffer();
            boolean isFirst = true;
            for (LdapURL url : ldapResult.getReferrals()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(url);
            }
            log.debug("The referral error message is set to " + sb.toString());
        }
    }
}

