/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.name;

import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import org.apache.directory.shared.ldap.entry.client.ClientStringValue;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.name.TooComplexException;
import org.apache.directory.shared.ldap.util.Position;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FastLdapDnParser implements NameParser
{
    INSTANCE;


    public static NameParser getNameParser() {
        return INSTANCE;
    }

    @Override
    public Name parse(String name) throws NamingException {
        LdapDN dn = new LdapDN();
        this.parseDn(name, dn);
        return dn;
    }

    public void parseDn(String name, LdapDN dn) throws InvalidNameException {
        this.parseDn(name, dn.rdns);
        dn.setUpName(name);
        dn.normalizeInternal();
    }

    void parseDn(String name, List<Rdn> rdns) throws InvalidNameException {
        block5: {
            char c;
            if (name == null || name.trim().length() == 0) {
                return;
            }
            Position pos = new Position();
            pos.start = 0;
            pos.length = name.length();
            block3: while (true) {
                Rdn rdn = new Rdn();
                this.parseRdnInternal(name, pos, rdn);
                rdns.add(rdn);
                if (!this.hasMoreChars(pos)) break block5;
                c = this.nextChar(name, pos, true);
                switch (c) {
                    case ',': 
                    case ';': {
                        continue block3;
                    }
                }
                break;
            }
            throw new InvalidNameException("Unexpected character '" + c + "' at position " + pos.start + ". Excpected ',' or ';'.");
        }
    }

    public void parseRdn(String name, Rdn rdn) throws InvalidNameException {
        if (name == null || name.length() == 0) {
            throw new InvalidNameException("RDN must not be empty");
        }
        Position pos = new Position();
        pos.start = 0;
        pos.length = name.length();
        this.parseRdnInternal(name, pos, rdn);
        if (!this.hasMoreChars(pos)) {
            throw new InvalidNameException("Expected no more characters at position " + pos.start);
        }
    }

    private void parseRdnInternal(String name, Position pos, Rdn rdn) throws InvalidNameException {
        int rdnStart = pos.start;
        this.matchSpaces(name, pos);
        String type = this.matchAttributeType(name, pos);
        this.matchSpaces(name, pos);
        this.matchEquals(name, pos);
        this.matchSpaces(name, pos);
        String upValue = this.matchValue(name, pos);
        String value = StringTools.trimRight(upValue);
        this.matchSpaces(name, pos);
        rdn.addAttributeTypeAndValue(type, type, new ClientStringValue(upValue), new ClientStringValue(value));
        rdn.setUpName(name.substring(rdnStart, pos.start));
        rdn.normalize();
    }

    private void matchSpaces(String name, Position pos) throws InvalidNameException {
        while (this.hasMoreChars(pos)) {
            char c = this.nextChar(name, pos, true);
            if (c == ' ') continue;
            --pos.start;
            break;
        }
    }

    private String matchAttributeType(String name, Position pos) throws InvalidNameException {
        char c = this.nextChar(name, pos, false);
        switch (c) {
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'H': 
            case 'I': 
            case 'J': 
            case 'K': 
            case 'L': 
            case 'M': 
            case 'N': 
            case 'O': 
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': 
            case 'V': 
            case 'W': 
            case 'X': 
            case 'Y': 
            case 'Z': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': 
            case 'g': 
            case 'h': 
            case 'i': 
            case 'j': 
            case 'k': 
            case 'l': 
            case 'm': 
            case 'n': 
            case 'o': 
            case 'p': 
            case 'q': 
            case 'r': 
            case 's': 
            case 't': 
            case 'u': 
            case 'v': 
            case 'w': 
            case 'x': 
            case 'y': 
            case 'z': {
                return this.matchAttributeTypeDescr(name, pos);
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return this.matchAttributeTypeNumericOid(name, pos);
            }
        }
        throw new InvalidNameException("Unexpected character '" + c + "' at position " + pos.start + ". Excpected start of attributeType.");
    }

    private String matchAttributeTypeDescr(String name, Position pos) throws InvalidNameException {
        StringBuilder descr = new StringBuilder();
        block5: while (this.hasMoreChars(pos)) {
            char c = this.nextChar(name, pos, true);
            switch (c) {
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    descr.append(c);
                    continue block5;
                }
                case ' ': 
                case '=': {
                    --pos.start;
                    return descr.toString();
                }
                case '.': {
                    throw new TooComplexException();
                }
            }
            throw new InvalidNameException("Unexpected character '" + c + "' at position " + pos.start + ". Excpected start of attributeType descr.");
        }
        return descr.toString();
    }

    /*
     * Unable to fully structure code
     */
    private String matchAttributeTypeNumericOid(String name, Position pos) throws InvalidNameException {
        numericOid = new StringBuilder();
        dotCount = 0;
        block14: while (true) {
            c = this.nextChar(name, pos, true);
            switch (c) {
                case '0': {
                    numericOid.append(c);
                    c = this.nextChar(name, pos, true);
                    switch (c) {
                        case '.': {
                            numericOid.append(c);
                            ++dotCount;
                            continue block14;
                        }
                        case ' ': 
                        case '=': {
                            --pos.start;
                            continue block14;
                        }
                    }
                    throw new InvalidNameException("Unexpected character '" + c + "' at position " + pos.start + ". Excpected numericoid.");
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    numericOid.append(c);
                    inInnerLoop = true;
                    block15: while (true) {
                        if (inInnerLoop) ** break;
                        continue block14;
                        c = this.nextChar(name, pos, true);
                        switch (c) {
                            case ' ': 
                            case '=': {
                                inInnerLoop = false;
                                --pos.start;
                                continue block15;
                            }
                            case '.': {
                                inInnerLoop = false;
                                ++dotCount;
                            }
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                numericOid.append(c);
                                continue block15;
                            }
                        }
                        break;
                    }
                    throw new InvalidNameException("Unexpected character '" + c + "' at position " + pos.start + ". Excpected numericoid.");
                }
                case ' ': 
                case '=': {
                    --pos.start;
                    if (dotCount > 0) {
                        return numericOid.toString();
                    }
                    throw new InvalidNameException("Numeric OID must contain at least one dot.");
                }
            }
            break;
        }
        throw new InvalidNameException("Unexpected character '" + c + "' at position " + pos.start + ". Excpected start of attributeType numericoid.");
    }

    private void matchEquals(String name, Position pos) throws InvalidNameException {
        char c = this.nextChar(name, pos, true);
        if (c != '=') {
            throw new InvalidNameException("Unexpected character '" + c + "' at position " + pos.start + ". Excpected EQUALS '='.");
        }
    }

    private String matchValue(String name, Position pos) throws InvalidNameException {
        StringBuilder value = new StringBuilder();
        int numTrailingSpaces = 0;
        block5: while (true) {
            if (!this.hasMoreChars(pos)) {
                pos.start -= numTrailingSpaces;
                return value.substring(0, value.length() - numTrailingSpaces);
            }
            char c = this.nextChar(name, pos, true);
            switch (c) {
                case '\"': 
                case '#': 
                case '+': 
                case '\\': {
                    throw new TooComplexException();
                }
                case ',': 
                case ';': {
                    --pos.start;
                    pos.start -= numTrailingSpaces;
                    return value.substring(0, value.length() - numTrailingSpaces);
                }
                case ' ': {
                    ++numTrailingSpaces;
                    value.append(c);
                    continue block5;
                }
            }
            numTrailingSpaces = 0;
            value.append(c);
        }
    }

    private char nextChar(String name, Position pos, boolean increment) throws InvalidNameException {
        if (!this.hasMoreChars(pos)) {
            throw new InvalidNameException("No more characters available at position " + pos.start);
        }
        char c = name.charAt(pos.start);
        if (increment) {
            ++pos.start;
        }
        return c;
    }

    private boolean hasMoreChars(Position pos) {
        return pos.start < pos.length;
    }
}

