/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.normalizers;

import java.io.IOException;
import javax.naming.NamingException;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.ClientStringValue;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.PrepareString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeepTrimToLowerNormalizer
implements Normalizer {
    private static final long serialVersionUID = 1L;

    @Override
    public Value<?> normalize(Value<?> value) throws NamingException {
        if (value == null) {
            return null;
        }
        try {
            String normalized = PrepareString.normalize(value.getString(), PrepareString.StringType.CASE_IGNORE);
            return new ClientStringValue(normalized);
        }
        catch (IOException ioe) {
            throw new NamingException("Invalid value : " + value);
        }
    }

    @Override
    public String normalize(String value) throws NamingException {
        if (value == null) {
            return null;
        }
        try {
            String normalized = PrepareString.normalize(value, PrepareString.StringType.CASE_IGNORE);
            return normalized;
        }
        catch (IOException ioe) {
            throw new NamingException("Invalid value : " + value);
        }
    }
}

