/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.add;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.LdapResponseCodec;
import org.apache.directory.shared.ldap.codec.MessageTypeEnum;

public class AddResponseCodec
extends LdapResponseCodec {
    public MessageTypeEnum getMessageType() {
        return MessageTypeEnum.ADD_RESPONSE;
    }

    public String getMessageTypeName() {
        return "ADD_RESPONSE";
    }

    protected int computeLengthProtocolOp() {
        int ldapResultLength = super.computeLdapResultLength();
        return 1 + TLV.getNbBytes((int)ldapResultLength) + ldapResultLength;
    }

    protected void encodeProtocolOp(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)105);
            buffer.put(TLV.getBytes((int)this.getLdapResponseLength()));
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err((String)"ERR_04005", (Object[])new Object[0]));
        }
        super.encode(buffer);
    }

    public String toString() {
        return this.toString("    Add Response");
    }
}

