/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.entry.client;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.naming.NamingException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.NotImplementedException;
import org.apache.directory.shared.ldap.entry.AbstractValue;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientStringValue
extends AbstractValue<String> {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(ClientStringValue.class);

    public ClientStringValue() {
        this.normalized = false;
        this.valid = null;
    }

    public ClientStringValue(String wrapped) {
        this.wrapped = wrapped;
        this.normalized = false;
        this.valid = null;
    }

    @Override
    public String getCopy() {
        return (String)this.wrapped;
    }

    @Override
    public final void set(String wrapped) {
        if (!StringTools.isEmpty(wrapped) && wrapped.equals(this.getString())) {
            return;
        }
        this.normalizedValue = null;
        this.normalized = false;
        this.valid = null;
        this.wrapped = wrapped;
    }

    @Override
    public String getNormalizedValue() {
        if (this.isNull()) {
            return null;
        }
        if (this.normalizedValue == null) {
            return (String)this.wrapped;
        }
        return (String)this.normalizedValue;
    }

    @Override
    public String getNormalizedValueCopy() {
        return this.getNormalizedValue();
    }

    @Override
    public final void normalize(Normalizer normalizer) throws NamingException {
        if (normalizer != null) {
            this.normalizedValue = normalizer.normalize((String)this.wrapped);
            this.normalized = true;
        }
    }

    @Override
    public int compareTo(Value<String> value) {
        if (this.isNull()) {
            if (value == null || value.isNull()) {
                return 0;
            }
            return -1;
        }
        if (value == null || value.isNull()) {
            return 1;
        }
        if (value instanceof ClientStringValue) {
            ClientStringValue stringValue = (ClientStringValue)value;
            return this.getNormalizedValue().compareTo(stringValue.getNormalizedValue());
        }
        String message = I18n.err((String)"ERR_04128", (Object[])new Object[]{this.toString(), value.getClass()});
        LOG.error(message);
        throw new NotImplementedException(message);
    }

    @Override
    public ClientStringValue clone() {
        return (ClientStringValue)super.clone();
    }

    public int hashCode() {
        if (this.isNull()) {
            return 0;
        }
        return this.getNormalizedValue().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ClientStringValue)) {
            return false;
        }
        ClientStringValue other = (ClientStringValue)obj;
        if (this.isNull()) {
            return other.isNull();
        }
        return this.getNormalizedValue().equals(other.getNormalizedValue());
    }

    @Override
    public boolean isBinary() {
        return false;
    }

    @Override
    public int length() {
        return this.wrapped != null ? ((String)this.wrapped).length() : 0;
    }

    @Override
    public byte[] getBytes() {
        return StringTools.getBytesUtf8((String)this.wrapped);
    }

    @Override
    public String getString() {
        return this.wrapped != null ? (String)this.wrapped : "";
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (in.readBoolean()) {
            this.wrapped = in.readUTF();
        }
        this.normalized = in.readBoolean();
        if (this.normalized && in.readBoolean()) {
            this.normalizedValue = in.readUTF();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.wrapped != null) {
            out.writeBoolean(true);
            out.writeUTF((String)this.wrapped);
        } else {
            out.writeBoolean(false);
        }
        if (this.normalized) {
            out.writeBoolean(true);
            if (this.normalizedValue != null) {
                out.writeBoolean(true);
                out.writeUTF((String)this.normalizedValue);
            } else {
                out.writeBoolean(false);
            }
        } else {
            out.writeBoolean(false);
        }
        out.flush();
    }

    public String toString() {
        return this.wrapped == null ? "null" : (String)this.wrapped;
    }
}

