/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.registries;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.schema.registries.DefaultSchema;
import org.apache.directory.shared.ldap.schema.registries.Registries;
import org.apache.directory.shared.ldap.schema.registries.Schema;
import org.apache.directory.shared.ldap.schema.registries.SchemaLoader;
import org.apache.directory.shared.ldap.schema.registries.SchemaLoaderListener;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSchemaLoader
implements SchemaLoader {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSchemaLoader.class);
    protected SchemaLoaderListener listener;
    protected final Map<String, Schema> schemaMap = new HashMap<String, Schema>();

    @Override
    public void setListener(SchemaLoaderListener listener) {
        this.listener = listener;
    }

    protected final void notifyListenerOrRegistries(Schema schema, Registries registries) {
        if (this.listener != null) {
            this.listener.schemaLoaded(schema);
        }
        if (registries instanceof SchemaLoaderListener && registries != this.listener) {
            Registries listener = registries;
            listener.schemaLoaded(schema);
        }
    }

    @Override
    public final Collection<Schema> getAllEnabled() throws Exception {
        ArrayList<Schema> enabledSchemas = new ArrayList<Schema>();
        for (Schema schema : this.schemaMap.values()) {
            if (!schema.isEnabled()) continue;
            enabledSchemas.add(schema);
        }
        return enabledSchemas;
    }

    @Override
    public final Collection<Schema> getAllSchemas() throws Exception {
        return this.schemaMap.values();
    }

    @Override
    public Schema getSchema(String schemaName) {
        return this.schemaMap.get(StringTools.toLowerCase(schemaName));
    }

    @Override
    public void addSchema(Schema schema) {
        this.schemaMap.put(schema.getSchemaName(), schema);
    }

    @Override
    public void removeSchema(Schema schema) {
        this.schemaMap.remove(schema.getSchemaName());
    }

    protected Schema getSchema(Entry entry) throws Exception {
        EntryAttribute objectClasses = entry.get("objectClass");
        boolean isSchema = false;
        for (Value value : objectClasses) {
            if (!"metaSchema".equalsIgnoreCase(value.getString())) continue;
            isSchema = true;
            break;
        }
        if (!isSchema) {
            return null;
        }
        String[] dependencies = StringTools.EMPTY_STRINGS;
        boolean isDisabled = false;
        if (entry == null) {
            throw new NullPointerException(I18n.err((String)"ERR_04261", (Object[])new Object[0]));
        }
        if (entry.get("cn") == null) {
            throw new NullPointerException(I18n.err((String)"ERR_04262", (Object[])new Object[0]));
        }
        String name = entry.get("cn").getString();
        if (entry.get("creatorsName") == null) {
            throw new NullPointerException("entry must have a valid creatorsName attribute");
        }
        String owner = entry.get("creatorsName").getString();
        if (entry.get("m-disabled") != null) {
            String value = entry.get("m-disabled").getString();
            value = value.toUpperCase();
            isDisabled = value.equals("TRUE");
        }
        if (entry.get("m-dependencies") != null) {
            HashSet<String> depsSet = new HashSet<String>();
            EntryAttribute depsAttr = entry.get("m-dependencies");
            for (Value value : depsAttr) {
                depsSet.add(value.getString());
            }
            dependencies = depsSet.toArray(StringTools.EMPTY_STRINGS);
        }
        return new DefaultSchema(name, owner, dependencies, isDisabled){};
    }

    public Object getDao() {
        return null;
    }

    private Schema[] buildSchemaArray(String ... schemaNames) throws Exception {
        Schema[] schemas = new Schema[schemaNames.length];
        int pos = 0;
        for (String schemaName : schemaNames) {
            schemas[pos++] = this.getSchema(schemaName);
        }
        return schemas;
    }

    @Override
    public List<Entry> loadAttributeTypes(String ... schemaNames) throws Exception {
        if (schemaNames == null) {
            return new ArrayList<Entry>();
        }
        return this.loadAttributeTypes(this.buildSchemaArray(schemaNames));
    }

    @Override
    public List<Entry> loadComparators(String ... schemaNames) throws Exception {
        if (schemaNames == null) {
            return new ArrayList<Entry>();
        }
        return this.loadComparators(this.buildSchemaArray(schemaNames));
    }

    @Override
    public List<Entry> loadDitContentRules(String ... schemaNames) throws Exception {
        if (schemaNames == null) {
            return new ArrayList<Entry>();
        }
        return this.loadDitContentRules(this.buildSchemaArray(schemaNames));
    }

    @Override
    public List<Entry> loadDitStructureRules(String ... schemaNames) throws Exception {
        if (schemaNames == null) {
            return new ArrayList<Entry>();
        }
        return this.loadDitStructureRules(this.buildSchemaArray(schemaNames));
    }

    @Override
    public List<Entry> loadMatchingRules(String ... schemaNames) throws Exception {
        if (schemaNames == null) {
            return new ArrayList<Entry>();
        }
        return this.loadMatchingRules(this.buildSchemaArray(schemaNames));
    }

    @Override
    public List<Entry> loadMatchingRuleUses(String ... schemaNames) throws Exception {
        if (schemaNames == null) {
            return new ArrayList<Entry>();
        }
        return this.loadMatchingRuleUses(this.buildSchemaArray(schemaNames));
    }

    @Override
    public List<Entry> loadNameForms(String ... schemaNames) throws Exception {
        if (schemaNames == null) {
            return new ArrayList<Entry>();
        }
        return this.loadNameForms(this.buildSchemaArray(schemaNames));
    }

    @Override
    public List<Entry> loadNormalizers(String ... schemaNames) throws Exception {
        if (schemaNames == null) {
            return new ArrayList<Entry>();
        }
        return this.loadNormalizers(this.buildSchemaArray(schemaNames));
    }

    @Override
    public List<Entry> loadObjectClasses(String ... schemaNames) throws Exception {
        if (schemaNames == null) {
            return new ArrayList<Entry>();
        }
        return this.loadObjectClasses(this.buildSchemaArray(schemaNames));
    }

    @Override
    public List<Entry> loadSyntaxes(String ... schemaNames) throws Exception {
        if (schemaNames == null) {
            return new ArrayList<Entry>();
        }
        return this.loadSyntaxes(this.buildSchemaArray(schemaNames));
    }

    @Override
    public List<Entry> loadSyntaxCheckers(String ... schemaNames) throws Exception {
        if (schemaNames == null) {
            return new ArrayList<Entry>();
        }
        return this.loadSyntaxCheckers(this.buildSchemaArray(schemaNames));
    }
}

