/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.add;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import javax.naming.NamingException;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.LdapMessageCodec;
import org.apache.directory.shared.ldap.codec.MessageTypeEnum;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.DefaultClientAttribute;
import org.apache.directory.shared.ldap.entry.client.DefaultClientEntry;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddRequestCodec
extends LdapMessageCodec {
    private static final Logger log = LoggerFactory.getLogger(AddRequestCodec.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    private Entry entry = new DefaultClientEntry();
    private EntryAttribute currentAttribute;
    private int addRequestLength;
    private int attributesLength;
    private List<Integer> attributeLength;
    private List<Integer> valuesLength;

    @Override
    public MessageTypeEnum getMessageType() {
        return MessageTypeEnum.ADD_REQUEST;
    }

    @Override
    public String getMessageTypeName() {
        return "ADD_REQUEST";
    }

    public void initEntry() {
        this.entry = new DefaultClientEntry();
    }

    public Entry getEntry() {
        return this.entry;
    }

    public void setEntry(Entry entry) {
        this.entry = entry;
    }

    public void addAttributeType(String type) throws NamingException {
        if (this.entry.get(type) != null) {
            this.currentAttribute = this.entry.get(type);
            return;
        }
        this.currentAttribute = new DefaultClientAttribute(type);
        this.entry.put(this.currentAttribute);
    }

    public void addAttributeValue(String value) {
        this.currentAttribute.add(value);
    }

    public void addAttributeValue(Value<?> value) {
        this.currentAttribute.add(value);
    }

    public void addAttributeValue(byte[] value) {
        this.currentAttribute.add(new byte[][]{value});
    }

    public DN getEntryDn() {
        return this.entry.getDn();
    }

    public void setEntryDn(DN entryDn) {
        this.entry.setDn(entryDn);
    }

    @Override
    protected int computeLengthProtocolOp() {
        this.addRequestLength = 1 + TLV.getNbBytes((int)DN.getNbBytes(this.entry.getDn())) + DN.getNbBytes(this.entry.getDn());
        this.attributesLength = 0;
        if (this.entry != null && this.entry.size() != 0) {
            this.attributeLength = new LinkedList<Integer>();
            this.valuesLength = new LinkedList<Integer>();
            for (EntryAttribute attribute : this.entry) {
                int localAttributeLength = 0;
                int localValuesLength = 0;
                int idLength = attribute.getId().getBytes().length;
                localAttributeLength = 1 + TLV.getNbBytes((int)idLength) + idLength;
                if (attribute.size() != 0) {
                    localValuesLength = 0;
                    for (Value value : attribute) {
                        int valueLength = value.getBytes().length;
                        localValuesLength += 1 + TLV.getNbBytes((int)valueLength) + valueLength;
                    }
                    localAttributeLength += 1 + TLV.getNbBytes((int)localValuesLength) + localValuesLength;
                }
                this.attributesLength += 1 + TLV.getNbBytes((int)localAttributeLength) + localAttributeLength;
                this.attributeLength.add(localAttributeLength);
                this.valuesLength.add(localValuesLength);
            }
        }
        this.addRequestLength += 1 + TLV.getNbBytes((int)this.attributesLength) + this.attributesLength;
        int result = 1 + TLV.getNbBytes((int)this.addRequestLength) + this.addRequestLength;
        if (IS_DEBUG) {
            log.debug("AddRequest PDU length = {}", (Object)result);
        }
        return result;
    }

    @Override
    protected void encodeProtocolOp(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)104);
            buffer.put(TLV.getBytes((int)this.addRequestLength));
            org.apache.directory.shared.asn1.ber.tlv.Value.encode((ByteBuffer)buffer, (byte[])DN.getBytes(this.entry.getDn()));
            buffer.put((byte)48);
            buffer.put(TLV.getBytes((int)this.attributesLength));
            if (this.entry != null && this.entry.size() != 0) {
                int attributeNumber = 0;
                for (EntryAttribute attribute : this.entry) {
                    buffer.put((byte)48);
                    int localAttributeLength = this.attributeLength.get(attributeNumber);
                    buffer.put(TLV.getBytes((int)localAttributeLength));
                    org.apache.directory.shared.asn1.ber.tlv.Value.encode((ByteBuffer)buffer, (String)attribute.getId());
                    buffer.put((byte)49);
                    int localValuesLength = this.valuesLength.get(attributeNumber);
                    buffer.put(TLV.getBytes((int)localValuesLength));
                    if (attribute.size() != 0) {
                        for (Value value : attribute) {
                            if (value.isBinary()) {
                                org.apache.directory.shared.asn1.ber.tlv.Value.encode((ByteBuffer)buffer, (byte[])value.getBytes());
                                continue;
                            }
                            org.apache.directory.shared.asn1.ber.tlv.Value.encode((ByteBuffer)buffer, (String)value.getString());
                        }
                    }
                    ++attributeNumber;
                }
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
        if (IS_DEBUG) {
            log.debug("AddRequest encoding : {}", (Object)StringTools.dumpBytes(buffer.array()));
            log.debug("AddRequest initial value : {}", (Object)this.toString());
        }
    }

    public String getCurrentAttributeType() {
        return this.currentAttribute.getId();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    Add Request\n");
        sb.append("        Attributes\n");
        if (this.entry == null) {
            sb.append("            No attributes");
        } else {
            sb.append(this.entry);
        }
        return this.toString(sb.toString());
    }
}

