/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.comparators;

import java.util.Comparator;
import javax.naming.NamingException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.schema.LdapComparator;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.schema.comparators.ComparableComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializableComparator<E>
extends LdapComparator<E> {
    private static final long serialVersionUID = 3257566226288162870L;
    private String matchingRuleOid;
    private transient Comparator<E> wrapped;
    private transient SchemaManager schemaManager;

    public SerializableComparator(String matchingRuleOid) {
        super(matchingRuleOid);
        this.matchingRuleOid = matchingRuleOid;
    }

    @Override
    public int compare(E o1, E o2) {
        if (this.wrapped == null) {
            try {
                this.wrapped = this.schemaManager.lookupComparatorRegistry(this.matchingRuleOid);
            }
            catch (NamingException e) {
                throw new RuntimeException(I18n.err((String)"ERR_04221", (Object[])new Object[]{this.matchingRuleOid}));
            }
        }
        return this.wrapped.compare(o1, o2);
    }

    @Override
    public void setSchemaManager(SchemaManager schemaManager) {
        if (this.wrapped == null) {
            try {
                this.wrapped = schemaManager.lookupComparatorRegistry(this.matchingRuleOid);
            }
            catch (NamingException ne) {
                this.wrapped = new ComparableComparator<E>(this.matchingRuleOid);
            }
        }
        ((LdapComparator)this.wrapped).setSchemaManager(schemaManager);
        super.setSchemaManager(schemaManager);
    }
}

