/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifparser.model.container;

import java.util.ArrayList;
import org.apache.directory.studio.ldifparser.model.LdifPart;
import org.apache.directory.studio.ldifparser.model.container.LdifContainer;
import org.apache.directory.studio.ldifparser.model.lines.LdifAttrValLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifModSpecSepLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifModSpecTypeLine;

public class LdifModSpec
extends LdifContainer
implements LdifPart {
    private static final long serialVersionUID = 6708749639253050273L;

    protected LdifModSpec() {
    }

    public LdifModSpec(LdifModSpecTypeLine modSpecTypeLine) {
        super(modSpecTypeLine);
    }

    public void addAttrVal(LdifAttrValLine attrVal) {
        if (attrVal == null) {
            throw new IllegalArgumentException("null argument");
        }
        this.parts.add(attrVal);
    }

    public void finish(LdifModSpecSepLine modSpecSepLine) {
        if (modSpecSepLine == null) {
            throw new IllegalArgumentException("null argument");
        }
        this.parts.add(modSpecSepLine);
    }

    public LdifModSpecTypeLine getModSpecType() {
        return (LdifModSpecTypeLine)this.parts.get(0);
    }

    public LdifAttrValLine[] getAttrVals() {
        ArrayList l = new ArrayList();
        for (Object o : this.parts) {
            if (!(o instanceof LdifAttrValLine)) continue;
            l.add(o);
        }
        return l.toArray(new LdifAttrValLine[l.size()]);
    }

    public LdifModSpecSepLine getModSpecSep() {
        if (this.getLastPart() instanceof LdifModSpecSepLine) {
            return (LdifModSpecSepLine)this.getLastPart();
        }
        return null;
    }

    public boolean isAdd() {
        return this.getModSpecType().isAdd();
    }

    public boolean isReplace() {
        return this.getModSpecType().isReplace();
    }

    public boolean isDelete() {
        return this.getModSpecType().isDelete();
    }

    public static LdifModSpec createAdd(String attributeName) {
        return new LdifModSpec(LdifModSpecTypeLine.createAdd(attributeName));
    }

    public static LdifModSpec createReplace(String attributeName) {
        return new LdifModSpec(LdifModSpecTypeLine.createReplace(attributeName));
    }

    public static LdifModSpec createDelete(String attributeName) {
        return new LdifModSpec(LdifModSpecTypeLine.createDelete(attributeName));
    }

    @Override
    public boolean isValid() {
        if (!super.isAbstractValid()) {
            return false;
        }
        if (this.getModSpecType() == null) {
            return false;
        }
        LdifAttrValLine[] attrVals = this.getAttrVals();
        if (attrVals.length > 0) {
            String att = this.getModSpecType().getUnfoldedAttributeDescription();
            for (int i = 0; i < attrVals.length; ++i) {
                if (att.equalsIgnoreCase(attrVals[i].getUnfoldedAttributeDescription())) continue;
                return false;
            }
        }
        if (this.isAdd()) {
            return attrVals.length > 0;
        }
        if (this.isDelete()) {
            return true;
        }
        return this.isReplace();
    }

    @Override
    public String getInvalidString() {
        if (this.getModSpecType() == null) {
            return "Missing mod spec line ";
        }
        if (this.isAdd() && this.getAttrVals().length == 0) {
            return "Modification must contain attribute value lines ";
        }
        LdifAttrValLine[] attrVals = this.getAttrVals();
        if (attrVals.length > 0) {
            String att = this.getModSpecType().getUnfoldedAttributeDescription();
            for (int i = 0; i < attrVals.length; ++i) {
                if (att.equalsIgnoreCase(attrVals[i].getUnfoldedAttributeDescription())) continue;
                return "Attribute descriptions don't match";
            }
        }
        return null;
    }
}

