/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifparser.model.lines;

import org.apache.directory.studio.ldifparser.LdifParserConstants;
import org.apache.directory.studio.ldifparser.LdifUtils;
import org.apache.directory.studio.ldifparser.model.lines.LdifValueLineBase;

public class LdifControlLine
extends LdifValueLineBase {
    private static final long serialVersionUID = -3961159214439218610L;
    private String rawCriticality;
    private String rawControlValueType;
    private String rawControlValue;

    protected LdifControlLine() {
    }

    public LdifControlLine(int offset, String rawControlSpec, String rawControlType, String rawOid, String rawCriticality, String rawControlValueType, String rawControlValue, String rawNewLine) {
        super(offset, rawControlSpec, rawControlType, rawOid, rawNewLine);
        this.rawCriticality = rawCriticality;
        this.rawControlValueType = rawControlValueType;
        this.rawControlValue = rawControlValue;
    }

    public String getRawControlSpec() {
        return super.getRawLineStart();
    }

    public String getUnfoldedControlSpec() {
        return super.getUnfoldedLineStart();
    }

    public String getRawControlType() {
        return super.getRawValueType();
    }

    public String getUnfoldedControlType() {
        return super.getUnfoldedValueType();
    }

    public String getRawOid() {
        return super.getRawValue();
    }

    public String getUnfoldedOid() {
        return super.getUnfoldedValue();
    }

    public String getRawCriticality() {
        return LdifControlLine.getNonNull(this.rawCriticality);
    }

    public String getUnfoldedCriticality() {
        return LdifControlLine.unfold(this.getRawCriticality());
    }

    public boolean isCritical() {
        return this.getUnfoldedCriticality().endsWith("true");
    }

    public String getRawControlValueType() {
        return LdifControlLine.getNonNull(this.rawControlValueType);
    }

    public String getUnfoldedControlValueType() {
        return LdifControlLine.unfold(this.getRawControlValueType());
    }

    public String getRawControlValue() {
        return LdifControlLine.getNonNull(this.rawControlValue);
    }

    public String getUnfoldedControlValue() {
        return LdifControlLine.unfold(this.getRawControlValue());
    }

    @Override
    public String toRawString() {
        return this.getRawControlSpec() + this.getRawControlType() + this.getRawOid() + this.getRawCriticality() + this.getRawControlValueType() + this.getRawControlValue() + this.getRawNewLine();
    }

    @Override
    public boolean isValid() {
        return this.getUnfoldedControlSpec().length() > 0 && this.getUnfoldedControlType().length() > 0 && this.getUnfoldedOid().length() > 0 && (this.rawCriticality == null || this.getUnfoldedCriticality().endsWith("true") || this.getUnfoldedCriticality().endsWith("false")) && (this.rawControlValueType == null && this.rawControlValue == null || this.rawControlValueType != null && this.rawControlValue != null) && this.getUnfoldedNewLine().length() > 0;
    }

    @Override
    public String getInvalidString() {
        if (this.getUnfoldedControlSpec().length() == 0) {
            return "Missing 'control'";
        }
        if (this.getUnfoldedOid().length() == 0) {
            return "Missing OID";
        }
        if (this.rawCriticality != null && !this.getUnfoldedCriticality().endsWith("true") && !this.getUnfoldedCriticality().endsWith("false")) {
            return "Invalid criticality, must be 'true' or 'false'";
        }
        return super.getInvalidString();
    }

    public final byte[] getControlValueAsBinary() {
        Object o = this.getControlValueAsObject();
        if (o instanceof String) {
            return LdifUtils.utf8encode((String)o);
        }
        if (o instanceof byte[]) {
            return (byte[])o;
        }
        return new byte[0];
    }

    public final Object getControlValueAsObject() {
        if (this.isControlValueTypeSafe()) {
            return this.getUnfoldedControlValue();
        }
        if (this.isControlValueTypeBase64()) {
            return LdifUtils.base64decodeToByteArray(this.getUnfoldedControlValue());
        }
        return null;
    }

    public boolean isControlValueTypeBase64() {
        return this.getUnfoldedControlValueType().startsWith("::");
    }

    public boolean isControlValueTypeSafe() {
        return this.getUnfoldedControlValueType().startsWith(":") && !this.isControlValueTypeBase64();
    }

    public static LdifControlLine create(String oid, String criticality, String controlValue) {
        if (LdifUtils.mustEncode(controlValue)) {
            return LdifControlLine.create(oid, criticality, LdifUtils.utf8encode(controlValue));
        }
        LdifControlLine controlLine = new LdifControlLine(0, "control", ":", oid, criticality, controlValue != null ? ":" : null, controlValue != null ? controlValue : null, LdifParserConstants.LINE_SEPARATOR);
        return controlLine;
    }

    public static LdifControlLine create(String oid, String criticality, byte[] controlValue) {
        LdifControlLine controlLine = new LdifControlLine(0, "control", ":", oid, criticality, controlValue != null && controlValue.length > 0 ? "::" : null, controlValue != null && controlValue.length > 0 ? LdifUtils.base64encode(controlValue) : null, LdifParserConstants.LINE_SEPARATOR);
        return controlLine;
    }

    public static LdifControlLine create(String oid, boolean isCritical, String controlValue) {
        return LdifControlLine.create(oid, isCritical ? " true" : " false", controlValue);
    }

    public static LdifControlLine create(String oid, boolean isCritical, byte[] controlValue) {
        return LdifControlLine.create(oid, isCritical ? " true" : " false", controlValue);
    }
}

