/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifparser.parser;

import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import org.apache.directory.studio.ldifparser.parser.LdifToken;

public class LdifScanner {
    private Reader ldifReader;
    private char[] buffer = new char[256];
    private StringBuffer ldifBuffer;
    private int ldifBufferOffset;
    private int pos;

    public void setLdif(Reader ldifReader) {
        this.ldifReader = ldifReader;
        this.pos = -1;
        this.ldifBuffer = new StringBuffer();
        this.ldifBufferOffset = 0;
    }

    char currentChar() throws EOFException {
        try {
            int num = 0;
            while (this.ldifBufferOffset + this.ldifBuffer.length() <= this.pos && num > -1) {
                num = this.ldifReader.read(this.buffer);
                if (num <= -1) continue;
                this.ldifBuffer.append(this.buffer, 0, num);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (0 <= this.pos && this.pos < this.ldifBufferOffset + this.ldifBuffer.length()) {
            try {
                return this.ldifBuffer.charAt(this.pos - this.ldifBufferOffset);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw e;
            }
        }
        throw new EOFException();
    }

    void addFolding(StringBuffer sb) {
        int oldPos = this.pos++;
        try {
            char c = this.currentChar();
            if (c == '\n' || c == '\r') {
                StringBuffer temp = new StringBuffer(3);
                temp.append(c);
                if (c == '\r') {
                    ++this.pos;
                    c = this.currentChar();
                    if (c == '\n') {
                        temp.append(c);
                    } else {
                        --this.pos;
                    }
                } else if (c == '\n') {
                    ++this.pos;
                    c = this.currentChar();
                    if (c == '\r') {
                        temp.append(c);
                    } else {
                        --this.pos;
                    }
                }
                ++this.pos;
                c = this.currentChar();
                if (c == ' ') {
                    temp.append(c);
                    sb.append(temp);
                } else {
                    for (int i = 0; i < temp.length(); ++i) {
                        --this.pos;
                    }
                    --this.pos;
                }
            } else {
                --this.pos;
            }
        }
        catch (EOFException e) {
            this.pos = oldPos;
        }
    }

    public char read(StringBuffer sb) throws EOFException {
        try {
            ++this.pos;
            char c = this.currentChar();
            sb.append(c);
            this.addFolding(sb);
            return c;
        }
        catch (EOFException e) {
            --this.pos;
            throw e;
        }
    }

    void removeFolding(StringBuffer sb) {
        int oldPos = this.pos--;
        try {
            char c = this.currentChar();
            if (c == ' ') {
                StringBuffer temp = new StringBuffer();
                temp.insert(0, c);
                c = this.currentChar();
                --this.pos;
                if (c == '\n' || c == '\r') {
                    if (c == '\r') {
                        temp.insert(0, c);
                        c = this.currentChar();
                        --this.pos;
                        if (c == '\n') {
                            temp.insert(0, c);
                        } else {
                            ++this.pos;
                        }
                    } else if (c == '\n') {
                        temp.insert(0, c);
                        c = this.currentChar();
                        --this.pos;
                        if (c == '\r') {
                            temp.insert(0, c);
                        } else {
                            ++this.pos;
                        }
                    }
                    sb.delete(sb.length() - temp.length(), sb.length());
                } else {
                    ++this.pos;
                    ++this.pos;
                }
            } else {
                ++this.pos;
            }
        }
        catch (EOFException e) {
            this.pos = oldPos;
        }
    }

    public void unread(StringBuffer sb) {
        this.removeFolding(sb);
        if (this.pos > -1) {
            --this.pos;
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
        }
    }

    private String getFullLine(String start) {
        String s1 = this.getWord(start);
        if (s1 != null) {
            String s2 = this.getContent(false);
            return s2 != null ? s1 + s2 : s1;
        }
        return null;
    }

    private String getContent(boolean allowEmptyContent) {
        StringBuffer sb = new StringBuffer(256);
        try {
            int c = 0;
            while (c != 10 && c != 13) {
                c = this.read(sb);
            }
            this.unread(sb);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return sb.length() > 0 || allowEmptyContent ? sb.toString() : null;
    }

    private String getWord(String word) {
        StringBuffer sb = new StringBuffer();
        try {
            boolean matches = true;
            for (int i = 0; i < word.length(); ++i) {
                char c = this.read(sb);
                if (Character.toUpperCase(c) == Character.toUpperCase(word.charAt(i))) continue;
                matches = false;
                this.unread(sb);
                break;
            }
            if (matches) {
                return sb.toString();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        while (sb.length() > 0) {
            this.unread(sb);
        }
        return null;
    }

    private String getWordTillColon(String word) {
        String wordWithColon = word + ":";
        String line = this.getWord(wordWithColon);
        if (line != null) {
            StringBuffer sb = new StringBuffer(line);
            this.unread(sb);
            return sb.toString();
        }
        line = this.getWord(word);
        if (line != null) {
            StringBuffer sb = new StringBuffer(line);
            try {
                char c = this.read(sb);
                this.unread(sb);
                if (c == '\r' || c == '\n') {
                    return sb.toString();
                }
                while (sb.length() > 0) {
                    this.unread(sb);
                }
                return null;
            }
            catch (EOFException e) {
                return sb.toString();
            }
        }
        return null;
    }

    private void flushBuffer() {
        if (this.ldifBufferOffset < this.pos && this.ldifBuffer.length() > 0) {
            int delta = Math.min(this.pos - this.ldifBufferOffset, this.ldifBuffer.length());
            this.ldifBuffer.delete(0, --delta);
            this.ldifBufferOffset += delta;
        }
    }

    public LdifToken matchCleanupLine() {
        this.flushBuffer();
        String line = this.getContent(false);
        LdifToken sep = this.matchSep();
        if (line != null || sep != null) {
            if (line == null) {
                line = "";
            }
            if (sep != null) {
                line = line + sep.getValue();
            }
            return new LdifToken(0, line, this.pos - line.length() + 1);
        }
        return null;
    }

    public LdifToken matchOther() {
        this.flushBuffer();
        String line = this.getContent(false);
        if (line != null) {
            LdifToken sep = this.matchSep();
            if (sep != null) {
                line = line + sep.getValue();
            }
            return new LdifToken(0, line, this.pos - line.length() + 1);
        }
        return null;
    }

    public LdifToken matchEOF() {
        this.flushBuffer();
        StringBuffer sb = new StringBuffer(1);
        try {
            this.read(sb);
            this.unread(sb);
            return null;
        }
        catch (EOFException e) {
            return new LdifToken(-1, "", this.pos + 1);
        }
    }

    public LdifToken matchSep() {
        this.flushBuffer();
        try {
            StringBuffer sb = new StringBuffer();
            char c = this.read(sb);
            if (c == '\n' || c == '\r') {
                try {
                    if (c == '\r') {
                        c = this.read(sb);
                        if (c != '\n') {
                            this.unread(sb);
                        }
                    } else if (c == '\n' && (c = this.read(sb)) != '\r') {
                        this.unread(sb);
                    }
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
                return new LdifToken(2, sb.toString(), this.pos - sb.length() + 1);
            }
            this.unread(sb);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return null;
    }

    public LdifToken matchComment() {
        this.flushBuffer();
        String line = this.getFullLine("#");
        if (line != null) {
            return new LdifToken(1, line, this.pos - line.length() + 1);
        }
        return null;
    }

    public LdifToken matchVersionSpec() {
        this.flushBuffer();
        String line = this.getWordTillColon("version");
        if (line != null) {
            return new LdifToken(4, line, this.pos - line.length() + 1);
        }
        return null;
    }

    public LdifToken matchDnSpec() {
        this.flushBuffer();
        String line = this.getWordTillColon("dn");
        if (line != null) {
            return new LdifToken(11, line, this.pos - line.length() + 1);
        }
        return null;
    }

    public LdifToken matchControlSpec() {
        this.flushBuffer();
        String line = this.getWordTillColon("control");
        if (line != null) {
            return new LdifToken(51, line, this.pos - line.length() + 1);
        }
        return null;
    }

    public LdifToken matchChangeTypeSpec() {
        this.flushBuffer();
        String line = this.getWordTillColon("changetype");
        if (line != null) {
            return new LdifToken(30, line, this.pos - line.length() + 1);
        }
        return null;
    }

    public LdifToken matchChangeType() {
        this.flushBuffer();
        String line = this.getWord("add");
        if (line != null) {
            return new LdifToken(31, line, this.pos - line.length() + 1);
        }
        line = this.getWord("modify");
        if (line != null) {
            return new LdifToken(33, line, this.pos - line.length() + 1);
        }
        line = this.getWord("delete");
        if (line != null) {
            return new LdifToken(32, line, this.pos - line.length() + 1);
        }
        line = this.getWord("moddn");
        if (line != null) {
            return new LdifToken(34, line, this.pos - line.length() + 1);
        }
        line = this.getWord("modrdn");
        if (line != null) {
            return new LdifToken(34, line, this.pos - line.length() + 1);
        }
        return null;
    }

    public LdifToken matchCriticality() {
        this.flushBuffer();
        StringBuffer sb = new StringBuffer();
        String s = this.getWord(" ");
        while (s != null) {
            sb.append(s);
            s = this.getWord(" ");
        }
        String t = this.getWord("true");
        if (t != null) {
            sb.append(t);
            return new LdifToken(53, sb.toString(), this.pos - sb.length() + 1);
        }
        String f = this.getWord("false");
        if (f != null) {
            sb.append(f);
            return new LdifToken(54, sb.toString(), this.pos - sb.length() + 1);
        }
        while (sb.length() > 0) {
            this.unread(sb);
        }
        return null;
    }

    public LdifToken matchNumber() {
        this.flushBuffer();
        try {
            StringBuffer sb = new StringBuffer();
            char c = this.read(sb);
            if ('0' <= c && c <= '9') {
                try {
                    while ('0' <= c && c <= '9') {
                        c = this.read(sb);
                    }
                    this.unread(sb);
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
                return new LdifToken(5, sb.toString(), this.pos - sb.length() + 1);
            }
            this.unread(sb);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return null;
    }

    public LdifToken matchOid() {
        this.flushBuffer();
        try {
            StringBuffer sb = new StringBuffer();
            char c = this.read(sb);
            if ('0' <= c && c <= '9') {
                try {
                    while ('0' <= c && c <= '9' || c == '.') {
                        c = this.read(sb);
                    }
                    this.unread(sb);
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
                return new LdifToken(6, sb.toString(), this.pos - sb.length() + 1);
            }
            this.unread(sb);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return null;
    }

    public LdifToken matchAttributeDescription() {
        this.flushBuffer();
        try {
            StringBuffer sb = new StringBuffer();
            char c = this.read(sb);
            if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9') {
                try {
                    while ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '.' || c == ';' || c == '-' || c == '_') {
                        c = this.read(sb);
                    }
                    this.unread(sb);
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
                return new LdifToken(21, sb.toString(), this.pos - sb.length() + 1);
            }
            this.unread(sb);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return null;
    }

    public LdifToken matchModTypeSpec() {
        this.flushBuffer();
        String line = this.getWord("add");
        if (line != null) {
            return new LdifToken(41, line, this.pos - line.length() + 1);
        }
        line = this.getWord("replace");
        if (line != null) {
            return new LdifToken(43, line, this.pos - line.length() + 1);
        }
        line = this.getWord("delete");
        if (line != null) {
            return new LdifToken(42, line, this.pos - line.length() + 1);
        }
        return null;
    }

    public LdifToken matchModSep() {
        this.flushBuffer();
        String line = this.getWord("-");
        if (line != null) {
            return new LdifToken(45, line, this.pos - line.length() + 1);
        }
        return null;
    }

    public LdifToken matchValueType() {
        this.flushBuffer();
        try {
            StringBuffer sb = new StringBuffer();
            char c = this.read(sb);
            if (c == ':') {
                int tokenType = 22;
                try {
                    c = this.read(sb);
                    if (c == ':') {
                        tokenType = 23;
                    } else if (c == '<') {
                        tokenType = 24;
                    } else {
                        tokenType = 22;
                        this.unread(sb);
                    }
                    c = this.read(sb);
                    while (c == ' ') {
                        c = this.read(sb);
                    }
                    this.unread(sb);
                }
                catch (EOFException e) {
                    // empty catch block
                }
                return new LdifToken(tokenType, sb.toString(), this.pos - sb.length() + 1);
            }
            this.unread(sb);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return null;
    }

    public LdifToken matchValue() {
        this.flushBuffer();
        String line = this.getContent(true);
        if (line != null) {
            return new LdifToken(27, line, this.pos - line.length() + 1);
        }
        return null;
    }

    public LdifToken matchNewrdnSpec() {
        this.flushBuffer();
        String line = this.getWordTillColon("newrdn");
        if (line != null) {
            return new LdifToken(61, line, this.pos - line.length() + 1);
        }
        return null;
    }

    public LdifToken matchDeleteoldrdnSpec() {
        this.flushBuffer();
        String line = this.getWordTillColon("deleteoldrdn");
        if (line != null) {
            return new LdifToken(63, line, this.pos - line.length() + 1);
        }
        return null;
    }

    public LdifToken matchNewsuperiorSpec() {
        this.flushBuffer();
        String line = this.getWordTillColon("newsuperior");
        if (line != null) {
            return new LdifToken(65, line, this.pos - line.length() + 1);
        }
        return null;
    }
}

