/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.ResourcesService;
import org.apache.dolphinscheduler.api.service.UdfFuncService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.ResourceType;
import org.apache.dolphinscheduler.common.enums.UdfType;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.dao.entity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"RESOURCES_TAG"}, position=1)
@RestController
@RequestMapping(value={"resources"})
public class ResourcesController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(ResourcesController.class);
    @Autowired
    private ResourcesService resourceService;
    @Autowired
    private UdfFuncService udfFuncService;

    @ApiOperation(value="createResource", notes="CREATE_RESOURCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="type", value="RESOURCE_TYPE", required=true, dataType="ResourceType"), @ApiImplicitParam(name="name", value="RESOURCE_NAME", required=true, dataType="String"), @ApiImplicitParam(name="description", value="RESOURCE_DESC", dataType="String"), @ApiImplicitParam(name="file", value="RESOURCE_FILE", required=true, dataType="MultipartFile")})
    @PostMapping(value={"/create"})
    public Result createResource(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="type") ResourceType type, @RequestParam(value="name") String alias, @RequestParam(value="description", required=false) String description, @RequestParam(value="file") MultipartFile file) {
        try {
            logger.info("login user {}, create resource, type: {}, resource alias: {}, desc: {}, file: {},{}", new Object[]{loginUser.getUserName(), type, alias, description, file.getName(), file.getOriginalFilename()});
            return this.resourceService.createResource(loginUser, alias, description, type, file);
        }
        catch (Exception e) {
            logger.error(Status.CREATE_RESOURCE_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.CREATE_RESOURCE_ERROR.getCode(), Status.CREATE_RESOURCE_ERROR.getMsg());
        }
    }

    @ApiOperation(value="updateResource", notes="UPDATE_RESOURCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="RESOURCE_ID", required=true, dataType="Int", example="100"), @ApiImplicitParam(name="type", value="RESOURCE_TYPE", required=true, dataType="ResourceType"), @ApiImplicitParam(name="name", value="RESOURCE_NAME", required=true, dataType="String"), @ApiImplicitParam(name="description", value="RESOURCE_DESC", dataType="String"), @ApiImplicitParam(name="file", value="RESOURCE_FILE", required=true, dataType="MultipartFile")})
    @PostMapping(value={"/update"})
    public Result updateResource(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="id") int resourceId, @RequestParam(value="type") ResourceType type, @RequestParam(value="name") String alias, @RequestParam(value="description", required=false) String description) {
        try {
            logger.info("login user {}, update resource, type: {}, resource alias: {}, desc: {}", new Object[]{loginUser.getUserName(), type, alias, description});
            return this.resourceService.updateResource(loginUser, resourceId, alias, description, type);
        }
        catch (Exception e) {
            logger.error(Status.UPDATE_RESOURCE_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.UPDATE_RESOURCE_ERROR.getCode(), Status.UPDATE_RESOURCE_ERROR.getMsg());
        }
    }

    @ApiOperation(value="queryResourceList", notes="QUERY_RESOURCE_LIST_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="type", value="RESOURCE_TYPE", required=true, dataType="ResourceType")})
    @GetMapping(value={"/list"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result queryResourceList(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="type") ResourceType type) {
        try {
            logger.info("query resource list, login user:{}, resource type:{}", (Object)loginUser.getUserName(), (Object)type.toString());
            Map<String, Object> result = this.resourceService.queryResourceList(loginUser, type);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.QUERY_RESOURCES_LIST_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.QUERY_RESOURCES_LIST_ERROR.getCode(), Status.QUERY_RESOURCES_LIST_ERROR.getMsg());
        }
    }

    @ApiOperation(value="queryResourceListPaging", notes="QUERY_RESOURCE_LIST_PAGING_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="type", value="RESOURCE_TYPE", required=true, dataType="ResourceType"), @ApiImplicitParam(name="searchVal", value="SEARCH_VAL", dataType="String"), @ApiImplicitParam(name="pageNo", value="PAGE_NO", dataType="Int", example="1"), @ApiImplicitParam(name="pageSize", value="PAGE_SIZE", dataType="Int", example="20")})
    @GetMapping(value={"/list-paging"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result queryResourceListPaging(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="type") ResourceType type, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="pageSize") Integer pageSize) {
        try {
            logger.info("query resource list, login user:{}, resource type:{}, search value:{}", new Object[]{loginUser.getUserName(), type.toString(), searchVal});
            Map<String, Object> result = this.checkPageParams(pageNo, pageSize);
            if (result.get("status") != Status.SUCCESS) {
                return this.returnDataListPaging(result);
            }
            searchVal = ParameterUtils.handleEscapes((String)searchVal);
            result = this.resourceService.queryResourceListPaging(loginUser, type, searchVal, pageNo, pageSize);
            return this.returnDataListPaging(result);
        }
        catch (Exception e) {
            logger.error(Status.QUERY_RESOURCES_LIST_PAGING.getMsg(), (Throwable)e);
            return this.error(Status.QUERY_RESOURCES_LIST_PAGING.getCode(), Status.QUERY_RESOURCES_LIST_PAGING.getMsg());
        }
    }

    @ApiOperation(value="deleteResource", notes="DELETE_RESOURCE_BY_ID_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="RESOURCE_ID", required=true, dataType="Int", example="100")})
    @GetMapping(value={"/delete"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result deleteResource(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="id") int resourceId) {
        try {
            logger.info("login user {}, delete resource id: {}", (Object)loginUser.getUserName(), (Object)resourceId);
            return this.resourceService.delete(loginUser, resourceId);
        }
        catch (Exception e) {
            logger.error(Status.DELETE_RESOURCE_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.DELETE_RESOURCE_ERROR.getCode(), Status.DELETE_RESOURCE_ERROR.getMsg());
        }
    }

    @ApiOperation(value="verifyResourceName", notes="VERIFY_RESOURCE_NAME_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="type", value="RESOURCE_TYPE", required=true, dataType="ResourceType"), @ApiImplicitParam(name="name", value="RESOURCE_NAME", required=true, dataType="String")})
    @GetMapping(value={"/verify-name"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result verifyResourceName(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="name") String alias, @RequestParam(value="type") ResourceType type) {
        try {
            logger.info("login user {}, verfiy resource alias: {},resource type: {}", new Object[]{loginUser.getUserName(), alias, type});
            return this.resourceService.verifyResourceName(alias, type, loginUser);
        }
        catch (Exception e) {
            logger.error(Status.VERIFY_RESOURCE_BY_NAME_AND_TYPE_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.VERIFY_RESOURCE_BY_NAME_AND_TYPE_ERROR.getCode(), Status.VERIFY_RESOURCE_BY_NAME_AND_TYPE_ERROR.getMsg());
        }
    }

    @ApiOperation(value="viewResource", notes="VIEW_RESOURCE_BY_ID_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="RESOURCE_ID", required=true, dataType="Int", example="100"), @ApiImplicitParam(name="skipLineNum", value="SKIP_LINE_NUM", required=true, dataType="Int", example="100"), @ApiImplicitParam(name="limit", value="LIMIT", required=true, dataType="Int", example="100")})
    @GetMapping(value={"/view"})
    public Result viewResource(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="id") int resourceId, @RequestParam(value="skipLineNum") int skipLineNum, @RequestParam(value="limit") int limit) {
        try {
            logger.info("login user {}, view resource : {}, skipLineNum {} , limit {}", new Object[]{loginUser.getUserName(), resourceId, skipLineNum, limit});
            return this.resourceService.readResource(resourceId, skipLineNum, limit);
        }
        catch (Exception e) {
            logger.error(Status.VIEW_RESOURCE_FILE_ON_LINE_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.VIEW_RESOURCE_FILE_ON_LINE_ERROR.getCode(), Status.VIEW_RESOURCE_FILE_ON_LINE_ERROR.getMsg());
        }
    }

    @ApiOperation(value="onlineCreateResource", notes="ONLINE_CREATE_RESOURCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="type", value="RESOURCE_TYPE", required=true, dataType="ResourceType"), @ApiImplicitParam(name="fileName", value="RESOURCE_NAME", required=true, dataType="String"), @ApiImplicitParam(name="suffix", value="SUFFIX", required=true, dataType="String"), @ApiImplicitParam(name="description", value="RESOURCE_DESC", dataType="String"), @ApiImplicitParam(name="content", value="CONTENT", required=true, dataType="String")})
    @PostMapping(value={"/online-create"})
    public Result onlineCreateResource(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="type") ResourceType type, @RequestParam(value="fileName") String fileName, @RequestParam(value="suffix") String fileSuffix, @RequestParam(value="description", required=false) String description, @RequestParam(value="content") String content) {
        try {
            logger.info("login user {}, online create resource! fileName : {}, type : {}, suffix : {},desc : {},content : {}", new Object[]{loginUser.getUserName(), type, fileName, fileSuffix, description, content});
            if (StringUtils.isEmpty((String)content)) {
                logger.error("resource file contents are not allowed to be empty");
                return this.error(Status.RESOURCE_FILE_IS_EMPTY.getCode(), Status.RESOURCE_FILE_IS_EMPTY.getMsg());
            }
            return this.resourceService.onlineCreateResource(loginUser, type, fileName, fileSuffix, description, content);
        }
        catch (Exception e) {
            logger.error(Status.CREATE_RESOURCE_FILE_ON_LINE_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.CREATE_RESOURCE_FILE_ON_LINE_ERROR.getCode(), Status.CREATE_RESOURCE_FILE_ON_LINE_ERROR.getMsg());
        }
    }

    @ApiOperation(value="updateResourceContent", notes="UPDATE_RESOURCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="RESOURCE_ID", required=true, dataType="Int", example="100"), @ApiImplicitParam(name="content", value="CONTENT", required=true, dataType="String")})
    @PostMapping(value={"/update-content"})
    public Result updateResourceContent(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="id") int resourceId, @RequestParam(value="content") String content) {
        try {
            logger.info("login user {}, updateProcessInstance resource : {}", (Object)loginUser.getUserName(), (Object)resourceId);
            if (StringUtils.isEmpty((String)content)) {
                logger.error("The resource file contents are not allowed to be empty");
                return this.error(Status.RESOURCE_FILE_IS_EMPTY.getCode(), Status.RESOURCE_FILE_IS_EMPTY.getMsg());
            }
            return this.resourceService.updateResourceContent(resourceId, content);
        }
        catch (Exception e) {
            logger.error(Status.EDIT_RESOURCE_FILE_ON_LINE_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.EDIT_RESOURCE_FILE_ON_LINE_ERROR.getCode(), Status.EDIT_RESOURCE_FILE_ON_LINE_ERROR.getMsg());
        }
    }

    @ApiOperation(value="downloadResource", notes="DOWNLOAD_RESOURCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="RESOURCE_ID", required=true, dataType="Int", example="100")})
    @GetMapping(value={"/download"})
    @ResponseBody
    public ResponseEntity downloadResource(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="id") int resourceId) {
        try {
            logger.info("login user {}, download resource : {}", (Object)loginUser.getUserName(), (Object)resourceId);
            Resource file = this.resourceService.downloadResource(resourceId);
            if (file == null) {
                return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)Status.RESOURCE_NOT_EXIST.getMsg());
            }
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"" + file.getFilename() + "\""})).body((Object)file);
        }
        catch (Exception e) {
            logger.error(Status.DOWNLOAD_RESOURCE_FILE_ERROR.getMsg(), (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)Status.DOWNLOAD_RESOURCE_FILE_ERROR.getMsg());
        }
    }

    @ApiOperation(value="createUdfFunc", notes="CREATE_UDF_FUNCTION_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="type", value="UDF_TYPE", required=true, dataType="UdfType"), @ApiImplicitParam(name="funcName", value="FUNC_NAME", required=true, dataType="String"), @ApiImplicitParam(name="suffix", value="CLASS_NAME", required=true, dataType="String"), @ApiImplicitParam(name="argTypes", value="ARG_TYPES", dataType="String"), @ApiImplicitParam(name="database", value="DATABASE_NAME", dataType="String"), @ApiImplicitParam(name="description", value="UDF_DESC", dataType="String"), @ApiImplicitParam(name="resourceId", value="RESOURCE_ID", required=true, dataType="Int", example="100")})
    @PostMapping(value={"/udf-func/create"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public Result createUdfFunc(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="type") UdfType type, @RequestParam(value="funcName") String funcName, @RequestParam(value="className") String className, @RequestParam(value="argTypes", required=false) String argTypes, @RequestParam(value="database", required=false) String database, @RequestParam(value="description", required=false) String description, @RequestParam(value="resourceId") int resourceId) {
        logger.info("login user {}, create udf function, type: {},  funcName: {},argTypes: {} ,database: {},desc: {},resourceId: {}", new Object[]{loginUser.getUserName(), type, funcName, argTypes, database, description, resourceId});
        Result result = new Result();
        try {
            return this.udfFuncService.createUdfFunction(loginUser, funcName, className, argTypes, database, description, type, resourceId);
        }
        catch (Exception e) {
            logger.error(Status.CREATE_UDF_FUNCTION_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.CREATE_UDF_FUNCTION_ERROR.getCode(), Status.CREATE_UDF_FUNCTION_ERROR.getMsg());
        }
    }

    @ApiOperation(value="viewUIUdfFunction", notes="VIEW_UDF_FUNCTION_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="resourceId", value="RESOURCE_ID", required=true, dataType="Int", example="100")})
    @GetMapping(value={"/udf-func/update-ui"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result viewUIUdfFunction(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="id") int id) {
        logger.info("login user {}, query udf{}", (Object)loginUser.getUserName(), (Object)id);
        try {
            Map<String, Object> map = this.udfFuncService.queryUdfFuncDetail(id);
            return this.returnDataList(map);
        }
        catch (Exception e) {
            logger.error(Status.VIEW_UDF_FUNCTION_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.VIEW_UDF_FUNCTION_ERROR.getCode(), Status.VIEW_UDF_FUNCTION_ERROR.getMsg());
        }
    }

    @ApiOperation(value="updateUdfFunc", notes="UPDATE_UDF_FUNCTION_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="type", value="UDF_TYPE", required=true, dataType="UdfType"), @ApiImplicitParam(name="funcName", value="FUNC_NAME", required=true, dataType="String"), @ApiImplicitParam(name="suffix", value="CLASS_NAME", required=true, dataType="String"), @ApiImplicitParam(name="argTypes", value="ARG_TYPES", dataType="String"), @ApiImplicitParam(name="database", value="DATABASE_NAME", dataType="String"), @ApiImplicitParam(name="description", value="UDF_DESC", dataType="String"), @ApiImplicitParam(name="id", value="RESOURCE_ID", required=true, dataType="Int", example="100")})
    @PostMapping(value={"/udf-func/update"})
    public Result updateUdfFunc(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="id") int udfFuncId, @RequestParam(value="type") UdfType type, @RequestParam(value="funcName") String funcName, @RequestParam(value="className") String className, @RequestParam(value="argTypes", required=false) String argTypes, @RequestParam(value="database", required=false) String database, @RequestParam(value="description", required=false) String description, @RequestParam(value="resourceId") int resourceId) {
        try {
            logger.info("login user {}, updateProcessInstance udf function id: {},type: {},  funcName: {},argTypes: {} ,database: {},desc: {},resourceId: {}", new Object[]{loginUser.getUserName(), udfFuncId, type, funcName, argTypes, database, description, resourceId});
            Map<String, Object> result = this.udfFuncService.updateUdfFunc(udfFuncId, funcName, className, argTypes, database, description, type, resourceId);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.UPDATE_UDF_FUNCTION_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.UPDATE_UDF_FUNCTION_ERROR.getCode(), Status.UPDATE_UDF_FUNCTION_ERROR.getMsg());
        }
    }

    @ApiOperation(value="queryUdfFuncListPaging", notes="QUERY_UDF_FUNCTION_LIST_PAGING_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="searchVal", value="SEARCH_VAL", dataType="String"), @ApiImplicitParam(name="pageNo", value="PAGE_NO", dataType="Int", example="1"), @ApiImplicitParam(name="pageSize", value="PAGE_SIZE", dataType="Int", example="20")})
    @GetMapping(value={"/udf-func/list-paging"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result queryUdfFuncList(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="pageSize") Integer pageSize) {
        try {
            logger.info("query udf functions list, login user:{},search value:{}", (Object)loginUser.getUserName(), (Object)searchVal);
            Map<String, Object> result = this.checkPageParams(pageNo, pageSize);
            if (result.get("status") != Status.SUCCESS) {
                return this.returnDataListPaging(result);
            }
            result = this.udfFuncService.queryUdfFuncListPaging(loginUser, searchVal, pageNo, pageSize);
            return this.returnDataListPaging(result);
        }
        catch (Exception e) {
            logger.error(Status.QUERY_UDF_FUNCTION_LIST_PAGING_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.QUERY_UDF_FUNCTION_LIST_PAGING_ERROR.getCode(), Status.QUERY_UDF_FUNCTION_LIST_PAGING_ERROR.getMsg());
        }
    }

    @ApiOperation(value="queryResourceList", notes="QUERY_RESOURCE_LIST_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="type", value="UDF_TYPE", required=true, dataType="UdfType")})
    @GetMapping(value={"/udf-func/list"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result queryResourceList(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="type") UdfType type) {
        try {
            logger.info("query datasource list, user:{}, type:{}", (Object)loginUser.getUserName(), (Object)type.toString());
            Map<String, Object> result = this.udfFuncService.queryResourceList(loginUser, type.ordinal());
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.QUERY_DATASOURCE_BY_TYPE_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.QUERY_DATASOURCE_BY_TYPE_ERROR.getCode(), Status.QUERY_DATASOURCE_BY_TYPE_ERROR.getMsg());
        }
    }

    @ApiOperation(value="verifyUdfFuncName", notes="VERIFY_UDF_FUNCTION_NAME_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="name", value="FUNC_NAME", required=true, dataType="String")})
    @GetMapping(value={"/udf-func/verify-name"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result verifyUdfFuncName(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="name") String name) {
        logger.info("login user {}, verfiy udf function name: {}", (Object)loginUser.getUserName(), (Object)name);
        try {
            return this.udfFuncService.verifyUdfFuncByName(name);
        }
        catch (Exception e) {
            logger.error(Status.VERIFY_UDF_FUNCTION_NAME_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.VERIFY_UDF_FUNCTION_NAME_ERROR.getCode(), Status.VERIFY_UDF_FUNCTION_NAME_ERROR.getMsg());
        }
    }

    @ApiOperation(value="deleteUdfFunc", notes="DELETE_UDF_FUNCTION_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="RESOURCE_ID", required=true, dataType="Int", example="100")})
    @GetMapping(value={"/udf-func/delete"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result deleteUdfFunc(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="id") int udfFuncId) {
        try {
            logger.info("login user {}, delete udf function id: {}", (Object)loginUser.getUserName(), (Object)udfFuncId);
            return this.udfFuncService.delete(udfFuncId);
        }
        catch (Exception e) {
            logger.error(Status.DELETE_UDF_FUNCTION_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.DELETE_UDF_FUNCTION_ERROR.getCode(), Status.DELETE_UDF_FUNCTION_ERROR.getMsg());
        }
    }

    @ApiOperation(value="authorizedFile", notes="AUTHORIZED_FILE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="USER_ID", required=true, dataType="Int", example="100")})
    @GetMapping(value={"/authed-file"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public Result authorizedFile(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") Integer userId) {
        try {
            logger.info("authorized file resource, user: {}, user id:{}", (Object)loginUser.getUserName(), (Object)userId);
            Map<String, Object> result = this.resourceService.authorizedFile(loginUser, userId);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.AUTHORIZED_FILE_RESOURCE_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.AUTHORIZED_FILE_RESOURCE_ERROR.getCode(), Status.AUTHORIZED_FILE_RESOURCE_ERROR.getMsg());
        }
    }

    @ApiOperation(value="unauthorizedFile", notes="UNAUTHORIZED_FILE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="USER_ID", required=true, dataType="Int", example="100")})
    @GetMapping(value={"/unauth-file"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public Result unauthorizedFile(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") Integer userId) {
        try {
            logger.info("resource unauthorized file, user:{}, unauthorized user id:{}", (Object)loginUser.getUserName(), (Object)userId);
            Map<String, Object> result = this.resourceService.unauthorizedFile(loginUser, userId);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.UNAUTHORIZED_FILE_RESOURCE_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.UNAUTHORIZED_FILE_RESOURCE_ERROR.getCode(), Status.UNAUTHORIZED_FILE_RESOURCE_ERROR.getMsg());
        }
    }

    @ApiOperation(value="unauthUDFFunc", notes="UNAUTHORIZED_UDF_FUNC_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="USER_ID", required=true, dataType="Int", example="100")})
    @GetMapping(value={"/unauth-udf-func"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public Result unauthUDFFunc(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") Integer userId) {
        try {
            logger.info("unauthorized udf function, login user:{}, unauthorized user id:{}", (Object)loginUser.getUserName(), (Object)userId);
            Map<String, Object> result = this.resourceService.unauthorizedUDFFunction(loginUser, userId);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.UNAUTHORIZED_UDF_FUNCTION_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.UNAUTHORIZED_UDF_FUNCTION_ERROR.getCode(), Status.UNAUTHORIZED_UDF_FUNCTION_ERROR.getMsg());
        }
    }

    @ApiOperation(value="authUDFFunc", notes="AUTHORIZED_UDF_FUNC_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="USER_ID", required=true, dataType="Int", example="100")})
    @GetMapping(value={"/authed-udf-func"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public Result authorizedUDFFunction(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") Integer userId) {
        try {
            logger.info("auth udf function, login user:{}, auth user id:{}", (Object)loginUser.getUserName(), (Object)userId);
            Map<String, Object> result = this.resourceService.authorizedUDFFunction(loginUser, userId);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.AUTHORIZED_UDF_FUNCTION_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.AUTHORIZED_UDF_FUNCTION_ERROR.getCode(), Status.AUTHORIZED_UDF_FUNCTION_ERROR.getMsg());
        }
    }
}

