/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.dto;

import java.util.ArrayList;
import java.util.List;
import org.apache.dolphinscheduler.api.dto.TaskStateCount;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.dao.entity.ExecuteStatusCount;

public class TaskCountDto {
    private int totalCount;
    private List<TaskStateCount> taskCountDtos;

    public TaskCountDto(List<ExecuteStatusCount> taskInstanceStateCounts) {
        this.countTaskDtos(taskInstanceStateCounts);
    }

    private void countTaskDtos(List<ExecuteStatusCount> taskInstanceStateCounts) {
        int submitted_success = 0;
        int running_exeution = 0;
        int ready_pause = 0;
        int pause = 0;
        int ready_stop = 0;
        int stop = 0;
        int failure = 0;
        int success = 0;
        int need_fault_tolerance = 0;
        int kill = 0;
        int waitting_thread = 0;
        for (ExecuteStatusCount taskInstanceStateCount : taskInstanceStateCounts) {
            ExecutionStatus status = taskInstanceStateCount.getExecutionStatus();
            this.totalCount += taskInstanceStateCount.getCount();
            switch (status) {
                case SUBMITTED_SUCCESS: {
                    submitted_success += taskInstanceStateCount.getCount();
                    break;
                }
                case RUNNING_EXEUTION: {
                    running_exeution += taskInstanceStateCount.getCount();
                    break;
                }
                case READY_PAUSE: {
                    ready_pause += taskInstanceStateCount.getCount();
                    break;
                }
                case PAUSE: {
                    pause += taskInstanceStateCount.getCount();
                    break;
                }
                case READY_STOP: {
                    ready_stop += taskInstanceStateCount.getCount();
                    break;
                }
                case STOP: {
                    stop += taskInstanceStateCount.getCount();
                    break;
                }
                case FAILURE: {
                    failure += taskInstanceStateCount.getCount();
                    break;
                }
                case SUCCESS: {
                    success += taskInstanceStateCount.getCount();
                    break;
                }
                case NEED_FAULT_TOLERANCE: {
                    need_fault_tolerance += taskInstanceStateCount.getCount();
                    break;
                }
                case KILL: {
                    kill += taskInstanceStateCount.getCount();
                    break;
                }
                case WAITTING_THREAD: {
                    waitting_thread += taskInstanceStateCount.getCount();
                    break;
                }
            }
        }
        this.taskCountDtos = new ArrayList<TaskStateCount>();
        this.taskCountDtos.add(new TaskStateCount(ExecutionStatus.SUBMITTED_SUCCESS, submitted_success));
        this.taskCountDtos.add(new TaskStateCount(ExecutionStatus.RUNNING_EXEUTION, running_exeution));
        this.taskCountDtos.add(new TaskStateCount(ExecutionStatus.READY_PAUSE, ready_pause));
        this.taskCountDtos.add(new TaskStateCount(ExecutionStatus.PAUSE, pause));
        this.taskCountDtos.add(new TaskStateCount(ExecutionStatus.READY_STOP, ready_stop));
        this.taskCountDtos.add(new TaskStateCount(ExecutionStatus.STOP, stop));
        this.taskCountDtos.add(new TaskStateCount(ExecutionStatus.FAILURE, failure));
        this.taskCountDtos.add(new TaskStateCount(ExecutionStatus.SUCCESS, success));
        this.taskCountDtos.add(new TaskStateCount(ExecutionStatus.NEED_FAULT_TOLERANCE, need_fault_tolerance));
        this.taskCountDtos.add(new TaskStateCount(ExecutionStatus.KILL, kill));
        this.taskCountDtos.add(new TaskStateCount(ExecutionStatus.WAITTING_THREAD, waitting_thread));
    }

    public List<TaskStateCount> getTaskCountDtos() {
        return this.taskCountDtos;
    }

    public void setTaskCountDtos(List<TaskStateCount> taskCountDtos) {
        this.taskCountDtos = taskCountDtos;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }
}

