/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.log;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.StatusRuntimeException;
import java.util.concurrent.TimeUnit;
import org.apache.dolphinscheduler.rpc.LogParameter;
import org.apache.dolphinscheduler.rpc.LogViewServiceGrpc;
import org.apache.dolphinscheduler.rpc.PathParameter;
import org.apache.dolphinscheduler.rpc.RetByteInfo;
import org.apache.dolphinscheduler.rpc.RetStrInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogClient {
    private static final Logger logger = LoggerFactory.getLogger(LogClient.class);
    private final ManagedChannel channel;
    private final LogViewServiceGrpc.LogViewServiceBlockingStub blockingStub;

    public LogClient(String host, int port) {
        this(ManagedChannelBuilder.forAddress((String)host, (int)port).usePlaintext(true));
    }

    LogClient(ManagedChannelBuilder<?> channelBuilder) {
        channelBuilder.maxInboundMessageSize(Integer.MAX_VALUE);
        this.channel = channelBuilder.build();
        this.blockingStub = LogViewServiceGrpc.newBlockingStub((Channel)this.channel);
    }

    public void shutdown() throws InterruptedException {
        this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
    }

    public String rollViewLog(String path, int skipLineNum, int limit) {
        logger.info("roll view log : path {},skipLineNum {} ,limit {}", new Object[]{path, skipLineNum, limit});
        LogParameter pathParameter = LogParameter.newBuilder().setPath(path).setSkipLineNum(skipLineNum).setLimit(limit).build();
        try {
            RetStrInfo retStrInfo = this.blockingStub.rollViewLog(pathParameter);
            return retStrInfo.getMsg();
        }
        catch (StatusRuntimeException e) {
            logger.error("roll view log error", (Throwable)e);
            return null;
        }
    }

    public String viewLog(String path) {
        logger.info("view log path {}", (Object)path);
        PathParameter pathParameter = PathParameter.newBuilder().setPath(path).build();
        try {
            RetStrInfo retStrInfo = this.blockingStub.viewLog(pathParameter);
            return retStrInfo.getMsg();
        }
        catch (StatusRuntimeException e) {
            logger.error("view log error", (Throwable)e);
            return null;
        }
    }

    public byte[] getLogBytes(String path) {
        logger.info("log path {}", (Object)path);
        PathParameter pathParameter = PathParameter.newBuilder().setPath(path).build();
        try {
            RetByteInfo retByteInfo = this.blockingStub.getLogBytes(pathParameter);
            return retByteInfo.getData().toByteArray();
        }
        catch (StatusRuntimeException e) {
            logger.error("log size error", (Throwable)e);
            return null;
        }
    }
}

