/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.BaseService;
import org.apache.dolphinscheduler.api.utils.ZookeeperMonitor;
import org.apache.dolphinscheduler.common.enums.ZKNodeType;
import org.apache.dolphinscheduler.common.model.Server;
import org.apache.dolphinscheduler.dao.MonitorDBDao;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.entity.ZookeeperRecord;
import org.springframework.stereotype.Service;

@Service
public class MonitorService
extends BaseService {
    public Map<String, Object> queryDatabaseState(User loginUser) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        List monitorRecordList = MonitorDBDao.queryDatabaseState();
        result.put("data", monitorRecordList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> queryMaster(User loginUser) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        List<Server> masterServers = this.getServerListFromZK(true);
        result.put("data", masterServers);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> queryZookeeperState(User loginUser) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        List<ZookeeperRecord> zookeeperRecordList = ZookeeperMonitor.zookeeperInfoList();
        result.put("data", zookeeperRecordList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> queryWorker(User loginUser) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        List<Server> masterServers = this.getServerListFromZK(false);
        result.put("data", masterServers);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public List<Server> getServerListFromZK(boolean isMaster) {
        ArrayList<Server> servers = new ArrayList();
        try (ZookeeperMonitor zookeeperMonitor = null;){
            zookeeperMonitor = new ZookeeperMonitor();
            ZKNodeType zkNodeType = isMaster ? ZKNodeType.MASTER : ZKNodeType.WORKER;
            servers = zookeeperMonitor.getServersList(zkNodeType);
        }
        return servers;
    }
}

