/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.dolphinscheduler.api.dto.treeview.Instance;
import org.apache.dolphinscheduler.api.dto.treeview.TreeViewDto;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.BaseDAGService;
import org.apache.dolphinscheduler.api.service.ProjectService;
import org.apache.dolphinscheduler.api.service.SchedulerService;
import org.apache.dolphinscheduler.api.utils.CheckUtils;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.common.enums.FailureStrategy;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.Priority;
import org.apache.dolphinscheduler.common.enums.ReleaseState;
import org.apache.dolphinscheduler.common.enums.TaskType;
import org.apache.dolphinscheduler.common.enums.UserType;
import org.apache.dolphinscheduler.common.enums.WarningType;
import org.apache.dolphinscheduler.common.graph.DAG;
import org.apache.dolphinscheduler.common.model.TaskNode;
import org.apache.dolphinscheduler.common.model.TaskNodeRelation;
import org.apache.dolphinscheduler.common.process.ProcessDag;
import org.apache.dolphinscheduler.common.thread.Stopper;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.ProcessDao;
import org.apache.dolphinscheduler.dao.entity.DataSource;
import org.apache.dolphinscheduler.dao.entity.ProcessData;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.Schedule;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.entity.WorkerGroup;
import org.apache.dolphinscheduler.dao.mapper.DataSourceMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessInstanceMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.ScheduleMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskInstanceMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkerGroupMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ProcessDefinitionService
extends BaseDAGService {
    private static final Logger logger = LoggerFactory.getLogger(ProcessDefinitionService.class);
    @Autowired
    private ProjectMapper projectMapper;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private ProcessDefinitionMapper processDefineMapper;
    @Autowired
    private ProcessInstanceMapper processInstanceMapper;
    @Autowired
    private TaskInstanceMapper taskInstanceMapper;
    @Autowired
    private ScheduleMapper scheduleMapper;
    @Autowired
    private ProcessDao processDao;
    @Autowired
    private DataSourceMapper dataSourceMapper;
    @Autowired
    private WorkerGroupMapper workerGroupMapper;

    public Map<String, Object> createProcessDefinition(User loginUser, String projectName, String name, String processDefinitionJson, String desc, String locations, String connects) throws JsonProcessingException {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        Project project = this.projectMapper.queryByName(projectName);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectName);
        Status resultStatus = (Status)((Object)checkResult.get("status"));
        if (resultStatus != Status.SUCCESS) {
            return checkResult;
        }
        ProcessDefinition processDefine = new ProcessDefinition();
        Date now = new Date();
        ProcessData processData = (ProcessData)JSONUtils.parseObject((String)processDefinitionJson, ProcessData.class);
        Map<String, Object> checkProcessJson = this.checkProcessNodeList(processData, processDefinitionJson);
        if (checkProcessJson.get("status") != Status.SUCCESS) {
            return checkProcessJson;
        }
        processDefine.setName(name);
        processDefine.setReleaseState(ReleaseState.OFFLINE);
        processDefine.setProjectId(project.getId());
        processDefine.setUserId(loginUser.getId());
        processDefine.setProcessDefinitionJson(processDefinitionJson);
        processDefine.setDescription(desc);
        processDefine.setLocations(locations);
        processDefine.setConnects(connects);
        processDefine.setTimeout(processData.getTimeout());
        processDefine.setTenantId(processData.getTenantId());
        ArrayList globalParamsList = processData.getGlobalParams();
        if (globalParamsList != null && globalParamsList.size() > 0) {
            HashSet globalParamsSet = new HashSet(globalParamsList);
            globalParamsList = new ArrayList(globalParamsSet);
            processDefine.setGlobalParamList(globalParamsList);
        }
        processDefine.setCreateTime(now);
        processDefine.setUpdateTime(now);
        processDefine.setFlag(Flag.YES);
        this.processDefineMapper.insert((Object)processDefine);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        result.put("processDefinitionId", processDefine.getId());
        return result;
    }

    public Map<String, Object> queryProccessDefinitionList(User loginUser, String projectName) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        Project project = this.projectMapper.queryByName(projectName);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectName);
        Status resultStatus = (Status)((Object)checkResult.get("status"));
        if (resultStatus != Status.SUCCESS) {
            return checkResult;
        }
        List resourceList = this.processDefineMapper.queryAllDefinitionList(project.getId());
        result.put("data", resourceList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> queryProcessDefinitionListPaging(User loginUser, String projectName, String searchVal, Integer pageNo, Integer pageSize, Integer userId) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        Project project = this.projectMapper.queryByName(projectName);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectName);
        Status resultStatus = (Status)((Object)checkResult.get("status"));
        if (resultStatus != Status.SUCCESS) {
            return checkResult;
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage processDefinitionIPage = this.processDefineMapper.queryDefineListPaging((IPage)page, searchVal, userId.intValue(), project.getId(), this.isAdmin(loginUser));
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        pageInfo.setTotalCount((int)processDefinitionIPage.getTotal());
        pageInfo.setLists(processDefinitionIPage.getRecords());
        result.put("data", pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> queryProccessDefinitionById(User loginUser, String projectName, Integer processId) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        Project project = this.projectMapper.queryByName(projectName);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectName);
        Status resultStatus = (Status)((Object)checkResult.get("status"));
        if (resultStatus != Status.SUCCESS) {
            return checkResult;
        }
        ProcessDefinition processDefinition = (ProcessDefinition)this.processDefineMapper.selectById((Serializable)processId);
        if (processDefinition == null) {
            this.putMsg(result, Status.PROCESS_INSTANCE_NOT_EXIST, processId);
        } else {
            result.put("data", processDefinition);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    public Map<String, Object> updateProcessDefinition(User loginUser, String projectName, int id, String name, String processDefinitionJson, String desc, String locations, String connects) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        Project project = this.projectMapper.queryByName(projectName);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectName);
        Status resultStatus = (Status)((Object)checkResult.get("status"));
        if (resultStatus != Status.SUCCESS) {
            return checkResult;
        }
        ProcessData processData = (ProcessData)JSONUtils.parseObject((String)processDefinitionJson, ProcessData.class);
        Map<String, Object> checkProcessJson = this.checkProcessNodeList(processData, processDefinitionJson);
        if (checkProcessJson.get("status") != Status.SUCCESS) {
            return checkProcessJson;
        }
        ProcessDefinition processDefinition = this.processDao.findProcessDefineById(id);
        if (processDefinition == null) {
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, id);
            return result;
        }
        if (processDefinition.getReleaseState() == ReleaseState.ONLINE) {
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_ALLOWED_EDIT, processDefinition.getName());
            return result;
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        ProcessDefinition processDefine = this.processDao.findProcessDefineById(id);
        Date now = new Date();
        processDefine.setId(id);
        processDefine.setName(name);
        processDefine.setReleaseState(ReleaseState.OFFLINE);
        processDefine.setProjectId(project.getId());
        processDefine.setProcessDefinitionJson(processDefinitionJson);
        processDefine.setDescription(desc);
        processDefine.setLocations(locations);
        processDefine.setConnects(connects);
        processDefine.setTimeout(processData.getTimeout());
        processDefine.setTenantId(processData.getTenantId());
        ArrayList globalParamsList = new ArrayList();
        if (processData.getGlobalParams() != null && processData.getGlobalParams().size() > 0) {
            HashSet userDefParamsSet = new HashSet(processData.getGlobalParams());
            globalParamsList = new ArrayList(userDefParamsSet);
        }
        processDefine.setGlobalParamList(globalParamsList);
        processDefine.setUpdateTime(now);
        processDefine.setFlag(Flag.YES);
        if (this.processDefineMapper.updateById((Object)processDefine) > 0) {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        } else {
            this.putMsg(result, Status.UPDATE_PROCESS_DEFINITION_ERROR, new Object[0]);
        }
        return result;
    }

    public Map<String, Object> verifyProccessDefinitionName(User loginUser, String projectName, String name) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Project project = this.projectMapper.queryByName(projectName);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectName);
        Status resultEnum = (Status)((Object)checkResult.get("status"));
        if (resultEnum != Status.SUCCESS) {
            return checkResult;
        }
        ProcessDefinition processDefinition = this.processDefineMapper.queryByDefineName(project.getId(), name);
        if (processDefinition == null) {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        } else {
            this.putMsg(result, Status.PROCESS_INSTANCE_EXIST, name);
        }
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public Map<String, Object> deleteProcessDefinitionById(User loginUser, String projectName, Integer processDefinitionId) {
        int delete;
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        Project project = this.projectMapper.queryByName(projectName);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectName);
        Status resultEnum = (Status)((Object)checkResult.get("status"));
        if (resultEnum != Status.SUCCESS) {
            return checkResult;
        }
        ProcessDefinition processDefinition = (ProcessDefinition)this.processDefineMapper.selectById((Serializable)processDefinitionId);
        if (processDefinition == null) {
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, processDefinitionId);
            return result;
        }
        if (loginUser.getId() != processDefinition.getUserId() && loginUser.getUserType() != UserType.ADMIN_USER) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        if (processDefinition.getReleaseState() == ReleaseState.ONLINE) {
            this.putMsg(result, Status.PROCESS_DEFINE_STATE_ONLINE, processDefinitionId);
            return result;
        }
        List schedules = this.scheduleMapper.queryByProcessDefinitionId(processDefinitionId.intValue());
        if (!schedules.isEmpty() && schedules.size() > 1) {
            logger.warn("scheduler num is {},Greater than 1", (Object)schedules.size());
            this.putMsg(result, Status.DELETE_PROCESS_DEFINE_BY_ID_ERROR, new Object[0]);
            return result;
        }
        if (schedules.size() == 1) {
            Schedule schedule = (Schedule)schedules.get(0);
            if (schedule.getReleaseState() == ReleaseState.OFFLINE) {
                this.scheduleMapper.deleteById((Serializable)Integer.valueOf(schedule.getId()));
            } else if (schedule.getReleaseState() == ReleaseState.ONLINE) {
                this.putMsg(result, Status.SCHEDULE_CRON_STATE_ONLINE, schedule.getId());
                return result;
            }
        }
        if ((delete = this.processDefineMapper.deleteById((Serializable)processDefinitionId)) > 0) {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        } else {
            this.putMsg(result, Status.DELETE_PROCESS_DEFINE_BY_ID_ERROR, new Object[0]);
        }
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public Map<String, Object> releaseProcessDefinition(User loginUser, String projectName, int id, int releaseState) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Project project = this.projectMapper.queryByName(projectName);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectName);
        Status resultEnum = (Status)((Object)checkResult.get("status"));
        if (resultEnum != Status.SUCCESS) {
            return checkResult;
        }
        ReleaseState state = ReleaseState.getEnum((int)releaseState);
        ProcessDefinition processDefinition = (ProcessDefinition)this.processDefineMapper.selectById((Serializable)Integer.valueOf(id));
        switch (state) {
            case ONLINE: {
                processDefinition.setReleaseState(state);
                this.processDefineMapper.updateById((Object)processDefinition);
                break;
            }
            case OFFLINE: {
                processDefinition.setReleaseState(state);
                this.processDefineMapper.updateById((Object)processDefinition);
                List scheduleList = this.scheduleMapper.selectAllByProcessDefineArray(new int[]{processDefinition.getId()});
                for (Schedule schedule : scheduleList) {
                    logger.info("set schedule offline, schedule id: {}, process definition id: {}", new Object[]{project.getId(), schedule.getId(), id});
                    schedule.setReleaseState(ReleaseState.OFFLINE);
                    this.scheduleMapper.updateById((Object)schedule);
                    SchedulerService.deleteSchedule(project.getId(), schedule.getId());
                }
                break;
            }
            default: {
                this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, "releaseState");
                return result;
            }
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportProcessDefinitionById(User loginUser, String projectName, Integer processDefinitionId, HttpServletResponse response) {
        ProcessDefinition processDefinition;
        Project project = this.projectMapper.queryByName(projectName);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectName);
        Status resultStatus = (Status)((Object)checkResult.get("status"));
        if (resultStatus == Status.SUCCESS && (processDefinition = this.processDefineMapper.queryByDefineId(processDefinitionId.intValue())) != null) {
            JSONObject jsonObject = JSONUtils.parseObject((String)processDefinition.getProcessDefinitionJson());
            JSONArray jsonArray = (JSONArray)jsonObject.get((Object)"tasks");
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject dependentParameters;
                JSONObject taskNode = jsonArray.getJSONObject(i);
                if (taskNode.get((Object)"type") == null || taskNode.get((Object)"type") == "") continue;
                String taskType = taskNode.getString("type");
                if (taskType.equals(TaskType.SQL.name()) || taskType.equals(TaskType.PROCEDURE.name())) {
                    JSONObject sqlParameters = JSONUtils.parseObject((String)taskNode.getString("params"));
                    DataSource dataSource = (DataSource)this.dataSourceMapper.selectById((Serializable)((Integer)sqlParameters.get((Object)"datasource")));
                    if (dataSource != null) {
                        sqlParameters.put("datasourceName", (Object)dataSource.getName());
                    }
                    taskNode.put("params", (Object)sqlParameters);
                    continue;
                }
                if (!taskType.equals(TaskType.DEPENDENT.name()) || (dependentParameters = JSONUtils.parseObject((String)taskNode.getString("dependence"))) == null) continue;
                JSONArray dependTaskList = (JSONArray)dependentParameters.get((Object)"dependTaskList");
                for (int j = 0; j < dependTaskList.size(); ++j) {
                    JSONObject dependentTaskModel = dependTaskList.getJSONObject(j);
                    JSONArray dependItemList = (JSONArray)dependentTaskModel.get((Object)"dependItemList");
                    for (int k = 0; k < dependItemList.size(); ++k) {
                        JSONObject dependentItem = dependItemList.getJSONObject(k);
                        int definitionId = dependentItem.getInteger("definitionId");
                        ProcessDefinition definition = (ProcessDefinition)this.processDefineMapper.selectById((Serializable)Integer.valueOf(definitionId));
                        if (definition == null) continue;
                        dependentItem.put("projectName", (Object)definition.getProjectName());
                        dependentItem.put("definitionName", (Object)definition.getName());
                    }
                }
                taskNode.put("dependence", (Object)dependentParameters);
            }
            jsonObject.put("tasks", (Object)jsonArray);
            processDefinition.setProcessDefinitionJson(jsonObject.toString());
            LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
            row.put("projectName", processDefinition.getProjectName());
            row.put("processDefinitionName", processDefinition.getName());
            row.put("processDefinitionJson", processDefinition.getProcessDefinitionJson());
            row.put("processDefinitionDescription", processDefinition.getDescription());
            row.put("processDefinitionLocations", processDefinition.getLocations());
            row.put("processDefinitionConnects", processDefinition.getConnects());
            List schedules = this.scheduleMapper.queryByProcessDefinitionId(processDefinitionId.intValue());
            if (schedules.size() > 0) {
                Schedule schedule = (Schedule)schedules.get(0);
                row.put("scheduleWarningType", schedule.getWarningType());
                row.put("scheduleWarningGroupId", schedule.getWarningGroupId());
                row.put("scheduleStartTime", DateUtils.dateToString((Date)schedule.getStartTime()));
                row.put("scheduleEndTime", DateUtils.dateToString((Date)schedule.getEndTime()));
                row.put("scheduleCrontab", schedule.getCrontab());
                row.put("scheduleFailureStrategy", schedule.getFailureStrategy());
                row.put("scheduleReleaseState", ReleaseState.OFFLINE);
                row.put("scheduleProcessInstancePriority", schedule.getProcessInstancePriority());
                if (schedule.getId() == -1) {
                    row.put("scheduleWorkerGroupId", -1);
                } else {
                    WorkerGroup workerGroup = (WorkerGroup)this.workerGroupMapper.selectById((Serializable)Integer.valueOf(schedule.getWorkerGroupId()));
                    if (workerGroup != null) {
                        row.put("scheduleWorkerGroupName", workerGroup.getName());
                    }
                }
            }
            String rowsJson = JSONUtils.toJsonString(row);
            response.setContentType("application/json;charset=UTF-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + processDefinition.getName() + ".json");
            FilterOutputStream buff = null;
            ServletOutputStream out = null;
            try {
                out = response.getOutputStream();
                buff = new BufferedOutputStream((OutputStream)out);
                buff.write(rowsJson.getBytes("UTF-8"));
                ((BufferedOutputStream)buff).flush();
                buff.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    buff.close();
                    out.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Transactional(rollbackFor={Exception.class})
    public Map<String, Object> importProcessDefinition(User loginUser, MultipartFile file) {
        HashMap<String, Object> result;
        block52: {
            result = new HashMap<String, Object>(5);
            JSONObject json = null;
            try (InputStreamReader inputStreamReader = new InputStreamReader(file.getInputStream(), "UTF-8");){
                BufferedReader streamReader = new BufferedReader(inputStreamReader);
                StringBuilder respomseStrBuilder = new StringBuilder();
                String inputStr = "";
                while ((inputStr = streamReader.readLine()) != null) {
                    respomseStrBuilder.append(inputStr);
                }
                json = JSONObject.parseObject((String)respomseStrBuilder.toString());
                if (json != null) {
                    Project project;
                    String projectName = null;
                    String processDefinitionName = null;
                    String processDefinitionJson = null;
                    String processDefinitionDesc = null;
                    String processDefinitionLocations = null;
                    String processDefinitionConnects = null;
                    String scheduleWarningType = null;
                    String scheduleWarningGroupId = null;
                    String scheduleStartTime = null;
                    String scheduleEndTime = null;
                    String scheduleCrontab = null;
                    String scheduleFailureStrategy = null;
                    String scheduleReleaseState = null;
                    String scheduleProcessInstancePriority = null;
                    String scheduleWorkerGroupId = null;
                    String scheduleWorkerGroupName = null;
                    if (!ObjectUtils.allNotNull((Object[])new Object[]{json.get((Object)"projectName")})) {
                        this.putMsg(result, Status.DATA_IS_NULL, "processDefinitionName");
                        HashMap<String, Object> hashMap = result;
                        return hashMap;
                    }
                    projectName = json.get((Object)"projectName").toString();
                    if (!ObjectUtils.allNotNull((Object[])new Object[]{json.get((Object)"processDefinitionName")})) {
                        this.putMsg(result, Status.DATA_IS_NULL, "processDefinitionName");
                        HashMap<String, Object> hashMap = result;
                        return hashMap;
                    }
                    processDefinitionName = json.get((Object)"processDefinitionName").toString();
                    if (!ObjectUtils.allNotNull((Object[])new Object[]{json.get((Object)"processDefinitionJson")})) {
                        this.putMsg(result, Status.DATA_IS_NULL, "processDefinitionJson");
                        HashMap<String, Object> hashMap = result;
                        return hashMap;
                    }
                    processDefinitionJson = json.get((Object)"processDefinitionJson").toString();
                    if (ObjectUtils.allNotNull((Object[])new Object[]{json.get((Object)"processDefinitionDescription")})) {
                        processDefinitionDesc = json.get((Object)"processDefinitionDescription").toString();
                    }
                    if (ObjectUtils.allNotNull((Object[])new Object[]{json.get((Object)"processDefinitionLocations")})) {
                        processDefinitionLocations = json.get((Object)"processDefinitionLocations").toString();
                    }
                    if (ObjectUtils.allNotNull((Object[])new Object[]{json.get((Object)"processDefinitionConnects")})) {
                        processDefinitionConnects = json.get((Object)"processDefinitionConnects").toString();
                    }
                    if ((project = this.projectMapper.queryByName(projectName)) != null) {
                        processDefinitionName = this.recursionProcessDefinitionName(project.getId(), processDefinitionName, 1);
                    }
                    JSONObject jsonObject = JSONUtils.parseObject((String)processDefinitionJson);
                    JSONArray jsonArray = (JSONArray)jsonObject.get((Object)"tasks");
                    for (int j = 0; j < jsonArray.size(); ++j) {
                        JSONObject dependentParameters;
                        JSONObject taskNode = jsonArray.getJSONObject(j);
                        String taskType = taskNode.getString("type");
                        if (taskType.equals(TaskType.SQL.name()) || taskType.equals(TaskType.PROCEDURE.name())) {
                            JSONObject sqlParameters = JSONUtils.parseObject((String)taskNode.getString("params"));
                            List dataSources = this.dataSourceMapper.queryDataSourceByName(sqlParameters.getString("datasourceName"));
                            if (dataSources.size() > 0) {
                                DataSource dataSource = (DataSource)dataSources.get(0);
                                sqlParameters.put("datasource", (Object)dataSource.getId());
                            }
                            taskNode.put("params", (Object)sqlParameters);
                            continue;
                        }
                        if (!taskType.equals(TaskType.DEPENDENT.name()) || (dependentParameters = JSONUtils.parseObject((String)taskNode.getString("dependence"))) == null) continue;
                        JSONArray dependTaskList = (JSONArray)dependentParameters.get((Object)"dependTaskList");
                        for (int h = 0; h < dependTaskList.size(); ++h) {
                            JSONObject dependentTaskModel = dependTaskList.getJSONObject(h);
                            JSONArray dependItemList = (JSONArray)dependentTaskModel.get((Object)"dependItemList");
                            for (int k = 0; k < dependItemList.size(); ++k) {
                                ProcessDefinition definition;
                                JSONObject dependentItem = dependItemList.getJSONObject(k);
                                Project dependentItemProject = this.projectMapper.queryByName(dependentItem.getString("projectName"));
                                if (dependentItemProject == null || (definition = this.processDefineMapper.queryByDefineName(dependentItemProject.getId(), dependentItem.getString("definitionName"))) == null) continue;
                                dependentItem.put("projectId", (Object)dependentItemProject.getId());
                                dependentItem.put("definitionId", (Object)definition.getId());
                            }
                        }
                        taskNode.put("dependence", (Object)dependentParameters);
                    }
                    jsonObject.put("tasks", (Object)jsonArray);
                    Map<String, Object> createProcessDefinitionResult = this.createProcessDefinition(loginUser, projectName, processDefinitionName, jsonObject.toString(), processDefinitionDesc, processDefinitionLocations, processDefinitionConnects);
                    Integer processDefinitionId = null;
                    if (ObjectUtils.allNotNull((Object[])new Object[]{createProcessDefinitionResult.get("processDefinitionId")})) {
                        processDefinitionId = Integer.parseInt(createProcessDefinitionResult.get("processDefinitionId").toString());
                    }
                    if (ObjectUtils.allNotNull((Object[])new Object[]{json.get((Object)"scheduleCrontab")}) && processDefinitionId != null) {
                        Date now = new Date();
                        Schedule scheduleObj = new Schedule();
                        scheduleObj.setProjectName(projectName);
                        scheduleObj.setProcessDefinitionId(processDefinitionId.intValue());
                        scheduleObj.setProcessDefinitionName(processDefinitionName);
                        scheduleObj.setCreateTime(now);
                        scheduleObj.setUpdateTime(now);
                        scheduleObj.setUserId(loginUser.getId());
                        scheduleObj.setUserName(loginUser.getUserName());
                        scheduleCrontab = json.get((Object)"scheduleCrontab").toString();
                        scheduleObj.setCrontab(scheduleCrontab);
                        if (ObjectUtils.allNotNull((Object[])new Object[]{json.get((Object)"scheduleStartTime")})) {
                            scheduleStartTime = json.get((Object)"scheduleStartTime").toString();
                            scheduleObj.setStartTime(DateUtils.stringToDate((String)scheduleStartTime));
                        }
                        if (ObjectUtils.allNotNull((Object[])new Object[]{json.get((Object)"scheduleEndTime")})) {
                            scheduleEndTime = json.get((Object)"scheduleEndTime").toString();
                            scheduleObj.setEndTime(DateUtils.stringToDate((String)scheduleEndTime));
                        }
                        if (ObjectUtils.allNotNull((Object[])new Object[]{json.get((Object)"scheduleWarningType")})) {
                            scheduleWarningType = json.get((Object)"scheduleWarningType").toString();
                            scheduleObj.setWarningType(WarningType.valueOf((String)scheduleWarningType));
                        }
                        if (ObjectUtils.allNotNull((Object[])new Object[]{json.get((Object)"scheduleWarningGroupId")})) {
                            scheduleWarningGroupId = json.get((Object)"scheduleWarningGroupId").toString();
                            scheduleObj.setWarningGroupId(Integer.parseInt(scheduleWarningGroupId));
                        }
                        if (ObjectUtils.allNotNull((Object[])new Object[]{json.get((Object)"scheduleFailureStrategy")})) {
                            scheduleFailureStrategy = json.get((Object)"scheduleFailureStrategy").toString();
                            scheduleObj.setFailureStrategy(FailureStrategy.valueOf((String)scheduleFailureStrategy));
                        }
                        if (ObjectUtils.allNotNull((Object[])new Object[]{json.get((Object)"scheduleReleaseState")})) {
                            scheduleReleaseState = json.get((Object)"scheduleReleaseState").toString();
                            scheduleObj.setReleaseState(ReleaseState.valueOf((String)scheduleReleaseState));
                        }
                        if (ObjectUtils.allNotNull((Object[])new Object[]{json.get((Object)"scheduleProcessInstancePriority")})) {
                            scheduleProcessInstancePriority = json.get((Object)"scheduleProcessInstancePriority").toString();
                            scheduleObj.setProcessInstancePriority(Priority.valueOf((String)scheduleProcessInstancePriority));
                        }
                        if (ObjectUtils.allNotNull((Object[])new Object[]{json.get((Object)"scheduleWorkerGroupId")})) {
                            List workerGroups;
                            scheduleWorkerGroupId = json.get((Object)"scheduleWorkerGroupId").toString();
                            if (scheduleWorkerGroupId != null) {
                                scheduleObj.setWorkerGroupId(Integer.parseInt(scheduleWorkerGroupId));
                            } else if (ObjectUtils.allNotNull((Object[])new Object[]{json.get((Object)"scheduleWorkerGroupName")}) && (workerGroups = this.workerGroupMapper.queryWorkerGroupByName(scheduleWorkerGroupName = json.get((Object)"scheduleWorkerGroupName").toString())).size() > 0) {
                                scheduleObj.setWorkerGroupId(((WorkerGroup)workerGroups.get(0)).getId());
                            }
                        }
                        this.scheduleMapper.insert((Object)scheduleObj);
                    }
                    break block52;
                }
                this.putMsg(result, Status.EXPORT_PROCESS_DEFINE_BY_ID_ERROR, new Object[0]);
                HashMap<String, Object> hashMap = result;
                return hashMap;
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> checkProcessNodeList(ProcessData processData, String processDefinitionJson) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        try {
            if (processData == null) {
                logger.error("process data is null");
                this.putMsg(result, Status.DATA_IS_NOT_VALID, processDefinitionJson);
                return result;
            }
            List taskNodes = processData.getTasks();
            if (taskNodes == null) {
                logger.error("process node info is empty");
                this.putMsg(result, Status.DATA_IS_NULL, processDefinitionJson);
                return result;
            }
            if (this.graphHasCycle(taskNodes)) {
                logger.error("process DAG has cycle");
                this.putMsg(result, Status.PROCESS_NODE_HAS_CYCLE, new Object[0]);
                return result;
            }
            for (TaskNode taskNode : taskNodes) {
                if (!CheckUtils.checkTaskNodeParameters(taskNode.getParams(), taskNode.getType())) {
                    logger.error("task node {} parameter invalid", (Object)taskNode.getName());
                    this.putMsg(result, Status.PROCESS_NODE_S_PARAMETER_INVALID, taskNode.getName());
                    return result;
                }
                CheckUtils.checkOtherParams(taskNode.getExtras());
            }
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        catch (Exception e) {
            result.put("status", (Object)Status.REQUEST_PARAMS_NOT_VALID_ERROR);
            result.put("msg", e.getMessage());
        }
        return result;
    }

    public Map<String, Object> getTaskNodeListByDefinitionId(Integer defineId) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ProcessDefinition processDefinition = (ProcessDefinition)this.processDefineMapper.selectById((Serializable)defineId);
        if (processDefinition == null) {
            logger.info("process define not exists");
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, defineId);
            return result;
        }
        String processDefinitionJson = processDefinition.getProcessDefinitionJson();
        ProcessData processData = (ProcessData)JSONUtils.parseObject((String)processDefinitionJson, ProcessData.class);
        List taskNodeList = processData.getTasks() == null ? new ArrayList() : processData.getTasks();
        result.put("data", taskNodeList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> getTaskNodeListByDefinitionIdList(String defineIdList) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap taskNodeMap = new HashMap();
        String[] idList = defineIdList.split(",");
        List<String> definitionIdList = Arrays.asList(idList);
        ArrayList<Integer> idIntList = new ArrayList<Integer>();
        for (String definitionId : definitionIdList) {
            idIntList.add(Integer.parseInt(definitionId));
        }
        Integer[] idArray = idIntList.toArray(new Integer[idIntList.size()]);
        List processDefinitionList = this.processDefineMapper.queryDefinitionListByIdList(idArray);
        if (processDefinitionList == null || processDefinitionList.size() == 0) {
            logger.info("process definition not exists");
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, defineIdList);
            return result;
        }
        for (ProcessDefinition processDefinition : processDefinitionList) {
            String processDefinitionJson = processDefinition.getProcessDefinitionJson();
            ProcessData processData = (ProcessData)JSONUtils.parseObject((String)processDefinitionJson, ProcessData.class);
            List taskNodeList = processData.getTasks() == null ? new ArrayList() : processData.getTasks();
            taskNodeMap.put(processDefinition.getId(), taskNodeList);
        }
        result.put("data", taskNodeMap);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> queryProccessDefinitionAllByProjectId(Integer projectId) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        List resourceList = this.processDefineMapper.queryAllDefinitionList(projectId.intValue());
        result.put("data", resourceList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> viewTree(Integer processId, Integer limit) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ProcessDefinition processDefinition = (ProcessDefinition)this.processDefineMapper.selectById((Serializable)processId);
        if (processDefinition == null) {
            logger.info("process define not exists");
            throw new RuntimeException("process define not exists");
        }
        DAG<String, TaskNode, TaskNodeRelation> dag = this.genDagGraph(processDefinition);
        ConcurrentHashMap<String, ArrayList<Object>> runningNodeMap = new ConcurrentHashMap<String, ArrayList<Object>>();
        ConcurrentHashMap<String, ArrayList<TreeViewDto>> waitingRunningNodeMap = new ConcurrentHashMap<String, ArrayList<TreeViewDto>>();
        List processInstanceList = this.processInstanceMapper.queryByProcessDefineId(processId.intValue(), limit.intValue());
        for (ProcessInstance processInstance : processInstanceList) {
            processInstance.setDuration(Long.valueOf(DateUtils.differSec((Date)processInstance.getStartTime(), (Date)processInstance.getEndTime())));
        }
        if (limit > processInstanceList.size()) {
            limit = processInstanceList.size();
        }
        TreeViewDto parentTreeViewDto = new TreeViewDto();
        parentTreeViewDto.setName("DAG");
        parentTreeViewDto.setType("");
        for (int i = limit - 1; i >= 0; --i) {
            ProcessInstance processInstance = (ProcessInstance)processInstanceList.get(i);
            Date endTime = processInstance.getEndTime() == null ? new Date() : processInstance.getEndTime();
            parentTreeViewDto.getInstances().add(new Instance(processInstance.getId(), processInstance.getName(), "", processInstance.getState().toString(), processInstance.getStartTime(), endTime, processInstance.getHost(), DateUtils.format2Readable((long)(endTime.getTime() - processInstance.getStartTime().getTime()))));
        }
        List parentTreeViewDtoList = new ArrayList<TreeViewDto>();
        parentTreeViewDtoList.add(parentTreeViewDto);
        for (String startNode : dag.getBeginNode()) {
            runningNodeMap.put(startNode, (ArrayList<Object>)parentTreeViewDtoList);
        }
        while (Stopper.isRunning()) {
            Set postNodeList = null;
            for (Map.Entry en : runningNodeMap.entrySet()) {
                String nodeName = (String)en.getKey();
                parentTreeViewDtoList = (List)en.getValue();
                TreeViewDto treeViewDto = new TreeViewDto();
                treeViewDto.setName(nodeName);
                TaskNode taskNode = (TaskNode)dag.getNode((Object)nodeName);
                treeViewDto.setType(taskNode.getType());
                for (int i = limit - 1; i >= 0; --i) {
                    ProcessInstance processInstance = (ProcessInstance)processInstanceList.get(i);
                    TaskInstance taskInstance = this.taskInstanceMapper.queryByInstanceIdAndName(processInstance.getId(), nodeName);
                    if (taskInstance == null) {
                        treeViewDto.getInstances().add(new Instance(-1, "not running", "null"));
                        continue;
                    }
                    Date startTime = taskInstance.getStartTime() == null ? new Date() : taskInstance.getStartTime();
                    Date endTime = taskInstance.getEndTime() == null ? new Date() : taskInstance.getEndTime();
                    int subProcessId = 0;
                    if (taskInstance.getTaskType().equals(TaskType.SUB_PROCESS.name())) {
                        String taskJson = taskInstance.getTaskJson();
                        taskNode = (TaskNode)JSON.parseObject((String)taskJson, TaskNode.class);
                        subProcessId = Integer.parseInt(JSON.parseObject((String)taskNode.getParams()).getString("processDefinitionId"));
                    }
                    treeViewDto.getInstances().add(new Instance(taskInstance.getId(), taskInstance.getName(), taskInstance.getTaskType(), taskInstance.getState().toString(), taskInstance.getStartTime(), taskInstance.getEndTime(), taskInstance.getHost(), DateUtils.format2Readable((long)(endTime.getTime() - startTime.getTime())), subProcessId));
                }
                for (TreeViewDto pTreeViewDto : parentTreeViewDtoList) {
                    pTreeViewDto.getChildren().add(treeViewDto);
                }
                postNodeList = dag.getSubsequentNodes((Object)nodeName);
                if (postNodeList != null && postNodeList.size() > 0) {
                    for (String nextNodeName : postNodeList) {
                        ArrayList<TreeViewDto> treeViewDtoList = (ArrayList<TreeViewDto>)waitingRunningNodeMap.get(nextNodeName);
                        if (treeViewDtoList != null && treeViewDtoList.size() > 0) {
                            treeViewDtoList.add(treeViewDto);
                            waitingRunningNodeMap.put(nextNodeName, treeViewDtoList);
                            continue;
                        }
                        treeViewDtoList = new ArrayList<TreeViewDto>();
                        treeViewDtoList.add(treeViewDto);
                        waitingRunningNodeMap.put(nextNodeName, treeViewDtoList);
                    }
                }
                runningNodeMap.remove(nodeName);
            }
            if (waitingRunningNodeMap == null || waitingRunningNodeMap.size() == 0) break;
            runningNodeMap.putAll(waitingRunningNodeMap);
            waitingRunningNodeMap.clear();
        }
        result.put("data", parentTreeViewDto);
        result.put("status", (Object)Status.SUCCESS);
        result.put("msg", Status.SUCCESS.getMsg());
        return result;
    }

    private DAG<String, TaskNode, TaskNodeRelation> genDagGraph(ProcessDefinition processDefinition) throws Exception {
        String processDefinitionJson = processDefinition.getProcessDefinitionJson();
        ProcessData processData = (ProcessData)JSONUtils.parseObject((String)processDefinitionJson, ProcessData.class);
        List taskNodeList = processData.getTasks();
        processDefinition.setGlobalParamList(processData.getGlobalParams());
        ArrayList<TaskNodeRelation> taskNodeRelations = new ArrayList<TaskNodeRelation>();
        for (TaskNode taskNode : taskNodeList) {
            String preTasks = taskNode.getPreTasks();
            List preTasksList = JSONUtils.toList((String)preTasks, String.class);
            if (preTasksList == null) continue;
            for (String depNode : preTasksList) {
                taskNodeRelations.add(new TaskNodeRelation(depNode, taskNode.getName()));
            }
        }
        ProcessDag processDag = new ProcessDag();
        processDag.setEdges(taskNodeRelations);
        processDag.setNodes(taskNodeList);
        return this.genDagGraph(processDag);
    }

    private DAG<String, TaskNode, TaskNodeRelation> genDagGraph(ProcessDag processDag) {
        DAG dag = new DAG();
        if (CollectionUtils.isNotEmpty((Collection)processDag.getNodes())) {
            for (TaskNode node : processDag.getNodes()) {
                dag.addNode((Object)node.getName(), (Object)node);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)processDag.getEdges())) {
            for (TaskNodeRelation edge : processDag.getEdges()) {
                dag.addEdge((Object)edge.getStartNode(), (Object)edge.getEndNode());
            }
        }
        return dag;
    }

    private boolean graphHasCycle(List<TaskNode> taskNodeResponseList) {
        DAG graph = new DAG();
        for (TaskNode taskNodeResponse : taskNodeResponseList) {
            graph.addNode((Object)taskNodeResponse.getName(), (Object)taskNodeResponse);
        }
        for (TaskNode taskNodeResponse : taskNodeResponseList) {
            taskNodeResponse.getPreTasks();
            List preTasks = JSONUtils.toList((String)taskNodeResponse.getPreTasks(), String.class);
            if (!CollectionUtils.isNotEmpty((Collection)preTasks)) continue;
            for (String preTask : preTasks) {
                if (graph.addEdge((Object)preTask, (Object)taskNodeResponse.getName())) continue;
                return true;
            }
        }
        return graph.hasCycle();
    }

    private String recursionProcessDefinitionName(Integer projectId, String processDefinitionName, int num) {
        ProcessDefinition processDefinition = this.processDefineMapper.queryByDefineName(projectId.intValue(), processDefinitionName);
        if (processDefinition != null) {
            if (num > 1) {
                String str = processDefinitionName.substring(0, processDefinitionName.length() - 3);
                processDefinitionName = str + "(" + num + ")";
            } else {
                processDefinitionName = processDefinition.getName() + "(" + num + ")";
            }
        } else {
            return processDefinitionName;
        }
        return this.recursionProcessDefinitionName(projectId, processDefinitionName, num + 1);
    }
}

