/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.BaseService;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.common.Constants;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.entity.WorkerGroup;
import org.apache.dolphinscheduler.dao.mapper.ProcessInstanceMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkerGroupMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WorkerGroupService
extends BaseService {
    @Autowired
    WorkerGroupMapper workerGroupMapper;
    @Autowired
    ProcessInstanceMapper processInstanceMapper;

    public Map<String, Object> saveWorkerGroup(User loginUser, int id, String name, String ipList) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        if (this.checkAdmin(loginUser, result)) {
            return result;
        }
        if (StringUtils.isEmpty((CharSequence)name)) {
            this.putMsg(result, Status.NAME_NULL, new Object[0]);
            return result;
        }
        Date now = new Date();
        WorkerGroup workerGroup = null;
        if (id != 0) {
            workerGroup = (WorkerGroup)this.workerGroupMapper.selectById((Serializable)Integer.valueOf(id));
        } else {
            workerGroup = new WorkerGroup();
            workerGroup.setCreateTime(now);
        }
        workerGroup.setName(name);
        workerGroup.setIpList(ipList);
        workerGroup.setUpdateTime(now);
        if (this.checkWorkerGroupNameExists(workerGroup)) {
            this.putMsg(result, Status.NAME_EXIST, workerGroup.getName());
            return result;
        }
        if (workerGroup.getId() != 0) {
            this.workerGroupMapper.updateById((Object)workerGroup);
        } else {
            this.workerGroupMapper.insert((Object)workerGroup);
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private boolean checkWorkerGroupNameExists(WorkerGroup workerGroup) {
        List workerGroupList = this.workerGroupMapper.queryWorkerGroupByName(workerGroup.getName());
        if (workerGroupList.size() > 0) {
            if (workerGroup.getId() == 0) {
                return true;
            }
            for (WorkerGroup group : workerGroupList) {
                if (group.getId() == workerGroup.getId()) continue;
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> queryAllGroupPaging(User loginUser, Integer pageNo, Integer pageSize, String searchVal) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        if (this.checkAdmin(loginUser, result)) {
            return result;
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage workerGroupIPage = this.workerGroupMapper.queryListPaging((IPage)page, searchVal);
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        pageInfo.setTotalCount((int)workerGroupIPage.getTotal());
        pageInfo.setLists(workerGroupIPage.getRecords());
        result.put("data", pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public Map<String, Object> deleteWorkerGroupById(Integer id) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        List processInstances = this.processInstanceMapper.queryByWorkerGroupIdAndStatus(id.intValue(), Constants.NOT_TERMINATED_STATES);
        if (CollectionUtils.isNotEmpty((Collection)processInstances)) {
            this.putMsg(result, Status.DELETE_WORKER_GROUP_BY_ID_FAIL, processInstances.size());
            return result;
        }
        this.workerGroupMapper.deleteById((Serializable)id);
        this.processInstanceMapper.updateProcessInstanceByWorkerGroupId(id.intValue(), -1);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> queryAllGroup() {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        List workerGroupList = this.workerGroupMapper.queryAllWorkerGroup();
        result.put("data", workerGroupList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }
}

