/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.utils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.utils.ZooKeeperState;
import org.apache.dolphinscheduler.common.enums.ZKNodeType;
import org.apache.dolphinscheduler.common.model.Server;
import org.apache.dolphinscheduler.common.zk.AbstractZKClient;
import org.apache.dolphinscheduler.dao.entity.ZookeeperRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperMonitor
extends AbstractZKClient {
    private static final Logger LOG = LoggerFactory.getLogger(ZookeeperMonitor.class);
    private static final String zookeeperList = AbstractZKClient.getZookeeperQuorum();

    public static List<ZookeeperRecord> zookeeperInfoList() {
        String zookeeperServers = zookeeperList.replaceAll("[\\t\\n\\x0B\\f\\r]", "");
        try {
            return ZookeeperMonitor.zookeeperInfoList(zookeeperServers);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<Server> getMasterServers() {
        return this.getServersList(ZKNodeType.MASTER);
    }

    public List<Server> getWorkerServers() {
        return this.getServersList(ZKNodeType.WORKER);
    }

    private static List<ZookeeperRecord> zookeeperInfoList(String zookeeperServers) {
        ArrayList<ZookeeperRecord> list = new ArrayList<ZookeeperRecord>(5);
        if (StringUtils.isNotBlank((CharSequence)zookeeperServers)) {
            String[] zookeeperServersArray;
            for (String zookeeperServer : zookeeperServersArray = zookeeperServers.split(",")) {
                ZooKeeperState state = new ZooKeeperState(zookeeperServer);
                boolean ok = state.ruok();
                if (ok) {
                    state.getZookeeperInfo();
                }
                String hostName = zookeeperServer;
                int connections = state.getConnections();
                int watches = state.getWatches();
                long sent = state.getSent();
                long received = state.getReceived();
                String mode = state.getMode();
                int minLatency = state.getMinLatency();
                int avgLatency = state.getAvgLatency();
                int maxLatency = state.getMaxLatency();
                int nodeCount = state.getNodeCount();
                int status = ok ? 1 : 0;
                Date date = new Date();
                ZookeeperRecord zookeeperRecord = new ZookeeperRecord(hostName, connections, watches, sent, received, mode, minLatency, avgLatency, maxLatency, nodeCount, status, date);
                list.add(zookeeperRecord);
            }
        }
        return list;
    }
}

