/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.ProcessDefinitionService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.dao.entity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"PROCESS_DEFINITION_TAG"}, position=2)
@RestController
@RequestMapping(value={"projects/{projectName}/process"})
public class ProcessDefinitionController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(ProcessDefinitionController.class);
    @Autowired
    private ProcessDefinitionService processDefinitionService;

    @ApiOperation(value="save", notes="CREATE_PROCESS_DEFINITION_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="name", value="PROCESS_DEFINITION_NAME", required=true, type="String"), @ApiImplicitParam(name="processDefinitionJson", value="PROCESS_DEFINITION_JSON", required=true, type="String"), @ApiImplicitParam(name="locations", value="PROCESS_DEFINITION_LOCATIONS", required=true, type="String"), @ApiImplicitParam(name="connects", value="PROCESS_DEFINITION_CONNECTS", required=true, type="String"), @ApiImplicitParam(name="description", value="PROCESS_DEFINITION_DESC", required=false, type="String")})
    @PostMapping(value={"/save"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public Result createProcessDefinition(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectName", value="PROJECT_NAME", required=true) @PathVariable String projectName, @RequestParam(value="name", required=true) String name, @RequestParam(value="processDefinitionJson", required=true) String json, @RequestParam(value="locations", required=true) String locations, @RequestParam(value="connects", required=true) String connects, @RequestParam(value="description", required=false) String description) {
        try {
            logger.info("login user {}, create  process definition, project name: {}, process definition name: {}, process_definition_json: {}, desc: {} locations:{}, connects:{}", new Object[]{loginUser.getUserName(), projectName, name, json, description, locations, connects});
            Map<String, Object> result = this.processDefinitionService.createProcessDefinition(loginUser, projectName, name, json, description, locations, connects);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.CREATE_PROCESS_DEFINITION.getMsg(), (Throwable)e);
            return this.error(Status.CREATE_PROCESS_DEFINITION.getCode(), Status.CREATE_PROCESS_DEFINITION.getMsg());
        }
    }

    @ApiOperation(value="verify-name", notes="VERIFY_PROCCESS_DEFINITION_NAME_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="name", value="PROCESS_DEFINITION_NAME", required=true, type="String")})
    @GetMapping(value={"/verify-name"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result verifyProccessDefinitionName(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectName", value="PROJECT_NAME", required=true) @PathVariable String projectName, @RequestParam(value="name", required=true) String name) {
        try {
            logger.info("verify process definition name unique, user:{}, project name:{}, process definition name:{}", new Object[]{loginUser.getUserName(), projectName, name});
            Map<String, Object> result = this.processDefinitionService.verifyProccessDefinitionName(loginUser, projectName, name);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.VERIFY_PROCESS_DEFINITION_NAME_UNIQUE_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.VERIFY_PROCESS_DEFINITION_NAME_UNIQUE_ERROR.getCode(), Status.VERIFY_PROCESS_DEFINITION_NAME_UNIQUE_ERROR.getMsg());
        }
    }

    @ApiOperation(value="updateProccessDefinition", notes="UPDATE_PROCCESS_DEFINITION_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="name", value="PROCESS_DEFINITION_NAME", required=true, type="String"), @ApiImplicitParam(name="id", value="PROCESS_DEFINITION_ID", required=true, dataType="Int", example="100"), @ApiImplicitParam(name="processDefinitionJson", value="PROCESS_DEFINITION_JSON", required=true, type="String"), @ApiImplicitParam(name="locations", value="PROCESS_DEFINITION_LOCATIONS", required=true, type="String"), @ApiImplicitParam(name="connects", value="PROCESS_DEFINITION_CONNECTS", required=true, type="String"), @ApiImplicitParam(name="description", value="PROCESS_DEFINITION_DESC", required=false, type="String")})
    @PostMapping(value={"/update"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result updateProccessDefinition(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectName", value="PROJECT_NAME", required=true) @PathVariable String projectName, @RequestParam(value="name", required=true) String name, @RequestParam(value="id", required=true) int id, @RequestParam(value="processDefinitionJson", required=true) String processDefinitionJson, @RequestParam(value="locations", required=false) String locations, @RequestParam(value="connects", required=false) String connects, @RequestParam(value="description", required=false) String description) {
        try {
            logger.info("login user {}, update process define, project name: {}, process define name: {}, process_definition_json: {}, desc: {}, locations:{}, connects:{}", new Object[]{loginUser.getUserName(), projectName, name, processDefinitionJson, description, locations, connects});
            Map<String, Object> result = this.processDefinitionService.updateProcessDefinition(loginUser, projectName, id, name, processDefinitionJson, description, locations, connects);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.UPDATE_PROCESS_DEFINITION_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.UPDATE_PROCESS_DEFINITION_ERROR.getCode(), Status.UPDATE_PROCESS_DEFINITION_ERROR.getMsg());
        }
    }

    @ApiOperation(value="releaseProccessDefinition", notes="RELEASE_PROCCESS_DEFINITION_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="name", value="PROCESS_DEFINITION_NAME", required=true, type="String"), @ApiImplicitParam(name="processId", value="PROCESS_DEFINITION_ID", required=true, dataType="Int", example="100"), @ApiImplicitParam(name="releaseState", value="PROCESS_DEFINITION_CONNECTS", required=true, dataType="Int", example="100")})
    @PostMapping(value={"/release"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result releaseProccessDefinition(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectName", value="PROJECT_NAME", required=true) @PathVariable String projectName, @RequestParam(value="processId", required=true) int processId, @RequestParam(value="releaseState", required=true) int releaseState) {
        try {
            logger.info("login user {}, release process definition, project name: {}, release state: {}", new Object[]{loginUser.getUserName(), projectName, releaseState});
            Map<String, Object> result = this.processDefinitionService.releaseProcessDefinition(loginUser, projectName, processId, releaseState);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.RELEASE_PROCESS_DEFINITION_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.RELEASE_PROCESS_DEFINITION_ERROR.getCode(), Status.RELEASE_PROCESS_DEFINITION_ERROR.getMsg());
        }
    }

    @ApiOperation(value="queryProccessDefinitionById", notes="QUERY_PROCCESS_DEFINITION_BY_ID_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processId", value="PROCESS_DEFINITION_ID", required=true, dataType="Int", example="100")})
    @GetMapping(value={"/select-by-id"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result queryProccessDefinitionById(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectName", value="PROJECT_NAME", required=true) @PathVariable String projectName, @RequestParam(value="processId") Integer processId) {
        try {
            logger.info("query datail of process definition, login user:{}, project name:{}, process definition id:{}", new Object[]{loginUser.getUserName(), projectName, processId});
            Map<String, Object> result = this.processDefinitionService.queryProccessDefinitionById(loginUser, projectName, processId);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.QUERY_DATAIL_OF_PROCESS_DEFINITION_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.QUERY_DATAIL_OF_PROCESS_DEFINITION_ERROR.getCode(), Status.QUERY_DATAIL_OF_PROCESS_DEFINITION_ERROR.getMsg());
        }
    }

    @ApiOperation(value="queryProccessDefinitionList", notes="QUERY_PROCCESS_DEFINITION_LIST_NOTES")
    @GetMapping(value={"/list"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result queryProccessDefinitionList(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectName", value="PROJECT_NAME", required=true) @PathVariable String projectName) {
        try {
            logger.info("query proccess definition list, login user:{}, project name:{}", (Object)loginUser.getUserName(), (Object)projectName);
            Map<String, Object> result = this.processDefinitionService.queryProccessDefinitionList(loginUser, projectName);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.QUERY_PROCCESS_DEFINITION_LIST.getMsg(), (Throwable)e);
            return this.error(Status.QUERY_PROCCESS_DEFINITION_LIST.getCode(), Status.QUERY_PROCCESS_DEFINITION_LIST.getMsg());
        }
    }

    @ApiOperation(value="queryProcessDefinitionListPaging", notes="QUERY_PROCCESS_DEFINITION_LIST_PAGING_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", value="PAGE_NO", required=true, dataType="Int", example="100"), @ApiImplicitParam(name="searchVal", value="SEARCH_VAL", required=false, type="String"), @ApiImplicitParam(name="userId", value="USER_ID", required=false, dataType="Int", example="100"), @ApiImplicitParam(name="pageSize", value="PAGE_SIZE", required=true, dataType="Int", example="100")})
    @GetMapping(value={"/list-paging"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result queryProcessDefinitionListPaging(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectName", value="PROJECT_NAME", required=true) @PathVariable String projectName, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="userId", required=false, defaultValue="0") Integer userId, @RequestParam(value="pageSize") Integer pageSize) {
        try {
            logger.info("query proccess definition list paging, login user:{}, project name:{}", (Object)loginUser.getUserName(), (Object)projectName);
            Map<String, Object> result = this.checkPageParams(pageNo, pageSize);
            if (result.get("status") != Status.SUCCESS) {
                return this.returnDataListPaging(result);
            }
            searchVal = ParameterUtils.handleEscapes((String)searchVal);
            result = this.processDefinitionService.queryProcessDefinitionListPaging(loginUser, projectName, searchVal, pageNo, pageSize, userId);
            return this.returnDataListPaging(result);
        }
        catch (Exception e) {
            logger.error(Status.QUERY_PROCCESS_DEFINITION_LIST_PAGING_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.QUERY_PROCCESS_DEFINITION_LIST_PAGING_ERROR.getCode(), Status.QUERY_PROCCESS_DEFINITION_LIST_PAGING_ERROR.getMsg());
        }
    }

    @ApiOperation(value="viewTree", notes="VIEW_TREE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processId", value="PROCESS_DEFINITION_ID", required=true, dataType="Int", example="100"), @ApiImplicitParam(name="limit", value="LIMIT", required=true, dataType="Int", example="100")})
    @GetMapping(value={"/view-tree"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result viewTree(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectName", value="PROJECT_NAME", required=true) @PathVariable String projectName, @RequestParam(value="processId") Integer id, @RequestParam(value="limit") Integer limit) {
        try {
            Map<String, Object> result = this.processDefinitionService.viewTree(id, limit);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.ENCAPSULATION_TREEVIEW_STRUCTURE_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.ENCAPSULATION_TREEVIEW_STRUCTURE_ERROR.getCode(), Status.ENCAPSULATION_TREEVIEW_STRUCTURE_ERROR.getMsg());
        }
    }

    @ApiOperation(value="getNodeListByDefinitionId", notes="GET_NODE_LIST_BY_DEFINITION_ID_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processDefinitionId", value="PROCESS_DEFINITION_ID", required=true, dataType="Int", example="100")})
    @GetMapping(value={"gen-task-list"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result getNodeListByDefinitionId(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectName", value="PROJECT_NAME", required=true) @PathVariable String projectName, @RequestParam(value="processDefinitionId") Integer processDefinitionId) {
        try {
            logger.info("query task node name list by definitionId, login user:{}, project name:{}, id : {}", new Object[]{loginUser.getUserName(), projectName, processDefinitionId});
            Map<String, Object> result = this.processDefinitionService.getTaskNodeListByDefinitionId(processDefinitionId);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.GET_TASKS_LIST_BY_PROCESS_DEFINITION_ID_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.GET_TASKS_LIST_BY_PROCESS_DEFINITION_ID_ERROR.getCode(), Status.GET_TASKS_LIST_BY_PROCESS_DEFINITION_ID_ERROR.getMsg());
        }
    }

    @ApiOperation(value="getNodeListByDefinitionIdList", notes="GET_NODE_LIST_BY_DEFINITION_ID_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processDefinitionIdList", value="PROCESS_DEFINITION_ID_LIST", required=true, type="String")})
    @GetMapping(value={"get-task-list"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result getNodeListByDefinitionIdList(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectName", value="PROJECT_NAME", required=true) @PathVariable String projectName, @RequestParam(value="processDefinitionIdList") String processDefinitionIdList) {
        try {
            logger.info("query task node name list by definitionId list, login user:{}, project name:{}, id list: {}", new Object[]{loginUser.getUserName(), projectName, processDefinitionIdList});
            Map<String, Object> result = this.processDefinitionService.getTaskNodeListByDefinitionIdList(processDefinitionIdList);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.GET_TASKS_LIST_BY_PROCESS_DEFINITION_ID_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.GET_TASKS_LIST_BY_PROCESS_DEFINITION_ID_ERROR.getCode(), Status.GET_TASKS_LIST_BY_PROCESS_DEFINITION_ID_ERROR.getMsg());
        }
    }

    @ApiOperation(value="deleteProcessDefinitionById", notes="DELETE_PROCESS_DEFINITION_BY_ID_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processDefinitionId", value="PROCESS_DEFINITION_ID", dataType="Int", example="100")})
    @GetMapping(value={"/delete"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result deleteProcessDefinitionById(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectName", value="PROJECT_NAME", required=true) @PathVariable String projectName, @RequestParam(value="processDefinitionId") Integer processDefinitionId) {
        try {
            logger.info("delete process definition by id, login user:{}, project name:{}, process definition id:{}", new Object[]{loginUser.getUserName(), projectName, processDefinitionId});
            Map<String, Object> result = this.processDefinitionService.deleteProcessDefinitionById(loginUser, projectName, processDefinitionId);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.DELETE_PROCESS_DEFINE_BY_ID_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.DELETE_PROCESS_DEFINE_BY_ID_ERROR.getCode(), Status.DELETE_PROCESS_DEFINE_BY_ID_ERROR.getMsg());
        }
    }

    @ApiOperation(value="batchDeleteProcessDefinitionByIds", notes="BATCH_DELETE_PROCESS_DEFINITION_BY_IDS_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processDefinitionIds", value="PROCESS_DEFINITION_IDS", type="String")})
    @GetMapping(value={"/batch-delete"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result batchDeleteProcessDefinitionByIds(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectName", value="PROJECT_NAME", required=true) @PathVariable String projectName, @RequestParam(value="processDefinitionIds") String processDefinitionIds) {
        try {
            logger.info("delete process definition by ids, login user:{}, project name:{}, process definition ids:{}", new Object[]{loginUser.getUserName(), projectName, processDefinitionIds});
            HashMap<String, Object> result = new HashMap<String, Object>(5);
            ArrayList<Integer> deleteFailedIdList = new ArrayList<Integer>();
            if (StringUtils.isNotEmpty((CharSequence)processDefinitionIds)) {
                String[] processDefinitionIdArray;
                for (String strProcessDefinitionId : processDefinitionIdArray = processDefinitionIds.split(",")) {
                    int processDefinitionId = Integer.parseInt(strProcessDefinitionId);
                    try {
                        Map<String, Object> deleteResult = this.processDefinitionService.deleteProcessDefinitionById(loginUser, projectName, processDefinitionId);
                        if (Status.SUCCESS.equals(deleteResult.get("status"))) continue;
                        deleteFailedIdList.add(processDefinitionId);
                        logger.error((String)deleteResult.get("msg"));
                    }
                    catch (Exception e) {
                        deleteFailedIdList.add(processDefinitionId);
                    }
                }
            }
            if (deleteFailedIdList.size() > 0) {
                this.putMsg(result, Status.BATCH_DELETE_PROCESS_DEFINE_BY_IDS_ERROR, StringUtils.join((Object[])deleteFailedIdList.toArray(), (String)","));
            } else {
                this.putMsg(result, Status.SUCCESS, new Object[0]);
            }
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.BATCH_DELETE_PROCESS_DEFINE_BY_IDS_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.BATCH_DELETE_PROCESS_DEFINE_BY_IDS_ERROR.getCode(), Status.BATCH_DELETE_PROCESS_DEFINE_BY_IDS_ERROR.getMsg());
        }
    }

    @ApiOperation(value="exportProcessDefinitionById", notes="EXPORT_PROCCESS_DEFINITION_BY_ID_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processDefinitionId", value="PROCESS_DEFINITION_ID", required=true, dataType="Int", example="100")})
    @GetMapping(value={"/export"})
    @ResponseBody
    public void exportProcessDefinitionById(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @PathVariable String projectName, @RequestParam(value="processDefinitionId") Integer processDefinitionId, HttpServletResponse response) {
        try {
            logger.info("export process definition by id, login user:{}, project name:{}, process definition id:{}", new Object[]{loginUser.getUserName(), projectName, processDefinitionId});
            this.processDefinitionService.exportProcessDefinitionById(loginUser, projectName, processDefinitionId, response);
        }
        catch (Exception e) {
            logger.error(Status.EXPORT_PROCESS_DEFINE_BY_ID_ERROR.getMsg(), (Throwable)e);
        }
    }

    @ApiOperation(value="queryProccessDefinitionAllByProjectId", notes="QUERY_PROCCESS_DEFINITION_All_BY_PROJECT_ID_NOTES")
    @GetMapping(value={"/queryProccessDefinitionAllByProjectId"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result queryProccessDefinitionAllByProjectId(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="projectId") Integer projectId) {
        try {
            logger.info("query proccess definition list, login user:{}, project id:{}", (Object)loginUser.getUserName(), (Object)projectId);
            Map<String, Object> result = this.processDefinitionService.queryProccessDefinitionAllByProjectId(projectId);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.QUERY_PROCCESS_DEFINITION_LIST.getMsg(), (Throwable)e);
            return this.error(Status.QUERY_PROCCESS_DEFINITION_LIST.getCode(), Status.QUERY_PROCCESS_DEFINITION_LIST.getMsg());
        }
    }
}

