/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.ProcessInstanceService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.queue.ITaskQueue;
import org.apache.dolphinscheduler.common.queue.TaskQueueFactory;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.dao.entity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"PROCESS_INSTANCE_TAG"}, position=10)
@RestController
@RequestMapping(value={"projects/{projectName}/instance"})
public class ProcessInstanceController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(ProcessInstanceController.class);
    @Autowired
    ProcessInstanceService processInstanceService;

    @ApiOperation(value="queryProcessInstanceList", notes="QUERY_PROCESS_INSTANCE_LIST_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processDefinitionId", value="PROCESS_DEFINITION_ID", dataType="Int", example="100"), @ApiImplicitParam(name="searchVal", value="SEARCH_VAL", type="String"), @ApiImplicitParam(name="stateType", value="EXECUTION_STATUS", type="ExecutionStatus"), @ApiImplicitParam(name="host", value="HOST", type="String"), @ApiImplicitParam(name="startDate", value="START_DATE", type="String"), @ApiImplicitParam(name="endDate", value="END_DATE", type="String"), @ApiImplicitParam(name="pageNo", value="PAGE_NO", dataType="Int", example="100"), @ApiImplicitParam(name="pageSize", value="PAGE_SIZE", dataType="Int", example="100")})
    @GetMapping(value={"list-paging"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result queryProcessInstanceList(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectName", value="PROJECT_NAME", required=true) @PathVariable String projectName, @RequestParam(value="processDefinitionId", required=false, defaultValue="0") Integer processDefinitionId, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="stateType", required=false) ExecutionStatus stateType, @RequestParam(value="host", required=false) String host, @RequestParam(value="startDate", required=false) String startTime, @RequestParam(value="endDate", required=false) String endTime, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize) {
        try {
            logger.info("query all process instance list, login user:{},project name:{}, define id:{},search value:{},state type:{},host:{},start time:{}, end time:{},page number:{}, page size:{}", new Object[]{loginUser.getUserName(), projectName, processDefinitionId, searchVal, stateType, host, startTime, endTime, pageNo, pageSize});
            searchVal = ParameterUtils.handleEscapes((String)searchVal);
            Map<String, Object> result = this.processInstanceService.queryProcessInstanceList(loginUser, projectName, processDefinitionId, startTime, endTime, searchVal, stateType, host, pageNo, pageSize);
            return this.returnDataListPaging(result);
        }
        catch (Exception e) {
            logger.error(Status.QUERY_PROCESS_INSTANCE_LIST_PAGING_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.QUERY_PROCESS_INSTANCE_LIST_PAGING_ERROR.getCode(), Status.QUERY_PROCESS_INSTANCE_LIST_PAGING_ERROR.getMsg());
        }
    }

    @ApiOperation(value="queryTaskListByProcessId", notes="QUERY_TASK_LIST_BY_PROCESS_INSTANCE_ID_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processInstanceId", value="PROCESS_INSTANCE_ID", dataType="Int", example="100")})
    @GetMapping(value={"/task-list-by-process-id"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result queryTaskListByProcessId(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectName", value="PROJECT_NAME", required=true) @PathVariable String projectName, @RequestParam(value="processInstanceId") Integer processInstanceId) {
        try {
            logger.info("query task instance list by process instance id, login user:{}, project name:{}, process instance id:{}", new Object[]{loginUser.getUserName(), projectName, processInstanceId});
            Map<String, Object> result = this.processInstanceService.queryTaskListByProcessId(loginUser, projectName, processInstanceId);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.QUERY_TASK_LIST_BY_PROCESS_INSTANCE_ID_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.QUERY_TASK_LIST_BY_PROCESS_INSTANCE_ID_ERROR.getCode(), Status.QUERY_TASK_LIST_BY_PROCESS_INSTANCE_ID_ERROR.getMsg());
        }
    }

    @ApiOperation(value="updateProcessInstance", notes="UPDATE_PROCESS_INSTANCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processInstanceJson", value="PROCESS_INSTANCE_JSON", type="String"), @ApiImplicitParam(name="processInstanceId", value="PROCESS_INSTANCE_ID", dataType="Int", example="100"), @ApiImplicitParam(name="scheduleTime", value="SCHEDULE_TIME", type="String"), @ApiImplicitParam(name="syncDefine", value="SYNC_DEFINE", type="Boolean"), @ApiImplicitParam(name="locations", value="PROCESS_INSTANCE_LOCATIONS", type="String"), @ApiImplicitParam(name="connects", value="PROCESS_INSTANCE_CONNECTS", type="String"), @ApiImplicitParam(name="flag", value="RECOVERY_PROCESS_INSTANCE_FLAG", type="Flag")})
    @PostMapping(value={"/update"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result updateProcessInstance(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectName", value="PROJECT_NAME", required=true) @PathVariable String projectName, @RequestParam(value="processInstanceJson", required=false) String processInstanceJson, @RequestParam(value="processInstanceId") Integer processInstanceId, @RequestParam(value="scheduleTime", required=false) String scheduleTime, @RequestParam(value="syncDefine", required=true) Boolean syncDefine, @RequestParam(value="locations", required=false) String locations, @RequestParam(value="connects", required=false) String connects, @RequestParam(value="flag", required=false) Flag flag) {
        try {
            logger.info("updateProcessInstance process instance, login user:{}, project name:{}, process instance json:{},process instance id:{}, schedule time:{}, sync define:{}, flag:{}, locations:{}, connects:{}", new Object[]{loginUser.getUserName(), projectName, processInstanceJson, processInstanceId, scheduleTime, syncDefine, flag, locations, connects});
            Map<String, Object> result = this.processInstanceService.updateProcessInstance(loginUser, projectName, processInstanceId, processInstanceJson, scheduleTime, syncDefine, flag, locations, connects);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.UPDATE_PROCESS_INSTANCE_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.UPDATE_PROCESS_INSTANCE_ERROR.getCode(), Status.UPDATE_PROCESS_INSTANCE_ERROR.getMsg());
        }
    }

    @ApiOperation(value="queryProcessInstanceById", notes="QUERY_PROCESS_INSTANCE_BY_ID_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processInstanceId", value="PROCESS_INSTANCE_ID", dataType="Int", example="100")})
    @GetMapping(value={"/select-by-id"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result queryProcessInstanceById(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectName", value="PROJECT_NAME", required=true) @PathVariable String projectName, @RequestParam(value="processInstanceId") Integer processInstanceId) {
        try {
            logger.info("query process instance detail by id, login user:{},project name:{}, process instance id:{}", new Object[]{loginUser.getUserName(), projectName, processInstanceId});
            Map<String, Object> result = this.processInstanceService.queryProcessInstanceById(loginUser, projectName, processInstanceId);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.QUERY_PROCESS_INSTANCE_BY_ID_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.QUERY_PROCESS_INSTANCE_BY_ID_ERROR.getCode(), Status.QUERY_PROCESS_INSTANCE_BY_ID_ERROR.getMsg());
        }
    }

    @ApiOperation(value="deleteProcessInstanceById", notes="DELETE_PROCESS_INSTANCE_BY_ID_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processInstanceId", value="PROCESS_INSTANCE_ID", dataType="Int", example="100")})
    @GetMapping(value={"/delete"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result deleteProcessInstanceById(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectName", value="PROJECT_NAME", required=true) @PathVariable String projectName, @RequestParam(value="processInstanceId") Integer processInstanceId) {
        try {
            logger.info("delete process instance by id, login user:{}, project name:{}, process instance id:{}", new Object[]{loginUser.getUserName(), projectName, processInstanceId});
            ITaskQueue tasksQueue = TaskQueueFactory.getTaskQueueInstance();
            Map<String, Object> result = this.processInstanceService.deleteProcessInstanceById(loginUser, projectName, processInstanceId, tasksQueue);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.DELETE_PROCESS_INSTANCE_BY_ID_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.DELETE_PROCESS_INSTANCE_BY_ID_ERROR.getCode(), Status.DELETE_PROCESS_INSTANCE_BY_ID_ERROR.getMsg());
        }
    }

    @ApiOperation(value="querySubProcessInstanceByTaskId", notes="QUERY_SUBPROCESS_INSTANCE_BY_TASK_ID_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="TASK_ID", dataType="Int", example="100")})
    @GetMapping(value={"/select-sub-process"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result querySubProcessInstanceByTaskId(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectName", value="PROJECT_NAME", required=true) @PathVariable String projectName, @RequestParam(value="taskId") Integer taskId) {
        try {
            Map<String, Object> result = this.processInstanceService.querySubProcessInstanceByTaskId(loginUser, projectName, taskId);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.QUERY_SUB_PROCESS_INSTANCE_DETAIL_INFO_BY_TASK_ID_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.QUERY_SUB_PROCESS_INSTANCE_DETAIL_INFO_BY_TASK_ID_ERROR.getCode(), Status.QUERY_SUB_PROCESS_INSTANCE_DETAIL_INFO_BY_TASK_ID_ERROR.getMsg());
        }
    }

    @ApiOperation(value="queryParentInstanceBySubId", notes="QUERY_PARENT_PROCESS_INSTANCE_BY_SUB_PROCESS_INSTANCE_ID_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="subId", value="SUB_PROCESS_INSTANCE_ID", dataType="Int", example="100")})
    @GetMapping(value={"/select-parent-process"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result queryParentInstanceBySubId(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectName", value="PROJECT_NAME", required=true) @PathVariable String projectName, @RequestParam(value="subId") Integer subId) {
        try {
            Map<String, Object> result = this.processInstanceService.queryParentInstanceBySubId(loginUser, projectName, subId);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.QUERY_PARENT_PROCESS_INSTANCE_DETAIL_INFO_BY_SUB_PROCESS_INSTANCE_ID_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.QUERY_PARENT_PROCESS_INSTANCE_DETAIL_INFO_BY_SUB_PROCESS_INSTANCE_ID_ERROR.getCode(), Status.QUERY_PARENT_PROCESS_INSTANCE_DETAIL_INFO_BY_SUB_PROCESS_INSTANCE_ID_ERROR.getMsg());
        }
    }

    @ApiOperation(value="viewVariables", notes="QUERY_PROCESS_INSTANCE_GLOBAL_VARIABLES_AND_LOCAL_VARIABLES_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processInstanceId", value="PROCESS_INSTANCE_ID", dataType="Int", example="100")})
    @GetMapping(value={"/view-variables"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result viewVariables(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="processInstanceId") Integer processInstanceId) {
        try {
            Map<String, Object> result = this.processInstanceService.viewVariables(processInstanceId);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.QUERY_PROCESS_INSTANCE_ALL_VARIABLES_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.QUERY_PROCESS_INSTANCE_ALL_VARIABLES_ERROR.getCode(), Status.QUERY_PROCESS_INSTANCE_ALL_VARIABLES_ERROR.getMsg());
        }
    }

    @ApiOperation(value="vieGanttTree", notes="VIEW_GANTT_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processInstanceId", value="PROCESS_INSTANCE_ID", dataType="Int", example="100")})
    @GetMapping(value={"/view-gantt"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result viewTree(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectName", value="PROJECT_NAME", required=true) @PathVariable String projectName, @RequestParam(value="processInstanceId") Integer processInstanceId) {
        try {
            Map<String, Object> result = this.processInstanceService.viewGantt(processInstanceId);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.ENCAPSULATION_PROCESS_INSTANCE_GANTT_STRUCTURE_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.ENCAPSULATION_PROCESS_INSTANCE_GANTT_STRUCTURE_ERROR.getCode(), Status.ENCAPSULATION_PROCESS_INSTANCE_GANTT_STRUCTURE_ERROR.getMsg());
        }
    }

    @GetMapping(value={"/batch-delete"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result batchDeleteProcessInstanceByIds(@RequestAttribute(value="session.user") User loginUser, @PathVariable String projectName, @RequestParam(value="processInstanceIds") String processInstanceIds) {
        try {
            logger.info("delete process instance by ids, login user:{}, project name:{}, process instance ids :{}", new Object[]{loginUser.getUserName(), projectName, processInstanceIds});
            ITaskQueue tasksQueue = TaskQueueFactory.getTaskQueueInstance();
            HashMap<String, Object> result = new HashMap<String, Object>(5);
            ArrayList<Integer> deleteFailedIdList = new ArrayList<Integer>();
            if (StringUtils.isNotEmpty((CharSequence)processInstanceIds)) {
                String[] processInstanceIdArray;
                for (String strProcessInstanceId : processInstanceIdArray = processInstanceIds.split(",")) {
                    int processInstanceId = Integer.parseInt(strProcessInstanceId);
                    try {
                        Map<String, Object> deleteResult = this.processInstanceService.deleteProcessInstanceById(loginUser, projectName, processInstanceId, tasksQueue);
                        if (Status.SUCCESS.equals(deleteResult.get("status"))) continue;
                        deleteFailedIdList.add(processInstanceId);
                        logger.error((String)deleteResult.get("msg"));
                    }
                    catch (Exception e) {
                        deleteFailedIdList.add(processInstanceId);
                    }
                }
            }
            if (deleteFailedIdList.size() > 0) {
                this.putMsg(result, Status.BATCH_DELETE_PROCESS_INSTANCE_BY_IDS_ERROR, StringUtils.join((Object[])deleteFailedIdList.toArray(), (String)","));
            } else {
                this.putMsg(result, Status.SUCCESS, new Object[0]);
            }
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.BATCH_DELETE_PROCESS_INSTANCE_BY_IDS_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.BATCH_DELETE_PROCESS_INSTANCE_BY_IDS_ERROR.getCode(), Status.BATCH_DELETE_PROCESS_INSTANCE_BY_IDS_ERROR.getMsg());
        }
    }
}

