/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.ProcessDefinitionService;
import org.apache.dolphinscheduler.api.service.ProjectService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.dao.entity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"PROJECT_TAG"}, position=1)
@RestController
@RequestMapping(value={"projects"})
public class ProjectController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(ProjectController.class);
    @Autowired
    private ProjectService projectService;
    @Autowired
    private ProcessDefinitionService processDefinitionService;

    @ApiOperation(value="createProject", notes="CREATE_PROJECT_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="projectName", value="PROJECT_NAME", dataType="String"), @ApiImplicitParam(name="description", value="PROJECT_DESC", dataType="String")})
    @PostMapping(value={"/create"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public Result createProject(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="projectName") String projectName, @RequestParam(value="description", required=false) String description) {
        try {
            logger.info("login user {}, create project name: {}, desc: {}", new Object[]{loginUser.getUserName(), projectName, description});
            Map<String, Object> result = this.projectService.createProject(loginUser, projectName, description);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.CREATE_PROJECT_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.CREATE_PROJECT_ERROR.getCode(), Status.CREATE_PROJECT_ERROR.getMsg());
        }
    }

    @ApiOperation(value="updateProject", notes="UPDATE_PROJECT_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="projectId", value="PROJECT_ID", dataType="Int", example="100"), @ApiImplicitParam(name="projectName", value="PROJECT_NAME", dataType="String"), @ApiImplicitParam(name="description", value="PROJECT_DESC", dataType="String")})
    @PostMapping(value={"/update"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result updateProject(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="projectId") Integer projectId, @RequestParam(value="projectName") String projectName, @RequestParam(value="description", required=false) String description) {
        try {
            logger.info("login user {} , updateProcessInstance project name: {}, desc: {}", new Object[]{loginUser.getUserName(), projectName, description});
            Map<String, Object> result = this.projectService.update(loginUser, projectId, projectName, description);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.UPDATE_PROJECT_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.UPDATE_PROJECT_ERROR.getCode(), Status.UPDATE_PROJECT_ERROR.getMsg());
        }
    }

    @ApiOperation(value="queryProjectById", notes="QUERY_PROJECT_BY_ID_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="projectId", value="PROJECT_ID", dataType="Int", example="100")})
    @GetMapping(value={"/query-by-id"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result queryProjectById(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="projectId") Integer projectId) {
        logger.info("login user {}, query project by id: {}", (Object)loginUser.getUserName(), (Object)projectId);
        try {
            Map<String, Object> result = this.projectService.queryById(projectId);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.QUERY_PROJECT_DETAILS_BY_ID_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.QUERY_PROJECT_DETAILS_BY_ID_ERROR.getCode(), Status.QUERY_PROJECT_DETAILS_BY_ID_ERROR.getMsg());
        }
    }

    @ApiOperation(value="queryProjectListPaging", notes="QUERY_PROJECT_LIST_PAGING_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="searchVal", value="SEARCH_VAL", dataType="String"), @ApiImplicitParam(name="projectId", value="PAGE_SIZE", dataType="Int", example="20"), @ApiImplicitParam(name="projectId", value="PAGE_NO", dataType="Int", example="1")})
    @GetMapping(value={"/list-paging"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result queryProjectListPaging(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="pageSize") Integer pageSize, @RequestParam(value="pageNo") Integer pageNo) {
        try {
            logger.info("login user {}, query project list paging", (Object)loginUser.getUserName());
            searchVal = ParameterUtils.handleEscapes((String)searchVal);
            Map<String, Object> result = this.projectService.queryProjectListPaging(loginUser, pageSize, pageNo, searchVal);
            return this.returnDataListPaging(result);
        }
        catch (Exception e) {
            logger.error(Status.LOGIN_USER_QUERY_PROJECT_LIST_PAGING_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.LOGIN_USER_QUERY_PROJECT_LIST_PAGING_ERROR.getCode(), Status.LOGIN_USER_QUERY_PROJECT_LIST_PAGING_ERROR.getMsg());
        }
    }

    @ApiOperation(value="deleteProjectById", notes="DELETE_PROJECT_BY_ID_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="projectId", value="PROJECT_ID", dataType="Int", example="100")})
    @GetMapping(value={"/delete"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result deleteProject(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="projectId") Integer projectId) {
        try {
            logger.info("login user {}, delete project: {}.", (Object)loginUser.getUserName(), (Object)projectId);
            Map<String, Object> result = this.projectService.deleteProject(loginUser, projectId);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.DELETE_PROJECT_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.DELETE_PROJECT_ERROR.getCode(), Status.DELETE_PROJECT_ERROR.getMsg());
        }
    }

    @ApiOperation(value="queryUnauthorizedProject", notes="QUERY_UNAUTHORIZED_PROJECT_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="USER_ID", dataType="Int", example="100")})
    @GetMapping(value={"/unauth-project"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result queryUnauthorizedProject(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") Integer userId) {
        try {
            logger.info("login user {}, query unauthorized project by user id: {}.", (Object)loginUser.getUserName(), (Object)userId);
            Map<String, Object> result = this.projectService.queryUnauthorizedProject(loginUser, userId);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.QUERY_UNAUTHORIZED_PROJECT_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.QUERY_UNAUTHORIZED_PROJECT_ERROR.getCode(), Status.QUERY_UNAUTHORIZED_PROJECT_ERROR.getMsg());
        }
    }

    @ApiOperation(value="queryAuthorizedProject", notes="QUERY_AUTHORIZED_PROJECT_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="USER_ID", dataType="Int", example="100")})
    @GetMapping(value={"/authed-project"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result queryAuthorizedProject(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") Integer userId) {
        try {
            logger.info("login user {}, query authorized project by user id: {}.", (Object)loginUser.getUserName(), (Object)userId);
            Map<String, Object> result = this.projectService.queryAuthorizedProject(loginUser, userId);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.QUERY_AUTHORIZED_PROJECT.getMsg(), (Throwable)e);
            return this.error(Status.QUERY_AUTHORIZED_PROJECT.getCode(), Status.QUERY_AUTHORIZED_PROJECT.getMsg());
        }
    }

    @ApiOperation(value="importProcessDefinition", notes="EXPORT_PROCCESS_DEFINITION_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="file", value="RESOURCE_FILE", required=true, dataType="MultipartFile")})
    @PostMapping(value={"/import-definition"})
    public Result importProcessDefinition(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="file") MultipartFile file) {
        try {
            logger.info("import process definition by id, login user:{}", (Object)loginUser.getUserName());
            Map<String, Object> result = this.processDefinitionService.importProcessDefinition(loginUser, file);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.IMPORT_PROCESS_DEFINE_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.IMPORT_PROCESS_DEFINE_ERROR.getCode(), Status.IMPORT_PROCESS_DEFINE_ERROR.getMsg());
        }
    }

    @ApiOperation(value="queryAllProjectList", notes="QUERY_ALL_PROJECT_LIST_NOTES")
    @GetMapping(value={"/query-project-list"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result queryAllProjectList(@ApiIgnore @RequestAttribute(value="session.user") User loginUser) {
        try {
            logger.info("login user {}, query all project list", (Object)loginUser.getUserName());
            Map<String, Object> result = this.projectService.queryAllProjectList();
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.LOGIN_USER_QUERY_PROJECT_LIST_PAGING_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.LOGIN_USER_QUERY_PROJECT_LIST_PAGING_ERROR.getCode(), Status.LOGIN_USER_QUERY_PROJECT_LIST_PAGING_ERROR.getMsg());
        }
    }
}

