/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.UsersService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.dao.entity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"USERS_TAG"}, position=14)
@RestController
@RequestMapping(value={"/users"})
public class UsersController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(UsersController.class);
    @Autowired
    private UsersService usersService;

    @ApiOperation(value="createUser", notes="CREATE_USER_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userName", value="USER_NAME", type="String"), @ApiImplicitParam(name="userPassword", value="USER_PASSWORD", type="String"), @ApiImplicitParam(name="tenantId", value="TENANT_ID", dataType="Int", example="100"), @ApiImplicitParam(name="queue", value="QUEUE", dataType="Int", example="100"), @ApiImplicitParam(name="email", value="EMAIL", dataType="Int", example="100"), @ApiImplicitParam(name="phone", value="PHONE", dataType="Int", example="100")})
    @PostMapping(value={"/create"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public Result createUser(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userName") String userName, @RequestParam(value="userPassword") String userPassword, @RequestParam(value="tenantId") int tenantId, @RequestParam(value="queue", required=false, defaultValue="") String queue, @RequestParam(value="email") String email, @RequestParam(value="phone", required=false) String phone) {
        logger.info("login user {}, create user, userName: {}, email: {}, tenantId: {}, userPassword: {}, phone: {}, user queue: {}", new Object[]{loginUser.getUserName(), userName, email, tenantId, "******", phone, queue});
        try {
            Map<String, Object> result = this.usersService.createUser(loginUser, userName, userPassword, email, tenantId, phone, queue);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.CREATE_USER_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.CREATE_USER_ERROR.getCode(), Status.CREATE_USER_ERROR.getMsg());
        }
    }

    @ApiOperation(value="queryUserList", notes="QUERY_USER_LIST_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", value="PAGE_NO", dataType="Int", example="100"), @ApiImplicitParam(name="pageSize", value="PAGE_SIZE", type="String"), @ApiImplicitParam(name="searchVal", value="SEARCH_VAL", type="String")})
    @GetMapping(value={"/list-paging"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result queryUserList(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="pageSize") Integer pageSize) {
        logger.info("login user {}, list user paging, pageNo: {}, searchVal: {}, pageSize: {}", new Object[]{loginUser.getUserName(), pageNo, searchVal, pageSize});
        try {
            Map<String, Object> result = this.checkPageParams(pageNo, pageSize);
            if (result.get("status") != Status.SUCCESS) {
                return this.returnDataListPaging(result);
            }
            searchVal = ParameterUtils.handleEscapes((String)searchVal);
            result = this.usersService.queryUserList(loginUser, searchVal, pageNo, pageSize);
            return this.returnDataListPaging(result);
        }
        catch (Exception e) {
            logger.error(Status.QUERY_USER_LIST_PAGING_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.QUERY_USER_LIST_PAGING_ERROR.getCode(), Status.QUERY_USER_LIST_PAGING_ERROR.getMsg());
        }
    }

    @ApiOperation(value="updateUser", notes="UPDATE_USER_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="USER_ID", dataType="Int", example="100"), @ApiImplicitParam(name="userName", value="USER_NAME", type="String"), @ApiImplicitParam(name="userPassword", value="USER_PASSWORD", type="String"), @ApiImplicitParam(name="tenantId", value="TENANT_ID", dataType="Int", example="100"), @ApiImplicitParam(name="queue", value="QUEUE", dataType="Int", example="100"), @ApiImplicitParam(name="email", value="EMAIL", dataType="Int", example="100"), @ApiImplicitParam(name="phone", value="PHONE", dataType="Int", example="100")})
    @PostMapping(value={"/update"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result updateUser(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="id") int id, @RequestParam(value="userName") String userName, @RequestParam(value="userPassword") String userPassword, @RequestParam(value="queue", required=false, defaultValue="") String queue, @RequestParam(value="email") String email, @RequestParam(value="tenantId") int tenantId, @RequestParam(value="phone", required=false) String phone) {
        logger.info("login user {}, updateProcessInstance user, userName: {}, email: {}, tenantId: {}, userPassword: {}, phone: {}, user queue: {}", new Object[]{loginUser.getUserName(), userName, email, tenantId, "******", phone, queue});
        try {
            Map<String, Object> result = this.usersService.updateUser(id, userName, userPassword, email, tenantId, phone, queue);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.UPDATE_USER_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.UPDATE_USER_ERROR.getCode(), Status.UPDATE_USER_ERROR.getMsg());
        }
    }

    @ApiOperation(value="delUserById", notes="DELETE_USER_BY_ID_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="USER_ID", dataType="Int", example="100")})
    @PostMapping(value={"/delete"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result delUserById(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="id") int id) {
        logger.info("login user {}, delete user, userId: {},", (Object)loginUser.getUserName(), (Object)id);
        try {
            Map<String, Object> result = this.usersService.deleteUserById(loginUser, id);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.DELETE_USER_BY_ID_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.DELETE_USER_BY_ID_ERROR.getCode(), Status.DELETE_USER_BY_ID_ERROR.getMsg());
        }
    }

    @ApiOperation(value="grantProject", notes="GRANT_PROJECT_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="USER_ID", dataType="Int", example="100"), @ApiImplicitParam(name="projectIds", value="PROJECT_IDS", type="String")})
    @PostMapping(value={"/grant-project"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result grantProject(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") int userId, @RequestParam(value="projectIds") String projectIds) {
        logger.info("login user {}, grant project, userId: {},projectIds : {}", new Object[]{loginUser.getUserName(), userId, projectIds});
        try {
            Map<String, Object> result = this.usersService.grantProject(loginUser, userId, projectIds);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.GRANT_PROJECT_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.GRANT_PROJECT_ERROR.getCode(), Status.GRANT_PROJECT_ERROR.getMsg());
        }
    }

    @ApiOperation(value="grantResource", notes="GRANT_RESOURCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="USER_ID", dataType="Int", example="100"), @ApiImplicitParam(name="resourceIds", value="RESOURCE_IDS", type="String")})
    @PostMapping(value={"/grant-file"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result grantResource(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") int userId, @RequestParam(value="resourceIds") String resourceIds) {
        logger.info("login user {}, grant project, userId: {},resourceIds : {}", new Object[]{loginUser.getUserName(), userId, resourceIds});
        try {
            Map<String, Object> result = this.usersService.grantResources(loginUser, userId, resourceIds);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.GRANT_RESOURCE_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.GRANT_RESOURCE_ERROR.getCode(), Status.GRANT_RESOURCE_ERROR.getMsg());
        }
    }

    @ApiOperation(value="grantUDFFunc", notes="GRANT_UDF_FUNC_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="USER_ID", dataType="Int", example="100"), @ApiImplicitParam(name="udfIds", value="UDF_IDS", type="String")})
    @PostMapping(value={"/grant-udf-func"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result grantUDFFunc(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") int userId, @RequestParam(value="udfIds") String udfIds) {
        logger.info("login user {}, grant project, userId: {},resourceIds : {}", new Object[]{loginUser.getUserName(), userId, udfIds});
        try {
            Map<String, Object> result = this.usersService.grantUDFFunction(loginUser, userId, udfIds);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.GRANT_UDF_FUNCTION_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.GRANT_UDF_FUNCTION_ERROR.getCode(), Status.GRANT_UDF_FUNCTION_ERROR.getMsg());
        }
    }

    @ApiOperation(value="grantDataSource", notes="GRANT_DATASOURCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="USER_ID", dataType="Int", example="100"), @ApiImplicitParam(name="datasourceIds", value="DATASOURCE_IDS", type="String")})
    @PostMapping(value={"/grant-datasource"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result grantDataSource(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") int userId, @RequestParam(value="datasourceIds") String datasourceIds) {
        logger.info("login user {}, grant project, userId: {},projectIds : {}", new Object[]{loginUser.getUserName(), userId, datasourceIds});
        try {
            Map<String, Object> result = this.usersService.grantDataSource(loginUser, userId, datasourceIds);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.GRANT_DATASOURCE_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.GRANT_DATASOURCE_ERROR.getCode(), Status.GRANT_DATASOURCE_ERROR.getMsg());
        }
    }

    @ApiOperation(value="getUserInfo", notes="GET_USER_INFO_NOTES")
    @GetMapping(value={"/get-user-info"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result getUserInfo(@ApiIgnore @RequestAttribute(value="session.user") User loginUser) {
        logger.info("login user {},get user info : {}", (Object)loginUser.getUserName());
        try {
            Map<String, Object> result = this.usersService.getUserInfo(loginUser);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.GET_USER_INFO_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.GET_USER_INFO_ERROR.getCode(), Status.GET_USER_INFO_ERROR.getMsg());
        }
    }

    @ApiOperation(value="listUser", notes="LIST_USER_NOTES")
    @GetMapping(value={"/list"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result listUser(@ApiIgnore @RequestAttribute(value="session.user") User loginUser) {
        logger.info("login user {}, user list");
        try {
            Map<String, Object> result = this.usersService.queryAllGeneralUsers(loginUser);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.USER_LIST_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.USER_LIST_ERROR.getCode(), Status.USER_LIST_ERROR.getMsg());
        }
    }

    @GetMapping(value={"/list-all"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result listAll(@RequestAttribute(value="session.user") User loginUser) {
        logger.info("login user {}, user list");
        try {
            Map<String, Object> result = this.usersService.queryUserList(loginUser);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.USER_LIST_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.USER_LIST_ERROR.getCode(), Status.USER_LIST_ERROR.getMsg());
        }
    }

    @ApiOperation(value="verifyUserName", notes="VERIFY_USER_NAME_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userName", value="USER_NAME", type="String")})
    @GetMapping(value={"/verify-user-name"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result verifyUserName(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userName") String userName) {
        try {
            logger.info("login user {}, verfiy user name: {}", (Object)loginUser.getUserName(), (Object)userName);
            return this.usersService.verifyUserName(userName);
        }
        catch (Exception e) {
            logger.error(Status.VERIFY_USERNAME_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.VERIFY_USERNAME_ERROR.getCode(), Status.VERIFY_USERNAME_ERROR.getMsg());
        }
    }

    @ApiOperation(value="unauthorizedUser", notes="UNAUTHORIZED_USER_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="alertgroupId", value="ALERT_GROUP_ID", type="String")})
    @GetMapping(value={"/unauth-user"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result unauthorizedUser(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="alertgroupId") Integer alertgroupId) {
        try {
            logger.info("unauthorized user, login user:{}, alert group id:{}", (Object)loginUser.getUserName(), (Object)alertgroupId);
            Map<String, Object> result = this.usersService.unauthorizedUser(loginUser, alertgroupId);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.UNAUTHORIZED_USER_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.UNAUTHORIZED_USER_ERROR.getCode(), Status.UNAUTHORIZED_USER_ERROR.getMsg());
        }
    }

    @ApiOperation(value="authorizedUser", notes="AUTHORIZED_USER_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="alertgroupId", value="ALERT_GROUP_ID", type="String")})
    @GetMapping(value={"/authed-user"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result authorizedUser(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="alertgroupId") Integer alertgroupId) {
        try {
            logger.info("authorized user , login user:{}, alert group id:{}", (Object)loginUser.getUserName(), (Object)alertgroupId);
            Map<String, Object> result = this.usersService.authorizedUser(loginUser, alertgroupId);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.AUTHORIZED_USER_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.AUTHORIZED_USER_ERROR.getCode(), Status.AUTHORIZED_USER_ERROR.getMsg());
        }
    }
}

