/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.BaseService;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.AlertType;
import org.apache.dolphinscheduler.dao.entity.AlertGroup;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.entity.UserAlertGroup;
import org.apache.dolphinscheduler.dao.mapper.AlertGroupMapper;
import org.apache.dolphinscheduler.dao.mapper.UserAlertGroupMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AlertGroupService
extends BaseService {
    private static final Logger logger = LoggerFactory.getLogger(AlertGroupService.class);
    @Autowired
    private AlertGroupMapper alertGroupMapper;
    @Autowired
    private UserAlertGroupMapper userAlertGroupMapper;

    public HashMap<String, Object> queryAlertgroup() {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        List alertGroups = this.alertGroupMapper.queryAllGroupList();
        result.put("data", alertGroups);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> listPaging(User loginUser, String searchVal, Integer pageNo, Integer pageSize) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        if (this.checkAdmin(loginUser, result)) {
            return result;
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage alertGroupIPage = this.alertGroupMapper.queryAlertGroupPage(page, searchVal);
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        pageInfo.setTotalCount((int)alertGroupIPage.getTotal());
        pageInfo.setLists(alertGroupIPage.getRecords());
        result.put("data", pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> createAlertgroup(User loginUser, String groupName, AlertType groupType, String desc) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        if (this.checkAdmin(loginUser, result)) {
            return result;
        }
        AlertGroup alertGroup = new AlertGroup();
        Date now = new Date();
        alertGroup.setGroupName(groupName);
        alertGroup.setGroupType(groupType);
        alertGroup.setDescription(desc);
        alertGroup.setCreateTime(now);
        alertGroup.setUpdateTime(now);
        int insert = this.alertGroupMapper.insert((Object)alertGroup);
        if (insert > 0) {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        } else {
            this.putMsg(result, Status.CREATE_ALERT_GROUP_ERROR, new Object[0]);
        }
        return result;
    }

    public Map<String, Object> updateAlertgroup(User loginUser, int id, String groupName, AlertType groupType, String desc) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        if (this.checkAdmin(loginUser, result)) {
            return result;
        }
        AlertGroup alertGroup = (AlertGroup)this.alertGroupMapper.selectById((Serializable)Integer.valueOf(id));
        if (alertGroup == null) {
            this.putMsg(result, Status.ALERT_GROUP_NOT_EXIST, new Object[0]);
            return result;
        }
        Date now = new Date();
        if (StringUtils.isNotEmpty((CharSequence)groupName)) {
            alertGroup.setGroupName(groupName);
        }
        if (groupType != null) {
            alertGroup.setGroupType(groupType);
        }
        alertGroup.setDescription(desc);
        alertGroup.setUpdateTime(now);
        this.alertGroupMapper.updateById((Object)alertGroup);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public Map<String, Object> delAlertgroupById(User loginUser, int id) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        result.put("status", false);
        if (this.checkAdmin(loginUser, result)) {
            return result;
        }
        AlertGroup alertGroup = (AlertGroup)this.alertGroupMapper.selectById((Serializable)Integer.valueOf(id));
        if (alertGroup == null) {
            this.putMsg(result, Status.ALERT_GROUP_NOT_EXIST, new Object[0]);
            return result;
        }
        this.userAlertGroupMapper.deleteByAlertgroupId(id);
        this.alertGroupMapper.deleteById((Serializable)Integer.valueOf(id));
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> grantUser(User loginUser, int alertgroupId, String userIds) {
        String[] userIdsArr;
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        result.put("status", false);
        if (this.checkAdmin(loginUser, result)) {
            return result;
        }
        this.userAlertGroupMapper.deleteByAlertgroupId(alertgroupId);
        if (StringUtils.isEmpty((CharSequence)userIds)) {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
            return result;
        }
        for (String userId : userIdsArr = userIds.split(",")) {
            Date now = new Date();
            UserAlertGroup userAlertGroup = new UserAlertGroup();
            userAlertGroup.setAlertgroupId(alertgroupId);
            userAlertGroup.setUserId(Integer.parseInt(userId));
            userAlertGroup.setCreateTime(now);
            userAlertGroup.setUpdateTime(now);
            this.userAlertGroupMapper.insert((Object)userAlertGroup);
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Result verifyGroupName(User loginUser, String groupName) {
        Result result = new Result();
        List alertGroup = this.alertGroupMapper.queryByGroupName(groupName);
        if (alertGroup != null && alertGroup.size() > 0) {
            logger.error("group {} has exist, can't create again.", (Object)groupName);
            result.setCode(Status.ALERT_GROUP_EXIST.getCode());
            result.setMsg(Status.ALERT_GROUP_EXIST.getMsg());
        } else {
            result.setCode(Status.SUCCESS.getCode());
            result.setMsg(Status.SUCCESS.getMsg());
        }
        return result;
    }
}

