/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.dolphinscheduler.api.service.BaseService;
import org.apache.dolphinscheduler.common.graph.DAG;
import org.apache.dolphinscheduler.common.model.TaskNode;
import org.apache.dolphinscheduler.common.model.TaskNodeRelation;
import org.apache.dolphinscheduler.common.process.ProcessDag;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessData;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;

public class BaseDAGService
extends BaseService {
    public static DAG<String, TaskNode, TaskNodeRelation> processInstance2DAG(ProcessInstance processInstance) {
        String processDefinitionJson = processInstance.getProcessInstanceJson();
        ProcessData processData = (ProcessData)JSONUtils.parseObject((String)processDefinitionJson, ProcessData.class);
        List taskNodeList = processData.getTasks();
        ArrayList<TaskNodeRelation> taskNodeRelations = new ArrayList<TaskNodeRelation>();
        for (TaskNode taskNode : taskNodeList) {
            String preTasks = taskNode.getPreTasks();
            List preTasksList = JSONUtils.toList((String)preTasks, String.class);
            if (preTasksList == null) continue;
            for (String depNode : preTasksList) {
                taskNodeRelations.add(new TaskNodeRelation(depNode, taskNode.getName()));
            }
        }
        ProcessDag processDag = new ProcessDag();
        processDag.setEdges(taskNodeRelations);
        processDag.setNodes(taskNodeList);
        DAG dag = new DAG();
        if (CollectionUtils.isNotEmpty((Collection)processDag.getNodes())) {
            for (TaskNode node : processDag.getNodes()) {
                dag.addNode((Object)node.getName(), (Object)node);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)processDag.getEdges())) {
            for (TaskNodeRelation edge : processDag.getEdges()) {
                dag.addEdge((Object)edge.getStartNode(), (Object)edge.getEndNode());
            }
        }
        return dag;
    }
}

