/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.dto.gantt.GanttDto;
import org.apache.dolphinscheduler.api.dto.gantt.Task;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.BaseDAGService;
import org.apache.dolphinscheduler.api.service.ExecutorService;
import org.apache.dolphinscheduler.api.service.LoggerService;
import org.apache.dolphinscheduler.api.service.ProcessDefinitionService;
import org.apache.dolphinscheduler.api.service.ProjectService;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.DependResult;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.TaskType;
import org.apache.dolphinscheduler.common.graph.DAG;
import org.apache.dolphinscheduler.common.model.TaskNode;
import org.apache.dolphinscheduler.common.model.TaskNodeRelation;
import org.apache.dolphinscheduler.common.process.Property;
import org.apache.dolphinscheduler.common.queue.ITaskQueue;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.IpUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.common.utils.placeholder.BusinessTimeUtils;
import org.apache.dolphinscheduler.dao.ProcessDao;
import org.apache.dolphinscheduler.dao.entity.ProcessData;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.Tenant;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.entity.WorkerGroup;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessInstanceMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskInstanceMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkerGroupMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProcessInstanceService
extends BaseDAGService {
    private static final Logger logger = LoggerFactory.getLogger(ProcessInstanceService.class);
    @Autowired
    ProjectMapper projectMapper;
    @Autowired
    ProjectService projectService;
    @Autowired
    ProcessDao processDao;
    @Autowired
    ProcessInstanceMapper processInstanceMapper;
    @Autowired
    ProcessDefinitionMapper processDefineMapper;
    @Autowired
    ProcessDefinitionService processDefinitionService;
    @Autowired
    ExecutorService execService;
    @Autowired
    TaskInstanceMapper taskInstanceMapper;
    @Autowired
    LoggerService loggerService;
    @Autowired
    WorkerGroupMapper workerGroupMapper;

    public Map<String, Object> queryProcessInstanceById(User loginUser, String projectName, Integer processId) {
        WorkerGroup workerGroup;
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        Project project = this.projectMapper.queryByName(projectName);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectName);
        Status resultEnum = (Status)((Object)checkResult.get("status"));
        if (resultEnum != Status.SUCCESS) {
            return checkResult;
        }
        ProcessInstance processInstance = this.processDao.findProcessInstanceDetailById(processId.intValue());
        String workerGroupName = "";
        workerGroupName = processInstance.getWorkerGroupId() == -1 ? "Default" : ((workerGroup = (WorkerGroup)this.workerGroupMapper.selectById((Serializable)Integer.valueOf(processInstance.getWorkerGroupId()))) != null ? workerGroup.getName() : "Default");
        processInstance.setWorkerGroupName(workerGroupName);
        ProcessDefinition processDefinition = this.processDao.findProcessDefineById(processInstance.getProcessDefinitionId());
        processInstance.setReceivers(processDefinition.getReceivers());
        processInstance.setReceiversCc(processDefinition.getReceiversCc());
        result.put("data", processInstance);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> queryProcessInstanceList(User loginUser, String projectName, Integer processDefineId, String startDate, String endDate, String searchVal, ExecutionStatus stateType, String host, Integer pageNo, Integer pageSize) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        Project project = this.projectMapper.queryByName(projectName);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectName);
        Status resultEnum = (Status)((Object)checkResult.get("status"));
        if (resultEnum != Status.SUCCESS) {
            return checkResult;
        }
        int[] statusArray = null;
        if (stateType != null) {
            statusArray = new int[]{stateType.ordinal()};
        }
        Date start = null;
        Date end = null;
        try {
            if (StringUtils.isNotEmpty((CharSequence)startDate)) {
                start = DateUtils.getScheduleDate((String)startDate);
            }
            if (StringUtils.isNotEmpty((CharSequence)endDate)) {
                end = DateUtils.getScheduleDate((String)endDate);
            }
        }
        catch (Exception e) {
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, "startDate,endDate");
            return result;
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage processInstanceList = this.processInstanceMapper.queryProcessInstanceListPaging(page, project.getId(), processDefineId, searchVal, statusArray, host, start, end);
        List processInstances = processInstanceList.getRecords();
        for (ProcessInstance processInstance : processInstances) {
            processInstance.setDuration(Long.valueOf(DateUtils.differSec((Date)processInstance.getStartTime(), (Date)processInstance.getEndTime())));
        }
        HashSet<String> exclusionSet = new HashSet<String>(){
            {
                this.add("class");
                this.add("locations");
                this.add("connects");
                this.add("processInstanceJson");
            }
        };
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        pageInfo.setTotalCount((int)processInstanceList.getTotal());
        pageInfo.setLists(CollectionUtils.getListByExclusion((List)processInstances, (Set)exclusionSet));
        result.put("data", pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> queryTaskListByProcessId(User loginUser, String projectName, Integer processId) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Project project = this.projectMapper.queryByName(projectName);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectName);
        Status resultEnum = (Status)((Object)checkResult.get("status"));
        if (resultEnum != Status.SUCCESS) {
            return checkResult;
        }
        ProcessInstance processInstance = this.processDao.findProcessInstanceDetailById(processId.intValue());
        List taskInstanceList = this.processDao.findValidTaskListByProcessId(processId);
        this.AddDependResultForTaskList(taskInstanceList);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("processInstanceState", processInstance.getState().toString());
        resultMap.put("taskList", taskInstanceList);
        result.put("data", resultMap);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private void AddDependResultForTaskList(List<TaskInstance> taskInstanceList) throws IOException {
        for (TaskInstance taskInstance : taskInstanceList) {
            Result logResult;
            if (!taskInstance.getTaskType().toUpperCase().equals(TaskType.DEPENDENT.toString()) || (logResult = this.loggerService.queryLog(taskInstance.getId(), 0, 4098)).getCode().intValue() != Status.SUCCESS.ordinal()) continue;
            String log = (String)logResult.getData();
            Map<String, DependResult> resultMap = this.parseLogForDependentResult(log);
            taskInstance.setDependentResult(JSONUtils.toJson(resultMap));
        }
    }

    public Map<String, DependResult> parseLogForDependentResult(String log) throws IOException {
        String line;
        HashMap<String, DependResult> resultMap = new HashMap<String, DependResult>();
        if (StringUtils.isEmpty((CharSequence)log)) {
            return resultMap;
        }
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(log.getBytes(Charset.forName("utf8"))), Charset.forName("utf8")));
        while ((line = br.readLine()) != null) {
            String dependResultString;
            String[] dependStringArray;
            String[] tmpStringArray;
            if (!line.contains(":||") || (tmpStringArray = line.split(":\\|\\|")).length != 2 || (dependStringArray = (dependResultString = tmpStringArray[1]).split(",")).length != 2) continue;
            String key = dependStringArray[0].trim();
            DependResult dependResult = DependResult.valueOf((String)dependStringArray[1].trim());
            resultMap.put(key, dependResult);
        }
        return resultMap;
    }

    public Map<String, Object> querySubProcessInstanceByTaskId(User loginUser, String projectName, Integer taskId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Project project = this.projectMapper.queryByName(projectName);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectName);
        Status resultEnum = (Status)((Object)checkResult.get("status"));
        if (resultEnum != Status.SUCCESS) {
            return checkResult;
        }
        TaskInstance taskInstance = this.processDao.findTaskInstanceById(taskId);
        if (taskInstance == null) {
            this.putMsg(result, Status.TASK_INSTANCE_NOT_EXISTS, taskId);
            return result;
        }
        if (!taskInstance.isSubProcess().booleanValue()) {
            this.putMsg(result, Status.TASK_INSTANCE_NOT_SUB_WORKFLOW_INSTANCE, taskInstance.getName());
            return result;
        }
        ProcessInstance subWorkflowInstance = this.processDao.findSubProcessInstance(Integer.valueOf(taskInstance.getProcessInstanceId()), Integer.valueOf(taskInstance.getId()));
        if (subWorkflowInstance == null) {
            this.putMsg(result, Status.SUB_PROCESS_INSTANCE_NOT_EXIST, taskId);
            return result;
        }
        HashMap<String, Integer> dataMap = new HashMap<String, Integer>();
        dataMap.put("subProcessInstanceId", subWorkflowInstance.getId());
        result.put("data", dataMap);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> updateProcessInstance(User loginUser, String projectName, Integer processInstanceId, String processInstanceJson, String scheduleTime, Boolean syncDefine, Flag flag, String locations, String connects) throws ParseException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Project project = this.projectMapper.queryByName(projectName);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectName);
        Status resultEnum = (Status)((Object)checkResult.get("status"));
        if (resultEnum != Status.SUCCESS) {
            return checkResult;
        }
        ProcessInstance processInstance = this.processDao.findProcessInstanceDetailById(processInstanceId.intValue());
        if (processInstance == null) {
            this.putMsg(result, Status.PROCESS_INSTANCE_NOT_EXIST, processInstanceId);
            return result;
        }
        if (!processInstance.getState().typeIsFinished()) {
            this.putMsg(result, Status.PROCESS_INSTANCE_STATE_OPERATION_ERROR, processInstance.getName(), processInstance.getState().toString(), "update");
            return result;
        }
        Date schedule = null;
        schedule = scheduleTime != null ? DateUtils.getScheduleDate((String)scheduleTime) : processInstance.getScheduleTime();
        processInstance.setScheduleTime(schedule);
        processInstance.setLocations(locations);
        processInstance.setConnects(connects);
        String globalParams = null;
        String originDefParams = null;
        int timeout = processInstance.getTimeout();
        ProcessDefinition processDefinition = this.processDao.findProcessDefineById(processInstance.getProcessDefinitionId());
        if (StringUtils.isNotEmpty((CharSequence)processInstanceJson)) {
            ProcessData processData = (ProcessData)JSONUtils.parseObject((String)processInstanceJson, ProcessData.class);
            Map<String, Object> checkFlowJson = this.processDefinitionService.checkProcessNodeList(processData, processInstanceJson);
            if (checkFlowJson.get("status") != Status.SUCCESS) {
                return result;
            }
            originDefParams = JSONUtils.toJson((Object)processData.getGlobalParams());
            List globalParamList = processData.getGlobalParams();
            Map<String, String> globalParamMap = globalParamList.stream().collect(Collectors.toMap(Property::getProp, Property::getValue));
            globalParams = ParameterUtils.curingGlobalParams(globalParamMap, (List)globalParamList, (CommandType)processInstance.getCmdTypeIfComplement(), (Date)schedule);
            timeout = processData.getTimeout();
            processInstance.setTimeout(timeout);
            Tenant tenant = this.processDao.getTenantForProcess(processData.getTenantId(), processDefinition.getUserId());
            if (tenant != null) {
                processInstance.setTenantCode(tenant.getTenantCode());
            }
            processInstance.setProcessInstanceJson(processInstanceJson);
            processInstance.setGlobalParams(globalParams);
        }
        int update = this.processDao.updateProcessInstance(processInstance);
        int updateDefine = 1;
        if (syncDefine.booleanValue() && StringUtils.isNotEmpty((CharSequence)processInstanceJson)) {
            processDefinition.setProcessDefinitionJson(processInstanceJson);
            processDefinition.setGlobalParams(originDefParams);
            processDefinition.setLocations(locations);
            processDefinition.setConnects(connects);
            processDefinition.setTimeout(timeout);
            updateDefine = this.processDefineMapper.updateById((Object)processDefinition);
        }
        if (update > 0 && updateDefine > 0) {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        } else {
            this.putMsg(result, Status.UPDATE_PROCESS_INSTANCE_ERROR, new Object[0]);
        }
        return result;
    }

    public Map<String, Object> queryParentInstanceBySubId(User loginUser, String projectName, Integer subId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Project project = this.projectMapper.queryByName(projectName);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectName);
        Status resultEnum = (Status)((Object)checkResult.get("status"));
        if (resultEnum != Status.SUCCESS) {
            return checkResult;
        }
        ProcessInstance subInstance = this.processDao.findProcessInstanceDetailById(subId.intValue());
        if (subInstance == null) {
            this.putMsg(result, Status.PROCESS_INSTANCE_NOT_EXIST, subId);
            return result;
        }
        if (subInstance.getIsSubProcess() == Flag.NO) {
            this.putMsg(result, Status.PROCESS_INSTANCE_NOT_SUB_PROCESS_INSTANCE, subInstance.getName());
            return result;
        }
        ProcessInstance parentWorkflowInstance = this.processDao.findParentProcessInstance(subId);
        if (parentWorkflowInstance == null) {
            this.putMsg(result, Status.SUB_PROCESS_INSTANCE_NOT_EXIST, new Object[0]);
            return result;
        }
        HashMap<String, Integer> dataMap = new HashMap<String, Integer>();
        dataMap.put("parentWorkflowInstance", parentWorkflowInstance.getId());
        result.put("data", dataMap);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public Map<String, Object> deleteProcessInstanceById(User loginUser, String projectName, Integer processInstanceId, ITaskQueue tasksQueue) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        Project project = this.projectMapper.queryByName(projectName);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectName);
        Status resultEnum = (Status)((Object)checkResult.get("status"));
        if (resultEnum != Status.SUCCESS) {
            return checkResult;
        }
        ProcessInstance processInstance = this.processDao.findProcessInstanceDetailById(processInstanceId.intValue());
        List taskInstanceList = this.processDao.findValidTaskListByProcessId(processInstanceId);
        int processInstancePriority = processInstance.getProcessInstancePriority().ordinal();
        if (processInstance == null) {
            this.putMsg(result, Status.PROCESS_INSTANCE_NOT_EXIST, processInstanceId);
            return result;
        }
        if (CollectionUtils.isNotEmpty((Collection)taskInstanceList)) {
            for (TaskInstance taskInstance : taskInstanceList) {
                int taskInstancePriority = taskInstance.getTaskInstancePriority().ordinal();
                StringBuilder nodeValueSb = new StringBuilder(100);
                nodeValueSb.append(processInstancePriority).append("_").append(processInstanceId).append("_").append(taskInstancePriority).append("_").append(taskInstance.getId()).append("_");
                int taskWorkerGroupId = this.processDao.getTaskWorkerGroupId(taskInstance);
                WorkerGroup workerGroup = (WorkerGroup)this.workerGroupMapper.selectById((Serializable)Integer.valueOf(taskWorkerGroupId));
                if (workerGroup == null) {
                    nodeValueSb.append(-1);
                } else {
                    String[] ipArray;
                    String ips = workerGroup.getIpList();
                    StringBuilder ipSb = new StringBuilder(100);
                    for (String ip : ipArray = ips.split(",")) {
                        long ipLong = IpUtils.ipToLong((String)ip);
                        ipSb.append(ipLong).append(",");
                    }
                    if (ipSb.length() > 0) {
                        ipSb.deleteCharAt(ipSb.length() - 1);
                    }
                    nodeValueSb.append((CharSequence)ipSb);
                }
                logger.info("delete task queue node : {}", (Object)nodeValueSb.toString());
                tasksQueue.removeNode("tasks_queue", nodeValueSb.toString());
            }
        }
        int delete = this.processDao.deleteWorkProcessInstanceById(processInstanceId.intValue());
        this.processDao.deleteAllSubWorkProcessByParentId(processInstanceId.intValue());
        this.processDao.deleteWorkProcessMapByParentId(processInstanceId.intValue());
        if (delete > 0) {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        } else {
            this.putMsg(result, Status.DELETE_PROCESS_INSTANCE_BY_ID_ERROR, new Object[0]);
        }
        return result;
    }

    public Map<String, Object> viewVariables(Integer processInstanceId) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        ProcessInstance processInstance = this.processInstanceMapper.queryDetailById(processInstanceId.intValue());
        if (processInstance == null) {
            throw new RuntimeException("workflow instance is null");
        }
        Map timeParams = BusinessTimeUtils.getBusinessTime((CommandType)processInstance.getCmdTypeIfComplement(), (Date)processInstance.getScheduleTime());
        String workflowInstanceJson = processInstance.getProcessInstanceJson();
        ProcessData workflowData = (ProcessData)JSONUtils.parseObject((String)workflowInstanceJson, ProcessData.class);
        String userDefinedParams = processInstance.getGlobalParams();
        List globalParams = new ArrayList();
        if (userDefinedParams != null && userDefinedParams.length() > 0) {
            globalParams = JSON.parseArray((String)userDefinedParams, Property.class);
        }
        List taskNodeList = workflowData.getTasks();
        String globalParamStr = JSON.toJSONString(globalParams);
        globalParamStr = ParameterUtils.convertParameterPlaceholders((String)globalParamStr, (Map)timeParams);
        globalParams = JSON.parseArray((String)globalParamStr, Property.class);
        for (Object property : globalParams) {
            timeParams.put(property.getProp(), property.getValue());
        }
        HashMap localUserDefParams = new HashMap();
        for (TaskNode taskNode : taskNodeList) {
            String parameter = taskNode.getParams();
            Map map = JSONUtils.toMap((String)parameter);
            String localParams = (String)map.get("localParams");
            if (localParams == null || localParams.isEmpty()) continue;
            localParams = ParameterUtils.convertParameterPlaceholders((String)localParams, (Map)timeParams);
            List localParamsList = JSON.parseArray((String)localParams, Property.class);
            HashMap<String, Object> localParamsMap = new HashMap<String, Object>();
            localParamsMap.put("taskType", taskNode.getType());
            localParamsMap.put("localParamsList", localParamsList);
            if (localParamsList.size() <= 0) continue;
            localUserDefParams.put(taskNode.getName(), localParamsMap);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("globalParams", globalParams);
        resultMap.put("localParams", localUserDefParams);
        result.put("data", resultMap);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> viewGantt(Integer processInstanceId) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ProcessInstance processInstance = this.processInstanceMapper.queryDetailById(processInstanceId.intValue());
        if (processInstance == null) {
            throw new RuntimeException("workflow instance is null");
        }
        GanttDto ganttDto = new GanttDto();
        DAG<String, TaskNode, TaskNodeRelation> dag = ProcessInstanceService.processInstance2DAG(processInstance);
        List nodeList = dag.topologicalSort();
        ganttDto.setTaskNames(nodeList);
        ArrayList<Task> taskList = new ArrayList<Task>();
        for (String node : nodeList) {
            TaskInstance taskInstance = this.taskInstanceMapper.queryByInstanceIdAndName(processInstanceId.intValue(), node);
            if (taskInstance == null) continue;
            Date startTime = taskInstance.getStartTime() == null ? new Date() : taskInstance.getStartTime();
            Date endTime = taskInstance.getEndTime() == null ? new Date() : taskInstance.getEndTime();
            Task task = new Task();
            task.setTaskName(taskInstance.getName());
            task.getStartDate().add(startTime.getTime());
            task.getEndDate().add(endTime.getTime());
            task.setIsoStart(startTime);
            task.setIsoEnd(endTime);
            task.setStatus(taskInstance.getState().toString());
            task.setExecutionDate(taskInstance.getStartTime());
            task.setDuration(DateUtils.format2Readable((long)(endTime.getTime() - startTime.getTime())));
            taskList.add(task);
        }
        ganttDto.setTasks(taskList);
        result.put("data", ganttDto);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }
}

