/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.utils;

import java.util.Scanner;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.utils.FourLetterWordMain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperState {
    private static final Logger logger = LoggerFactory.getLogger(ZooKeeperState.class);
    private final String host;
    private final int port;
    private int minLatency = -1;
    private int avgLatency = -1;
    private int maxLatency = -1;
    private long received = -1L;
    private long sent = -1L;
    private int outStanding = -1;
    private long zxid = -1L;
    private String mode = null;
    private int nodeCount = -1;
    private int watches = -1;
    private int connections = -1;

    public ZooKeeperState(String connectionString) {
        String host = connectionString.substring(0, connectionString.indexOf(58));
        int port = Integer.parseInt(connectionString.substring(connectionString.indexOf(58) + 1));
        this.host = host;
        this.port = port;
    }

    public void getZookeeperInfo() {
        String consText;
        String wchsText;
        String content = this.cmd("srvr");
        if (StringUtils.isNotBlank((CharSequence)content)) {
            Scanner scannerForStat = new Scanner(content);
            while (scannerForStat.hasNext()) {
                String line = scannerForStat.nextLine();
                if (line.startsWith("Latency min/avg/max:")) {
                    String[] latencys = this.getStringValueFromLine(line).split("/");
                    this.minLatency = Integer.parseInt(latencys[0]);
                    this.avgLatency = Integer.parseInt(latencys[1]);
                    this.maxLatency = Integer.parseInt(latencys[2]);
                    continue;
                }
                if (line.startsWith("Received:")) {
                    this.received = Long.parseLong(this.getStringValueFromLine(line));
                    continue;
                }
                if (line.startsWith("Sent:")) {
                    this.sent = Long.parseLong(this.getStringValueFromLine(line));
                    continue;
                }
                if (line.startsWith("Outstanding:")) {
                    this.outStanding = Integer.parseInt(this.getStringValueFromLine(line));
                    continue;
                }
                if (line.startsWith("Zxid:")) {
                    this.zxid = Long.parseLong(this.getStringValueFromLine(line).substring(2), 16);
                    continue;
                }
                if (line.startsWith("Mode:")) {
                    this.mode = this.getStringValueFromLine(line);
                    continue;
                }
                if (!line.startsWith("Node count:")) continue;
                this.nodeCount = Integer.parseInt(this.getStringValueFromLine(line));
            }
            scannerForStat.close();
        }
        if (StringUtils.isNotBlank((CharSequence)(wchsText = this.cmd("wchs")))) {
            Scanner scannerForWchs = new Scanner(wchsText);
            while (scannerForWchs.hasNext()) {
                String line = scannerForWchs.nextLine();
                if (!line.startsWith("Total watches:")) continue;
                this.watches = Integer.parseInt(this.getStringValueFromLine(line));
            }
            scannerForWchs.close();
        }
        if (StringUtils.isNotBlank((CharSequence)(consText = this.cmd("cons")))) {
            Scanner scannerForCons = new Scanner(consText);
            if (StringUtils.isNotBlank((CharSequence)consText)) {
                this.connections = 0;
            }
            while (scannerForCons.hasNext()) {
                String line = scannerForCons.nextLine();
                ++this.connections;
            }
            scannerForCons.close();
        }
    }

    public boolean ruok() {
        return "imok\n".equals(this.cmd("ruok"));
    }

    private String getStringValueFromLine(String line) {
        return line.substring(line.indexOf(":") + 1, line.length()).replaceAll(" ", "").trim();
    }

    private String cmd(String cmd) {
        int waitTimeout = 5;
        SendThread sendThread = new SendThread(cmd);
        sendThread.setName("FourLetterCmd:" + cmd);
        sendThread.start();
        try {
            sendThread.join(5000L);
            return sendThread.ret;
        }
        catch (InterruptedException e) {
            logger.error("send " + cmd + " to server " + this.host + ":" + this.port + " failed!", (Throwable)e);
            return "";
        }
    }

    public Logger getLogger() {
        return logger;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getMinLatency() {
        return this.minLatency;
    }

    public int getAvgLatency() {
        return this.avgLatency;
    }

    public int getMaxLatency() {
        return this.maxLatency;
    }

    public long getReceived() {
        return this.received;
    }

    public long getSent() {
        return this.sent;
    }

    public int getOutStanding() {
        return this.outStanding;
    }

    public long getZxid() {
        return this.zxid;
    }

    public String getMode() {
        return this.mode;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public int getWatches() {
        return this.watches;
    }

    public int getConnections() {
        return this.connections;
    }

    public String toString() {
        return "ZooKeeperState [host=" + this.host + ", port=" + this.port + ", minLatency=" + this.minLatency + ", avgLatency=" + this.avgLatency + ", maxLatency=" + this.maxLatency + ", received=" + this.received + ", sent=" + this.sent + ", outStanding=" + this.outStanding + ", zxid=" + this.zxid + ", mode=" + this.mode + ", nodeCount=" + this.nodeCount + ", watches=" + this.watches + ", connections=" + this.connections + "]";
    }

    private class SendThread
    extends Thread {
        private String cmd;
        public String ret = "";

        public SendThread(String cmd) {
            this.cmd = cmd;
        }

        @Override
        public void run() {
            try {
                this.ret = FourLetterWordMain.send4LetterWord(ZooKeeperState.this.host, ZooKeeperState.this.port, this.cmd);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                return;
            }
        }
    }
}

