/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.AccessTokenService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.dao.entity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"ACCESS_TOKEN_TAG"}, position=1)
@RestController
@RequestMapping(value={"/access-token"})
public class AccessTokenController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(AccessTokenController.class);
    @Autowired
    private AccessTokenService accessTokenService;

    @ApiIgnore
    @PostMapping(value={"/create"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_ACCESS_TOKEN_ERROR)
    public Result createToken(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") int userId, @RequestParam(value="expireTime") String expireTime, @RequestParam(value="token") String token) {
        logger.info("login user {}, create token , userId : {} , token expire time : {} , token : {}", new Object[]{loginUser.getUserName(), userId, expireTime, token});
        Map<String, Object> result = this.accessTokenService.createToken(userId, expireTime, token);
        return this.returnDataList(result);
    }

    @ApiIgnore
    @PostMapping(value={"/generate"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.GENERATE_TOKEN_ERROR)
    public Result generateToken(@RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") int userId, @RequestParam(value="expireTime") String expireTime) {
        logger.info("login user {}, generate token , userId : {} , token expire time : {}", new Object[]{loginUser, userId, expireTime});
        Map<String, Object> result = this.accessTokenService.generateToken(userId, expireTime);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryAccessTokenList", notes="QUERY_ACCESS_TOKEN_LIST_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="searchVal", value="SEARCH_VAL", dataType="String"), @ApiImplicitParam(name="pageNo", value="PAGE_NO", dataType="Int", example="1"), @ApiImplicitParam(name="pageSize", value="PAGE_SIZE", dataType="Int", example="20")})
    @GetMapping(value={"/list-paging"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_ACCESSTOKEN_LIST_PAGING_ERROR)
    public Result queryAccessTokenList(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="pageSize") Integer pageSize) {
        logger.info("login user {}, list access token paging, pageNo: {}, searchVal: {}, pageSize: {}", new Object[]{loginUser.getUserName(), pageNo, searchVal, pageSize});
        Map<String, Object> result = this.checkPageParams(pageNo, pageSize);
        if (result.get("status") != Status.SUCCESS) {
            return this.returnDataListPaging(result);
        }
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        result = this.accessTokenService.queryAccessTokenList(loginUser, searchVal, pageNo, pageSize);
        return this.returnDataListPaging(result);
    }

    @ApiIgnore
    @PostMapping(value={"/delete"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_ACCESS_TOKEN_ERROR)
    public Result delAccessTokenById(@RequestAttribute(value="session.user") User loginUser, @RequestParam(value="id") int id) {
        logger.info("login user {}, delete access token, id: {},", (Object)loginUser.getUserName(), (Object)id);
        Map<String, Object> result = this.accessTokenService.delAccessTokenById(loginUser, id);
        return this.returnDataList(result);
    }

    @ApiIgnore
    @PostMapping(value={"/update"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UPDATE_ACCESS_TOKEN_ERROR)
    public Result updateToken(@RequestAttribute(value="session.user") User loginUser, @RequestParam(value="id") int id, @RequestParam(value="userId") int userId, @RequestParam(value="expireTime") String expireTime, @RequestParam(value="token") String token) {
        logger.info("login user {}, update token , userId : {} , token expire time : {} , token : {}", new Object[]{loginUser.getUserName(), userId, expireTime, token});
        Map<String, Object> result = this.accessTokenService.updateToken(id, userId, expireTime, token);
        return this.returnDataList(result);
    }
}

