/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.text.ParseException;
import java.util.Map;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.ExecuteType;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.ExecutorService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.FailureStrategy;
import org.apache.dolphinscheduler.common.enums.Priority;
import org.apache.dolphinscheduler.common.enums.RunMode;
import org.apache.dolphinscheduler.common.enums.TaskDependType;
import org.apache.dolphinscheduler.common.enums.WarningType;
import org.apache.dolphinscheduler.dao.entity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"PROCESS_INSTANCE_EXECUTOR_TAG"}, position=1)
@RestController
@RequestMapping(value={"projects/{projectName}/executors"})
public class ExecutorController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(ExecutorController.class);
    @Autowired
    private ExecutorService execService;

    @ApiOperation(value="startProcessInstance", notes="RUN_PROCESS_INSTANCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processDefinitionId", value="PROCESS_DEFINITION_ID", required=true, dataType="Int", example="100"), @ApiImplicitParam(name="scheduleTime", value="SCHEDULE_TIME", required=true, dataType="String"), @ApiImplicitParam(name="failureStrategy", value="FAILURE_STRATEGY", required=true, dataType="FailureStrategy"), @ApiImplicitParam(name="startNodeList", value="START_NODE_LIST", dataType="String"), @ApiImplicitParam(name="taskDependType", value="TASK_DEPEND_TYPE", dataType="TaskDependType"), @ApiImplicitParam(name="execType", value="COMMAND_TYPE", dataType="CommandType"), @ApiImplicitParam(name="warningType", value="WARNING_TYPE", required=true, dataType="WarningType"), @ApiImplicitParam(name="warningGroupId", value="WARNING_GROUP_ID", required=true, dataType="Int", example="100"), @ApiImplicitParam(name="receivers", value="RECEIVERS", dataType="String"), @ApiImplicitParam(name="receiversCc", value="RECEIVERS_CC", dataType="String"), @ApiImplicitParam(name="runMode", value="RUN_MODE", dataType="RunMode"), @ApiImplicitParam(name="processInstancePriority", value="PROCESS_INSTANCE_PRIORITY", required=true, dataType="Priority"), @ApiImplicitParam(name="workerGroup", value="WORKER_GROUP", dataType="String", example="default"), @ApiImplicitParam(name="timeout", value="TIMEOUT", dataType="Int", example="100")})
    @PostMapping(value={"start-process-instance"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.START_PROCESS_INSTANCE_ERROR)
    public Result startProcessInstance(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectName", value="PROJECT_NAME", required=true) @PathVariable String projectName, @RequestParam(value="processDefinitionId") int processDefinitionId, @RequestParam(value="scheduleTime", required=false) String scheduleTime, @RequestParam(value="failureStrategy", required=true) FailureStrategy failureStrategy, @RequestParam(value="startNodeList", required=false) String startNodeList, @RequestParam(value="taskDependType", required=false) TaskDependType taskDependType, @RequestParam(value="execType", required=false) CommandType execType, @RequestParam(value="warningType", required=true) WarningType warningType, @RequestParam(value="warningGroupId", required=false) int warningGroupId, @RequestParam(value="receivers", required=false) String receivers, @RequestParam(value="receiversCc", required=false) String receiversCc, @RequestParam(value="runMode", required=false) RunMode runMode, @RequestParam(value="processInstancePriority", required=false) Priority processInstancePriority, @RequestParam(value="workerGroup", required=false, defaultValue="default") String workerGroup, @RequestParam(value="timeout", required=false) Integer timeout) throws ParseException {
        logger.info("login user {}, start process instance, project name: {}, process definition id: {}, schedule time: {}, failure policy: {}, node name: {}, node dep: {}, notify type: {}, notify group id: {},receivers:{},receiversCc:{}, run mode: {},process instance priority:{}, workerGroup: {}, timeout: {}", new Object[]{loginUser.getUserName(), projectName, processDefinitionId, scheduleTime, failureStrategy, startNodeList, taskDependType, warningType, workerGroup, receivers, receiversCc, runMode, processInstancePriority, workerGroup, timeout});
        if (timeout == null) {
            timeout = 86400;
        }
        Map<String, Object> result = this.execService.execProcessInstance(loginUser, projectName, processDefinitionId, scheduleTime, execType, failureStrategy, startNodeList, taskDependType, warningType, warningGroupId, receivers, receiversCc, runMode, processInstancePriority, workerGroup, timeout);
        return this.returnDataList(result);
    }

    @ApiOperation(value="execute", notes="EXECUTE_ACTION_TO_PROCESS_INSTANCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processInstanceId", value="PROCESS_INSTANCE_ID", required=true, dataType="Int", example="100"), @ApiImplicitParam(name="executeType", value="EXECUTE_TYPE", required=true, dataType="ExecuteType")})
    @PostMapping(value={"/execute"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.EXECUTE_PROCESS_INSTANCE_ERROR)
    public Result execute(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectName", value="PROJECT_NAME", required=true) @PathVariable String projectName, @RequestParam(value="processInstanceId") Integer processInstanceId, @RequestParam(value="executeType") ExecuteType executeType) {
        logger.info("execute command, login user: {}, project:{}, process instance id:{}, execute type:{}", new Object[]{loginUser.getUserName(), projectName, processInstanceId, executeType});
        Map<String, Object> result = this.execService.execute(loginUser, projectName, processInstanceId, executeType);
        return this.returnDataList(result);
    }

    @ApiOperation(value="startCheckProcessDefinition", notes="START_CHECK_PROCESS_DEFINITION_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processDefinitionId", value="PROCESS_DEFINITION_ID", required=true, dataType="Int", example="100")})
    @PostMapping(value={"/start-check"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.CHECK_PROCESS_DEFINITION_ERROR)
    public Result startCheckProcessDefinition(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="processDefinitionId") int processDefinitionId) {
        logger.info("login user {}, check process definition {}", (Object)loginUser.getUserName(), (Object)processDefinitionId);
        Map<String, Object> result = this.execService.startCheckByProcessDefinedId(processDefinitionId);
        return this.returnDataList(result);
    }

    @ApiIgnore
    @ApiOperation(value="getReceiverCc", notes="GET_RECEIVER_CC_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processDefinitionId", value="PROCESS_DEFINITION_ID", required=true, dataType="Int", example="100"), @ApiImplicitParam(name="processInstanceId", value="PROCESS_INSTANCE_ID", required=true, dataType="Int", example="100")})
    @GetMapping(value={"/get-receiver-cc"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_RECIPIENTS_AND_COPYERS_BY_PROCESS_DEFINITION_ERROR)
    public Result getReceiverCc(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="processDefinitionId", required=false) Integer processDefinitionId, @RequestParam(value="processInstanceId", required=false) Integer processInstanceId) {
        logger.info("login user {}, get process definition receiver and cc", (Object)loginUser.getUserName());
        Map<String, Object> result = this.execService.getReceiverCc(processDefinitionId, processInstanceId);
        return this.returnDataList(result);
    }
}

