/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.dolphinscheduler.api.dto.ProcessMeta;
import org.apache.dolphinscheduler.api.dto.treeview.Instance;
import org.apache.dolphinscheduler.api.dto.treeview.TreeViewDto;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.BaseDAGService;
import org.apache.dolphinscheduler.api.service.ProjectService;
import org.apache.dolphinscheduler.api.service.SchedulerService;
import org.apache.dolphinscheduler.api.utils.CheckUtils;
import org.apache.dolphinscheduler.api.utils.FileUtils;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.exportprocess.ProcessAddTaskParam;
import org.apache.dolphinscheduler.api.utils.exportprocess.TaskNodeParamFactory;
import org.apache.dolphinscheduler.common.enums.AuthorizationType;
import org.apache.dolphinscheduler.common.enums.FailureStrategy;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.Priority;
import org.apache.dolphinscheduler.common.enums.ReleaseState;
import org.apache.dolphinscheduler.common.enums.TaskType;
import org.apache.dolphinscheduler.common.enums.UserType;
import org.apache.dolphinscheduler.common.enums.WarningType;
import org.apache.dolphinscheduler.common.graph.DAG;
import org.apache.dolphinscheduler.common.model.TaskNode;
import org.apache.dolphinscheduler.common.model.TaskNodeRelation;
import org.apache.dolphinscheduler.common.process.ProcessDag;
import org.apache.dolphinscheduler.common.task.AbstractParameters;
import org.apache.dolphinscheduler.common.thread.Stopper;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.common.utils.TaskParametersUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessData;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.Schedule;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessInstanceMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.ScheduleMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskInstanceMapper;
import org.apache.dolphinscheduler.dao.utils.DagHelper;
import org.apache.dolphinscheduler.service.permission.PermissionCheck;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ProcessDefinitionService
extends BaseDAGService {
    private static final Logger logger = LoggerFactory.getLogger(ProcessDefinitionService.class);
    @Autowired
    private ProjectMapper projectMapper;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private ProcessDefinitionMapper processDefineMapper;
    @Autowired
    private ProcessInstanceMapper processInstanceMapper;
    @Autowired
    private TaskInstanceMapper taskInstanceMapper;
    @Autowired
    private ScheduleMapper scheduleMapper;
    @Autowired
    private ProcessService processService;

    public Map<String, Object> createProcessDefinition(User loginUser, String projectName, String name, String processDefinitionJson, String desc, String locations, String connects) throws JsonProcessingException {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        Project project = this.projectMapper.queryByName(projectName);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectName);
        Status resultStatus = (Status)((Object)checkResult.get("status"));
        if (resultStatus != Status.SUCCESS) {
            return checkResult;
        }
        ProcessDefinition processDefine = new ProcessDefinition();
        Date now = new Date();
        ProcessData processData = (ProcessData)JSONUtils.parseObject((String)processDefinitionJson, ProcessData.class);
        Map<String, Object> checkProcessJson = this.checkProcessNodeList(processData, processDefinitionJson);
        if (checkProcessJson.get("status") != Status.SUCCESS) {
            return checkProcessJson;
        }
        processDefine.setName(name);
        processDefine.setReleaseState(ReleaseState.OFFLINE);
        processDefine.setProjectId(project.getId());
        processDefine.setUserId(loginUser.getId());
        processDefine.setProcessDefinitionJson(processDefinitionJson);
        processDefine.setDescription(desc);
        processDefine.setLocations(locations);
        processDefine.setConnects(connects);
        processDefine.setTimeout(processData.getTimeout());
        processDefine.setTenantId(processData.getTenantId());
        processDefine.setModifyBy(loginUser.getUserName());
        processDefine.setResourceIds(this.getResourceIds(processData));
        ArrayList globalParamsList = processData.getGlobalParams();
        if (CollectionUtils.isNotEmpty((Collection)globalParamsList)) {
            HashSet globalParamsSet = new HashSet(globalParamsList);
            globalParamsList = new ArrayList(globalParamsSet);
            processDefine.setGlobalParamList(globalParamsList);
        }
        processDefine.setCreateTime(now);
        processDefine.setUpdateTime(now);
        processDefine.setFlag(Flag.YES);
        this.processDefineMapper.insert((Object)processDefine);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        result.put("processDefinitionId", processDefine.getId());
        return result;
    }

    private String getResourceIds(ProcessData processData) {
        List tasks = processData.getTasks();
        HashSet resourceIds = new HashSet();
        for (TaskNode taskNode : tasks) {
            String taskParameter = taskNode.getParams();
            AbstractParameters params = TaskParametersUtils.getParameters((String)taskNode.getType(), (String)taskParameter);
            if (!CollectionUtils.isNotEmpty((Collection)params.getResourceFilesList())) continue;
            Set tempSet = params.getResourceFilesList().stream().map(t -> t.getId()).collect(Collectors.toSet());
            resourceIds.addAll(tempSet);
        }
        StringBuilder sb = new StringBuilder();
        Iterator iterator = resourceIds.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(i);
        }
        return sb.toString();
    }

    public Map<String, Object> queryProcessDefinitionList(User loginUser, String projectName) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        Project project = this.projectMapper.queryByName(projectName);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectName);
        Status resultStatus = (Status)((Object)checkResult.get("status"));
        if (resultStatus != Status.SUCCESS) {
            return checkResult;
        }
        List resourceList = this.processDefineMapper.queryAllDefinitionList(project.getId());
        result.put("data", resourceList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> queryProcessDefinitionListPaging(User loginUser, String projectName, String searchVal, Integer pageNo, Integer pageSize, Integer userId) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        Project project = this.projectMapper.queryByName(projectName);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectName);
        Status resultStatus = (Status)((Object)checkResult.get("status"));
        if (resultStatus != Status.SUCCESS) {
            return checkResult;
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage processDefinitionIPage = this.processDefineMapper.queryDefineListPaging((IPage)page, searchVal, userId.intValue(), project.getId(), this.isAdmin(loginUser));
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        pageInfo.setTotalCount((int)processDefinitionIPage.getTotal());
        pageInfo.setLists(processDefinitionIPage.getRecords());
        result.put("data", pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> queryProcessDefinitionById(User loginUser, String projectName, Integer processId) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        Project project = this.projectMapper.queryByName(projectName);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectName);
        Status resultStatus = (Status)((Object)checkResult.get("status"));
        if (resultStatus != Status.SUCCESS) {
            return checkResult;
        }
        ProcessDefinition processDefinition = (ProcessDefinition)this.processDefineMapper.selectById((Serializable)processId);
        if (processDefinition == null) {
            this.putMsg(result, Status.PROCESS_INSTANCE_NOT_EXIST, processId);
        } else {
            result.put("data", processDefinition);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    public Map<String, Object> copyProcessDefinition(User loginUser, String projectName, Integer processId) throws JsonProcessingException {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        Project project = this.projectMapper.queryByName(projectName);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectName);
        Status resultStatus = (Status)((Object)checkResult.get("status"));
        if (resultStatus != Status.SUCCESS) {
            return checkResult;
        }
        ProcessDefinition processDefinition = (ProcessDefinition)this.processDefineMapper.selectById((Serializable)processId);
        if (processDefinition == null) {
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, processId);
            return result;
        }
        return this.createProcessDefinition(loginUser, projectName, processDefinition.getName() + "_copy_" + System.currentTimeMillis(), processDefinition.getProcessDefinitionJson(), processDefinition.getDescription(), processDefinition.getLocations(), processDefinition.getConnects());
    }

    public Map<String, Object> updateProcessDefinition(User loginUser, String projectName, int id, String name, String processDefinitionJson, String desc, String locations, String connects) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        Project project = this.projectMapper.queryByName(projectName);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectName);
        Status resultStatus = (Status)((Object)checkResult.get("status"));
        if (resultStatus != Status.SUCCESS) {
            return checkResult;
        }
        ProcessData processData = (ProcessData)JSONUtils.parseObject((String)processDefinitionJson, ProcessData.class);
        Map<String, Object> checkProcessJson = this.checkProcessNodeList(processData, processDefinitionJson);
        if (checkProcessJson.get("status") != Status.SUCCESS) {
            return checkProcessJson;
        }
        ProcessDefinition processDefine = this.processService.findProcessDefineById(id);
        if (processDefine == null) {
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, id);
            return result;
        }
        if (processDefine.getReleaseState() == ReleaseState.ONLINE) {
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_ALLOWED_EDIT, processDefine.getName());
            return result;
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        Date now = new Date();
        processDefine.setId(id);
        processDefine.setName(name);
        processDefine.setReleaseState(ReleaseState.OFFLINE);
        processDefine.setProjectId(project.getId());
        processDefine.setProcessDefinitionJson(processDefinitionJson);
        processDefine.setDescription(desc);
        processDefine.setLocations(locations);
        processDefine.setConnects(connects);
        processDefine.setTimeout(processData.getTimeout());
        processDefine.setTenantId(processData.getTenantId());
        processDefine.setModifyBy(loginUser.getUserName());
        processDefine.setResourceIds(this.getResourceIds(processData));
        ArrayList globalParamsList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)processData.getGlobalParams())) {
            HashSet userDefParamsSet = new HashSet(processData.getGlobalParams());
            globalParamsList = new ArrayList(userDefParamsSet);
        }
        processDefine.setGlobalParamList(globalParamsList);
        processDefine.setUpdateTime(now);
        processDefine.setFlag(Flag.YES);
        if (this.processDefineMapper.updateById((Object)processDefine) > 0) {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        } else {
            this.putMsg(result, Status.UPDATE_PROCESS_DEFINITION_ERROR, new Object[0]);
        }
        return result;
    }

    public Map<String, Object> verifyProcessDefinitionName(User loginUser, String projectName, String name) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Project project = this.projectMapper.queryByName(projectName);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectName);
        Status resultEnum = (Status)((Object)checkResult.get("status"));
        if (resultEnum != Status.SUCCESS) {
            return checkResult;
        }
        ProcessDefinition processDefinition = this.processDefineMapper.queryByDefineName(project.getId(), name);
        if (processDefinition == null) {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        } else {
            this.putMsg(result, Status.PROCESS_INSTANCE_EXIST, name);
        }
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public Map<String, Object> deleteProcessDefinitionById(User loginUser, String projectName, Integer processDefinitionId) {
        int delete;
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        Project project = this.projectMapper.queryByName(projectName);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectName);
        Status resultEnum = (Status)((Object)checkResult.get("status"));
        if (resultEnum != Status.SUCCESS) {
            return checkResult;
        }
        ProcessDefinition processDefinition = (ProcessDefinition)this.processDefineMapper.selectById((Serializable)processDefinitionId);
        if (processDefinition == null) {
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, processDefinitionId);
            return result;
        }
        if (loginUser.getId() != processDefinition.getUserId() && loginUser.getUserType() != UserType.ADMIN_USER) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        if (processDefinition.getReleaseState() == ReleaseState.ONLINE) {
            this.putMsg(result, Status.PROCESS_DEFINE_STATE_ONLINE, processDefinitionId);
            return result;
        }
        List schedules = this.scheduleMapper.queryByProcessDefinitionId(processDefinitionId.intValue());
        if (!schedules.isEmpty() && schedules.size() > 1) {
            logger.warn("scheduler num is {},Greater than 1", (Object)schedules.size());
            this.putMsg(result, Status.DELETE_PROCESS_DEFINE_BY_ID_ERROR, new Object[0]);
            return result;
        }
        if (schedules.size() == 1) {
            Schedule schedule = (Schedule)schedules.get(0);
            if (schedule.getReleaseState() == ReleaseState.OFFLINE) {
                this.scheduleMapper.deleteById((Serializable)Integer.valueOf(schedule.getId()));
            } else if (schedule.getReleaseState() == ReleaseState.ONLINE) {
                this.putMsg(result, Status.SCHEDULE_CRON_STATE_ONLINE, schedule.getId());
                return result;
            }
        }
        if ((delete = this.processDefineMapper.deleteById((Serializable)processDefinitionId)) > 0) {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        } else {
            this.putMsg(result, Status.DELETE_PROCESS_DEFINE_BY_ID_ERROR, new Object[0]);
        }
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public Map<String, Object> releaseProcessDefinition(User loginUser, String projectName, int id, int releaseState) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Project project = this.projectMapper.queryByName(projectName);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectName);
        Status resultEnum = (Status)((Object)checkResult.get("status"));
        if (resultEnum != Status.SUCCESS) {
            return checkResult;
        }
        ReleaseState state = ReleaseState.getEnum((int)releaseState);
        if (null == state) {
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, "releaseState");
            return result;
        }
        ProcessDefinition processDefinition = (ProcessDefinition)this.processDefineMapper.selectById((Serializable)Integer.valueOf(id));
        switch (state) {
            case ONLINE: {
                String resourceIds = processDefinition.getResourceIds();
                if (StringUtils.isNotBlank((String)resourceIds)) {
                    Object[] resourceIdArray = (Integer[])Arrays.stream(resourceIds.split(",")).map(Integer::parseInt).toArray(Integer[]::new);
                    PermissionCheck permissionCheck = new PermissionCheck(AuthorizationType.RESOURCE_FILE_ID, this.processService, resourceIdArray, loginUser.getId(), logger);
                    try {
                        permissionCheck.checkPermission();
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        this.putMsg(result, Status.RESOURCE_NOT_EXIST_OR_NO_PERMISSION, "releaseState");
                        return result;
                    }
                }
                processDefinition.setReleaseState(state);
                this.processDefineMapper.updateById((Object)processDefinition);
                break;
            }
            case OFFLINE: {
                processDefinition.setReleaseState(state);
                this.processDefineMapper.updateById((Object)processDefinition);
                List scheduleList = this.scheduleMapper.selectAllByProcessDefineArray(new int[]{processDefinition.getId()});
                for (Schedule schedule : scheduleList) {
                    logger.info("set schedule offline, project id: {}, schedule id: {}, process definition id: {}", new Object[]{project.getId(), schedule.getId(), id});
                    schedule.setReleaseState(ReleaseState.OFFLINE);
                    this.scheduleMapper.updateById((Object)schedule);
                    SchedulerService.deleteSchedule(project.getId(), schedule.getId());
                }
                break;
            }
            default: {
                this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, "releaseState");
                return result;
            }
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public void batchExportProcessDefinitionByIds(User loginUser, String projectName, String processDefinitionIds, HttpServletResponse response) {
        if (StringUtils.isEmpty((CharSequence)processDefinitionIds)) {
            return;
        }
        Project project = this.projectMapper.queryByName(projectName);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectName);
        Status resultStatus = (Status)((Object)checkResult.get("status"));
        if (resultStatus != Status.SUCCESS) {
            return;
        }
        List<ProcessMeta> processDefinitionList = this.getProcessDefinitionList(processDefinitionIds);
        if (CollectionUtils.isNotEmpty(processDefinitionList)) {
            this.downloadProcessDefinitionFile(response, processDefinitionList);
        }
    }

    private List<ProcessMeta> getProcessDefinitionList(String processDefinitionIds) {
        String[] processDefinitionIdArray;
        ArrayList<ProcessMeta> processDefinitionList = new ArrayList<ProcessMeta>();
        for (String strProcessDefinitionId : processDefinitionIdArray = processDefinitionIds.split(",")) {
            int processDefinitionId = Integer.parseInt(strProcessDefinitionId);
            ProcessDefinition processDefinition = this.processDefineMapper.queryByDefineId(processDefinitionId);
            if (null == processDefinition) continue;
            processDefinitionList.add(this.exportProcessMetaData(processDefinitionId, processDefinition));
        }
        return processDefinitionList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadProcessDefinitionFile(HttpServletResponse response, List<ProcessMeta> processDefinitionList) {
        response.setContentType("application/json;charset=UTF-8");
        BufferedOutputStream buff = null;
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            buff = new BufferedOutputStream((OutputStream)out);
            buff.write(JSON.toJSONString(processDefinitionList).getBytes(StandardCharsets.UTF_8));
            buff.flush();
            buff.close();
        }
        catch (IOException e) {
            logger.warn("export process fail", (Throwable)e);
        }
        finally {
            if (null != buff) {
                try {
                    buff.close();
                }
                catch (Exception e) {
                    logger.warn("export process buffer not close", (Throwable)e);
                }
            }
            if (null != out) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    logger.warn("export process output stream not close", (Throwable)e);
                }
            }
        }
    }

    public String exportProcessMetaDataStr(Integer processDefinitionId, ProcessDefinition processDefinition) {
        return JSONUtils.toJsonString((Object)this.exportProcessMetaData(processDefinitionId, processDefinition));
    }

    public ProcessMeta exportProcessMetaData(Integer processDefinitionId, ProcessDefinition processDefinition) {
        String correctProcessDefinitionJson = this.addExportTaskNodeSpecialParam(processDefinition.getProcessDefinitionJson());
        processDefinition.setProcessDefinitionJson(correctProcessDefinitionJson);
        ProcessMeta exportProcessMeta = new ProcessMeta();
        exportProcessMeta.setProjectName(processDefinition.getProjectName());
        exportProcessMeta.setProcessDefinitionName(processDefinition.getName());
        exportProcessMeta.setProcessDefinitionJson(processDefinition.getProcessDefinitionJson());
        exportProcessMeta.setProcessDefinitionLocations(processDefinition.getLocations());
        exportProcessMeta.setProcessDefinitionConnects(processDefinition.getConnects());
        List schedules = this.scheduleMapper.queryByProcessDefinitionId(processDefinitionId.intValue());
        if (!schedules.isEmpty()) {
            Schedule schedule = (Schedule)schedules.get(0);
            exportProcessMeta.setScheduleWarningType(schedule.getWarningType().toString());
            exportProcessMeta.setScheduleWarningGroupId(schedule.getWarningGroupId());
            exportProcessMeta.setScheduleStartTime(DateUtils.dateToString((Date)schedule.getStartTime()));
            exportProcessMeta.setScheduleEndTime(DateUtils.dateToString((Date)schedule.getEndTime()));
            exportProcessMeta.setScheduleCrontab(schedule.getCrontab());
            exportProcessMeta.setScheduleFailureStrategy(String.valueOf(schedule.getFailureStrategy()));
            exportProcessMeta.setScheduleReleaseState(String.valueOf(ReleaseState.OFFLINE));
            exportProcessMeta.setScheduleProcessInstancePriority(String.valueOf(schedule.getProcessInstancePriority()));
            exportProcessMeta.setScheduleWorkerGroupName(schedule.getWorkerGroup());
        }
        return exportProcessMeta;
    }

    public String addExportTaskNodeSpecialParam(String processDefinitionJson) {
        JSONObject jsonObject = JSONUtils.parseObject((String)processDefinitionJson);
        JSONArray jsonArray = (JSONArray)jsonObject.get((Object)"tasks");
        for (int i = 0; i < jsonArray.size(); ++i) {
            String taskType;
            ProcessAddTaskParam addTaskParam;
            JSONObject taskNode = jsonArray.getJSONObject(i);
            if (!StringUtils.isNotEmpty((CharSequence)taskNode.getString("type")) || null == (addTaskParam = TaskNodeParamFactory.getByTaskType(taskType = taskNode.getString("type")))) continue;
            addTaskParam.addExportSpecialParam(taskNode);
        }
        jsonObject.put("tasks", (Object)jsonArray);
        return jsonObject.toString();
    }

    private boolean checkTaskHasSubProcess(String taskType) {
        return taskType.equals(TaskType.SUB_PROCESS.name());
    }

    @Transactional(rollbackFor={Exception.class})
    public Map<String, Object> importProcessDefinition(User loginUser, MultipartFile file, String currentProjectName) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        String processMetaJson = FileUtils.file2String(file);
        List processMetaList = JSON.parseArray((String)processMetaJson, ProcessMeta.class);
        if (CollectionUtils.isEmpty((Collection)processMetaList)) {
            this.putMsg(result, Status.DATA_IS_NULL, "fileContent");
            return result;
        }
        for (ProcessMeta processMeta : processMetaList) {
            if (this.checkAndImportProcessDefinition(loginUser, currentProjectName, result, processMeta)) continue;
            return result;
        }
        return result;
    }

    private boolean checkAndImportProcessDefinition(User loginUser, String currentProjectName, Map<String, Object> result, ProcessMeta processMeta) {
        Map<String, Object> checkResult;
        Status status;
        if (!this.checkImportanceParams(processMeta, result)) {
            return false;
        }
        String processDefinitionName = processMeta.getProcessDefinitionName();
        Project targetProject = this.projectMapper.queryByName(currentProjectName);
        if (null != targetProject) {
            processDefinitionName = this.recursionProcessDefinitionName(targetProject.getId(), processDefinitionName, 1);
        }
        if (!Status.SUCCESS.equals((Object)(status = (Status)((Object)(checkResult = this.verifyProcessDefinitionName(loginUser, currentProjectName, processDefinitionName)).get("status"))))) {
            result.putAll(checkResult);
            return false;
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        Map<String, Object> createProcessResult = this.getCreateProcessResult(loginUser, currentProjectName, result, processMeta, processDefinitionName, this.addImportTaskNodeParam(loginUser, processMeta.getProcessDefinitionJson(), targetProject));
        if (createProcessResult == null) {
            return false;
        }
        Integer processDefinitionId = Objects.isNull(createProcessResult.get("processDefinitionId")) ? null : Integer.valueOf(Integer.parseInt(createProcessResult.get("processDefinitionId").toString()));
        return this.getImportProcessScheduleResult(loginUser, currentProjectName, result, processMeta, processDefinitionName, processDefinitionId);
    }

    private Map<String, Object> getCreateProcessResult(User loginUser, String currentProjectName, Map<String, Object> result, ProcessMeta processMeta, String processDefinitionName, String importProcessParam) {
        Map<String, Object> createProcessResult = null;
        try {
            createProcessResult = this.createProcessDefinition(loginUser, currentProjectName, processDefinitionName + "_import_" + System.currentTimeMillis(), importProcessParam, processMeta.getProcessDefinitionDescription(), processMeta.getProcessDefinitionLocations(), processMeta.getProcessDefinitionConnects());
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        catch (JsonProcessingException e) {
            logger.error("import process meta json data: {}", (Object)e.getMessage(), (Object)e);
            this.putMsg(result, Status.IMPORT_PROCESS_DEFINE_ERROR, new Object[0]);
        }
        return createProcessResult;
    }

    private boolean getImportProcessScheduleResult(User loginUser, String currentProjectName, Map<String, Object> result, ProcessMeta processMeta, String processDefinitionName, Integer processDefinitionId) {
        int scheduleInsert;
        if (null != processMeta.getScheduleCrontab() && null != processDefinitionId && 0 == (scheduleInsert = this.importProcessSchedule(loginUser, currentProjectName, processMeta, processDefinitionName, processDefinitionId))) {
            this.putMsg(result, Status.IMPORT_PROCESS_DEFINE_ERROR, new Object[0]);
            return false;
        }
        return true;
    }

    private boolean checkImportanceParams(ProcessMeta processMeta, Map<String, Object> result) {
        if (StringUtils.isEmpty((CharSequence)processMeta.getProjectName())) {
            this.putMsg(result, Status.DATA_IS_NULL, "projectName");
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)processMeta.getProcessDefinitionName())) {
            this.putMsg(result, Status.DATA_IS_NULL, "processDefinitionName");
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)processMeta.getProcessDefinitionJson())) {
            this.putMsg(result, Status.DATA_IS_NULL, "processDefinitionJson");
            return false;
        }
        return true;
    }

    private String addImportTaskNodeParam(User loginUser, String processDefinitionJson, Project targetProject) {
        JSONObject jsonObject = JSONUtils.parseObject((String)processDefinitionJson);
        JSONArray jsonArray = (JSONArray)jsonObject.get((Object)"tasks");
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject taskNode = jsonArray.getJSONObject(i);
            String taskType = taskNode.getString("type");
            ProcessAddTaskParam addTaskParam = TaskNodeParamFactory.getByTaskType(taskType);
            if (null == addTaskParam) continue;
            addTaskParam.addImportSpecialParam(taskNode);
        }
        HashMap<Integer, Integer> subProcessIdMap = new HashMap<Integer, Integer>(20);
        List subProcessList = jsonArray.stream().filter(elem -> this.checkTaskHasSubProcess(JSONUtils.parseObject((String)elem.toString()).getString("type"))).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(subProcessList)) {
            this.importSubProcess(loginUser, targetProject, jsonArray, subProcessIdMap);
        }
        jsonObject.put("tasks", (Object)jsonArray);
        return jsonObject.toString();
    }

    public int importProcessSchedule(User loginUser, String currentProjectName, ProcessMeta processMeta, String processDefinitionName, Integer processDefinitionId) {
        Date now = new Date();
        Schedule scheduleObj = new Schedule();
        scheduleObj.setProjectName(currentProjectName);
        scheduleObj.setProcessDefinitionId(processDefinitionId.intValue());
        scheduleObj.setProcessDefinitionName(processDefinitionName);
        scheduleObj.setCreateTime(now);
        scheduleObj.setUpdateTime(now);
        scheduleObj.setUserId(loginUser.getId());
        scheduleObj.setUserName(loginUser.getUserName());
        scheduleObj.setCrontab(processMeta.getScheduleCrontab());
        if (null != processMeta.getScheduleStartTime()) {
            scheduleObj.setStartTime(DateUtils.stringToDate((String)processMeta.getScheduleStartTime()));
        }
        if (null != processMeta.getScheduleEndTime()) {
            scheduleObj.setEndTime(DateUtils.stringToDate((String)processMeta.getScheduleEndTime()));
        }
        if (null != processMeta.getScheduleWarningType()) {
            scheduleObj.setWarningType(WarningType.valueOf((String)processMeta.getScheduleWarningType()));
        }
        if (null != processMeta.getScheduleWarningGroupId()) {
            scheduleObj.setWarningGroupId(processMeta.getScheduleWarningGroupId().intValue());
        }
        if (null != processMeta.getScheduleFailureStrategy()) {
            scheduleObj.setFailureStrategy(FailureStrategy.valueOf((String)processMeta.getScheduleFailureStrategy()));
        }
        if (null != processMeta.getScheduleReleaseState()) {
            scheduleObj.setReleaseState(ReleaseState.valueOf((String)processMeta.getScheduleReleaseState()));
        }
        if (null != processMeta.getScheduleProcessInstancePriority()) {
            scheduleObj.setProcessInstancePriority(Priority.valueOf((String)processMeta.getScheduleProcessInstancePriority()));
        }
        if (null != processMeta.getScheduleWorkerGroupName()) {
            scheduleObj.setWorkerGroup(processMeta.getScheduleWorkerGroupName());
        }
        return this.scheduleMapper.insert((Object)scheduleObj);
    }

    public void importSubProcess(User loginUser, Project targetProject, JSONArray jsonArray, Map<Integer, Integer> subProcessIdMap) {
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject subParams;
            Integer subProcessId;
            ProcessDefinition subProcess;
            JSONObject taskNode = jsonArray.getJSONObject(i);
            String taskType = taskNode.getString("type");
            if (!this.checkTaskHasSubProcess(taskType) || null == (subProcess = this.processDefineMapper.queryByDefineId((subProcessId = (subParams = JSONUtils.parseObject((String)taskNode.getString("params"))).getInteger("processDefinitionId")).intValue()))) continue;
            String subProcessJson = subProcess.getProcessDefinitionJson();
            ProcessDefinition currentProjectSubProcess = this.processDefineMapper.queryByDefineName(targetProject.getId(), subProcess.getName());
            if (null != currentProjectSubProcess) continue;
            JSONArray subJsonArray = (JSONArray)JSONUtils.parseObject((String)subProcess.getProcessDefinitionJson()).get((Object)"tasks");
            List subProcessList = subJsonArray.stream().filter(item -> this.checkTaskHasSubProcess(JSONUtils.parseObject((String)item.toString()).getString("type"))).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(subProcessList)) {
                this.importSubProcess(loginUser, targetProject, subJsonArray, subProcessIdMap);
                if (!subProcessIdMap.isEmpty()) {
                    for (Map.Entry<Integer, Integer> entry : subProcessIdMap.entrySet()) {
                        String oldSubProcessId = "\"processDefinitionId\":" + entry.getKey();
                        String newSubProcessId = "\"processDefinitionId\":" + entry.getValue();
                        subProcessJson = subProcessJson.replaceAll(oldSubProcessId, newSubProcessId);
                    }
                    subProcessIdMap.clear();
                }
            }
            Date now = new Date();
            ProcessDefinition processDefine = new ProcessDefinition();
            processDefine.setName(subProcess.getName());
            processDefine.setVersion(subProcess.getVersion());
            processDefine.setReleaseState(subProcess.getReleaseState());
            processDefine.setProjectId(targetProject.getId());
            processDefine.setUserId(loginUser.getId());
            processDefine.setProcessDefinitionJson(subProcessJson);
            processDefine.setDescription(subProcess.getDescription());
            processDefine.setLocations(subProcess.getLocations());
            processDefine.setConnects(subProcess.getConnects());
            processDefine.setTimeout(subProcess.getTimeout());
            processDefine.setTenantId(subProcess.getTenantId());
            processDefine.setGlobalParams(subProcess.getGlobalParams());
            processDefine.setCreateTime(now);
            processDefine.setUpdateTime(now);
            processDefine.setFlag(subProcess.getFlag());
            processDefine.setReceivers(subProcess.getReceivers());
            processDefine.setReceiversCc(subProcess.getReceiversCc());
            this.processDefineMapper.insert((Object)processDefine);
            logger.info("create sub process, project: {}, process name: {}", (Object)targetProject.getName(), (Object)processDefine.getName());
            ProcessDefinition newSubProcessDefine = this.processDefineMapper.queryByDefineName(processDefine.getProjectId(), processDefine.getName());
            if (null == newSubProcessDefine) continue;
            subProcessIdMap.put(subProcessId, newSubProcessDefine.getId());
            subParams.put("processDefinitionId", (Object)newSubProcessDefine.getId());
            taskNode.put("params", (Object)subParams);
        }
    }

    public Map<String, Object> checkProcessNodeList(ProcessData processData, String processDefinitionJson) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        try {
            if (processData == null) {
                logger.error("process data is null");
                this.putMsg(result, Status.DATA_IS_NOT_VALID, processDefinitionJson);
                return result;
            }
            List taskNodes = processData.getTasks();
            if (taskNodes == null) {
                logger.error("process node info is empty");
                this.putMsg(result, Status.DATA_IS_NULL, processDefinitionJson);
                return result;
            }
            if (this.graphHasCycle(taskNodes)) {
                logger.error("process DAG has cycle");
                this.putMsg(result, Status.PROCESS_NODE_HAS_CYCLE, new Object[0]);
                return result;
            }
            for (TaskNode taskNode : taskNodes) {
                if (!CheckUtils.checkTaskNodeParameters(taskNode.getParams(), taskNode.getType())) {
                    logger.error("task node {} parameter invalid", (Object)taskNode.getName());
                    this.putMsg(result, Status.PROCESS_NODE_S_PARAMETER_INVALID, taskNode.getName());
                    return result;
                }
                CheckUtils.checkOtherParams(taskNode.getExtras());
            }
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        catch (Exception e) {
            result.put("status", (Object)Status.REQUEST_PARAMS_NOT_VALID_ERROR);
            result.put("msg", e.getMessage());
        }
        return result;
    }

    public Map<String, Object> getTaskNodeListByDefinitionId(Integer defineId) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ProcessDefinition processDefinition = (ProcessDefinition)this.processDefineMapper.selectById((Serializable)defineId);
        if (processDefinition == null) {
            logger.info("process define not exists");
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, defineId);
            return result;
        }
        String processDefinitionJson = processDefinition.getProcessDefinitionJson();
        ProcessData processData = (ProcessData)JSONUtils.parseObject((String)processDefinitionJson, ProcessData.class);
        if (null == processData) {
            logger.error("process data is null");
            this.putMsg(result, Status.DATA_IS_NOT_VALID, processDefinitionJson);
            return result;
        }
        List taskNodeList = processData.getTasks() == null ? new ArrayList() : processData.getTasks();
        result.put("data", taskNodeList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> getTaskNodeListByDefinitionIdList(String defineIdList) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap taskNodeMap = new HashMap();
        String[] idList = defineIdList.split(",");
        ArrayList<Integer> idIntList = new ArrayList<Integer>();
        for (String definitionId : idList) {
            idIntList.add(Integer.parseInt(definitionId));
        }
        Integer[] idArray = idIntList.toArray(new Integer[idIntList.size()]);
        List processDefinitionList = this.processDefineMapper.queryDefinitionListByIdList(idArray);
        if (CollectionUtils.isEmpty((Collection)processDefinitionList)) {
            logger.info("process definition not exists");
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, defineIdList);
            return result;
        }
        for (ProcessDefinition processDefinition : processDefinitionList) {
            String processDefinitionJson = processDefinition.getProcessDefinitionJson();
            ProcessData processData = (ProcessData)JSONUtils.parseObject((String)processDefinitionJson, ProcessData.class);
            List taskNodeList = processData.getTasks() == null ? new ArrayList() : processData.getTasks();
            taskNodeMap.put(processDefinition.getId(), taskNodeList);
        }
        result.put("data", taskNodeMap);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> queryProcessDefinitionAllByProjectId(Integer projectId) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        List resourceList = this.processDefineMapper.queryAllDefinitionList(projectId.intValue());
        result.put("data", resourceList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> viewTree(Integer processId, Integer limit) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ProcessDefinition processDefinition = (ProcessDefinition)this.processDefineMapper.selectById((Serializable)processId);
        if (null == processDefinition) {
            logger.info("process define not exists");
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, processDefinition);
            return result;
        }
        DAG<String, TaskNode, TaskNodeRelation> dag = this.genDagGraph(processDefinition);
        ConcurrentHashMap<String, ArrayList<Object>> runningNodeMap = new ConcurrentHashMap<String, ArrayList<Object>>();
        ConcurrentHashMap<String, ArrayList<TreeViewDto>> waitingRunningNodeMap = new ConcurrentHashMap<String, ArrayList<TreeViewDto>>();
        List processInstanceList = this.processInstanceMapper.queryByProcessDefineId(processId.intValue(), limit.intValue());
        for (ProcessInstance processInstance : processInstanceList) {
            processInstance.setDuration(Long.valueOf(DateUtils.differSec((Date)processInstance.getStartTime(), (Date)processInstance.getEndTime())));
        }
        if (limit > processInstanceList.size()) {
            limit = processInstanceList.size();
        }
        TreeViewDto parentTreeViewDto = new TreeViewDto();
        parentTreeViewDto.setName("DAG");
        parentTreeViewDto.setType("");
        for (int i = limit - 1; i >= 0; --i) {
            ProcessInstance processInstance = (ProcessInstance)processInstanceList.get(i);
            Date endTime = processInstance.getEndTime() == null ? new Date() : processInstance.getEndTime();
            parentTreeViewDto.getInstances().add(new Instance(processInstance.getId(), processInstance.getName(), "", processInstance.getState().toString(), processInstance.getStartTime(), endTime, processInstance.getHost(), DateUtils.format2Readable((long)(endTime.getTime() - processInstance.getStartTime().getTime()))));
        }
        List parentTreeViewDtoList = new ArrayList<TreeViewDto>();
        parentTreeViewDtoList.add(parentTreeViewDto);
        for (String startNode : dag.getBeginNode()) {
            runningNodeMap.put(startNode, (ArrayList<Object>)parentTreeViewDtoList);
        }
        while (Stopper.isRunning()) {
            Set postNodeList = null;
            for (Map.Entry en : runningNodeMap.entrySet()) {
                String nodeName = (String)en.getKey();
                parentTreeViewDtoList = (List)en.getValue();
                TreeViewDto treeViewDto = new TreeViewDto();
                treeViewDto.setName(nodeName);
                TaskNode taskNode = (TaskNode)dag.getNode((Object)nodeName);
                treeViewDto.setType(taskNode.getType());
                for (int i = limit - 1; i >= 0; --i) {
                    ProcessInstance processInstance = (ProcessInstance)processInstanceList.get(i);
                    TaskInstance taskInstance = this.taskInstanceMapper.queryByInstanceIdAndName(processInstance.getId(), nodeName);
                    if (taskInstance == null) {
                        treeViewDto.getInstances().add(new Instance(-1, "not running", "null"));
                        continue;
                    }
                    Date startTime = taskInstance.getStartTime() == null ? new Date() : taskInstance.getStartTime();
                    Date endTime = taskInstance.getEndTime() == null ? new Date() : taskInstance.getEndTime();
                    int subProcessId = 0;
                    if (taskInstance.getTaskType().equals(TaskType.SUB_PROCESS.name())) {
                        String taskJson = taskInstance.getTaskJson();
                        taskNode = (TaskNode)JSON.parseObject((String)taskJson, TaskNode.class);
                        subProcessId = Integer.parseInt(JSON.parseObject((String)taskNode.getParams()).getString("processDefinitionId"));
                    }
                    treeViewDto.getInstances().add(new Instance(taskInstance.getId(), taskInstance.getName(), taskInstance.getTaskType(), taskInstance.getState().toString(), taskInstance.getStartTime(), taskInstance.getEndTime(), taskInstance.getHost(), DateUtils.format2Readable((long)(endTime.getTime() - startTime.getTime())), subProcessId));
                }
                for (TreeViewDto pTreeViewDto : parentTreeViewDtoList) {
                    pTreeViewDto.getChildren().add(treeViewDto);
                }
                postNodeList = dag.getSubsequentNodes((Object)nodeName);
                if (CollectionUtils.isNotEmpty((Collection)postNodeList)) {
                    for (String nextNodeName : postNodeList) {
                        ArrayList<TreeViewDto> treeViewDtoList = (ArrayList<TreeViewDto>)waitingRunningNodeMap.get(nextNodeName);
                        if (CollectionUtils.isNotEmpty((Collection)treeViewDtoList)) {
                            treeViewDtoList.add(treeViewDto);
                            waitingRunningNodeMap.put(nextNodeName, treeViewDtoList);
                            continue;
                        }
                        treeViewDtoList = new ArrayList<TreeViewDto>();
                        treeViewDtoList.add(treeViewDto);
                        waitingRunningNodeMap.put(nextNodeName, treeViewDtoList);
                    }
                }
                runningNodeMap.remove(nodeName);
            }
            if (waitingRunningNodeMap == null || waitingRunningNodeMap.size() == 0) break;
            runningNodeMap.putAll(waitingRunningNodeMap);
            waitingRunningNodeMap.clear();
        }
        result.put("data", parentTreeViewDto);
        result.put("status", (Object)Status.SUCCESS);
        result.put("msg", Status.SUCCESS.getMsg());
        return result;
    }

    private DAG<String, TaskNode, TaskNodeRelation> genDagGraph(ProcessDefinition processDefinition) throws Exception {
        String processDefinitionJson = processDefinition.getProcessDefinitionJson();
        ProcessData processData = (ProcessData)JSONUtils.parseObject((String)processDefinitionJson, ProcessData.class);
        if (null != processData) {
            List taskNodeList = processData.getTasks();
            processDefinition.setGlobalParamList(processData.getGlobalParams());
            ProcessDag processDag = DagHelper.getProcessDag((List)taskNodeList);
            return DagHelper.buildDagGraph((ProcessDag)processDag);
        }
        return new DAG();
    }

    private boolean graphHasCycle(List<TaskNode> taskNodeResponseList) {
        DAG graph = new DAG();
        for (TaskNode taskNodeResponse : taskNodeResponseList) {
            graph.addNode((Object)taskNodeResponse.getName(), (Object)taskNodeResponse);
        }
        for (TaskNode taskNodeResponse : taskNodeResponseList) {
            taskNodeResponse.getPreTasks();
            List preTasks = JSONUtils.toList((String)taskNodeResponse.getPreTasks(), String.class);
            if (!CollectionUtils.isNotEmpty((Collection)preTasks)) continue;
            for (String preTask : preTasks) {
                if (graph.addEdge((Object)preTask, (Object)taskNodeResponse.getName())) continue;
                return true;
            }
        }
        return graph.hasCycle();
    }

    private String recursionProcessDefinitionName(Integer projectId, String processDefinitionName, int num) {
        ProcessDefinition processDefinition = this.processDefineMapper.queryByDefineName(projectId.intValue(), processDefinitionName);
        if (processDefinition != null) {
            if (num > 1) {
                String str = processDefinitionName.substring(0, processDefinitionName.length() - 3);
                processDefinitionName = str + "(" + num + ")";
            } else {
                processDefinitionName = processDefinition.getName() + "(" + num + ")";
            }
        } else {
            return processDefinitionName;
        }
        return this.recursionProcessDefinitionName(projectId, processDefinitionName, num + 1);
    }
}

