/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.LoggerService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"LOGGER_TAG"}, position=13)
@RestController
@RequestMapping(value={"/log"})
public class LoggerController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(LoggerController.class);
    @Autowired
    private LoggerService loggerService;

    @ApiOperation(value="queryLog", notes="QUERY_TASK_INSTANCE_LOG_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskInstanceId", value="TASK_ID", dataType="Int", example="100"), @ApiImplicitParam(name="skipLineNum", value="SKIP_LINE_NUM", dataType="Int", example="100"), @ApiImplicitParam(name="limit", value="LIMIT", dataType="Int", example="100")})
    @GetMapping(value={"/detail"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_TASK_INSTANCE_LOG_ERROR)
    public Result queryLog(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="taskInstanceId") int taskInstanceId, @RequestParam(value="skipLineNum") int skipNum, @RequestParam(value="limit") int limit) {
        logger.info("login user {}, view {} task instance log ,skipLineNum {} , limit {}", new Object[]{loginUser.getUserName(), taskInstanceId, skipNum, limit});
        return this.loggerService.queryLog(taskInstanceId, skipNum, limit);
    }

    @ApiOperation(value="downloadTaskLog", notes="DOWNLOAD_TASK_INSTANCE_LOG_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskInstanceId", value="TASK_ID", dataType="Int", example="100")})
    @GetMapping(value={"/download-log"})
    @ResponseBody
    @ApiException(value=Status.DOWNLOAD_TASK_INSTANCE_LOG_FILE_ERROR)
    public ResponseEntity downloadTaskLog(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="taskInstanceId") int taskInstanceId) {
        byte[] logBytes = this.loggerService.getLogBytes(taskInstanceId);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"" + System.currentTimeMillis() + ".log\""})).body((Object)logBytes);
    }
}

