/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.security.Authenticator;
import org.apache.dolphinscheduler.api.service.SessionService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.dao.entity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"LOGIN_TAG"}, position=1)
@RestController
@RequestMapping(value={""})
public class LoginController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(LoginController.class);
    @Autowired
    private SessionService sessionService;
    @Autowired
    private Authenticator authenticator;

    @ApiOperation(value="login", notes="LOGIN_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userName", value="USER_NAME", required=true, dataType="String"), @ApiImplicitParam(name="userPassword", value="USER_PASSWORD", required=true, dataType="String")})
    @PostMapping(value={"/login"})
    @ApiException(value=Status.USER_LOGIN_FAILURE)
    public Result login(@RequestParam(value="userName") String userName, @RequestParam(value="userPassword") String userPassword, HttpServletRequest request, HttpServletResponse response) {
        logger.info("login user name: {} ", (Object)userName);
        if (StringUtils.isEmpty((CharSequence)userName)) {
            return this.error(Status.USER_NAME_NULL.getCode(), Status.USER_NAME_NULL.getMsg());
        }
        String ip = LoginController.getClientIpAddress(request);
        if (StringUtils.isEmpty((CharSequence)ip)) {
            return this.error(Status.IP_IS_EMPTY.getCode(), Status.IP_IS_EMPTY.getMsg());
        }
        Result<Map<String, String>> result = this.authenticator.authenticate(userName, userPassword, ip);
        if (result.getCode().intValue() != Status.SUCCESS.getCode()) {
            return result;
        }
        response.setStatus(200);
        Map<String, String> cookieMap = result.getData();
        for (Map.Entry<String, String> cookieEntry : cookieMap.entrySet()) {
            Cookie cookie = new Cookie(cookieEntry.getKey(), cookieEntry.getValue());
            cookie.setHttpOnly(true);
            response.addCookie(cookie);
        }
        return result;
    }

    @ApiOperation(value="signOut", notes="SIGNOUT_NOTES")
    @PostMapping(value={"/signOut"})
    @ApiException(value=Status.SIGN_OUT_ERROR)
    public Result signOut(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, HttpServletRequest request) {
        logger.info("login user:{} sign out", (Object)loginUser.getUserName());
        String ip = LoginController.getClientIpAddress(request);
        this.sessionService.signOut(ip, loginUser);
        request.removeAttribute("session.user");
        return this.success();
    }
}

