/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.Map;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.SchedulerService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.FailureStrategy;
import org.apache.dolphinscheduler.common.enums.Priority;
import org.apache.dolphinscheduler.common.enums.ReleaseState;
import org.apache.dolphinscheduler.common.enums.WarningType;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.dao.entity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"SCHEDULER_TAG"}, position=13)
@RestController
@RequestMapping(value={"/projects/{projectName}/schedule"})
public class SchedulerController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(SchedulerController.class);
    public static final String DEFAULT_WARNING_TYPE = "NONE";
    public static final String DEFAULT_NOTIFY_GROUP_ID = "1";
    public static final String DEFAULT_FAILURE_POLICY = "CONTINUE";
    @Autowired
    private SchedulerService schedulerService;

    @ApiOperation(value="createSchedule", notes="CREATE_SCHEDULE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processDefinitionId", value="PROCESS_DEFINITION_ID", required=true, dataType="Int", example="100"), @ApiImplicitParam(name="schedule", value="SCHEDULE", dataType="String", example="{'startTime':'2019-06-10 00:00:00','endTime':'2019-06-13 00:00:00','crontab':'0 0 3/6 * * ? *'}"), @ApiImplicitParam(name="warningType", value="WARNING_TYPE", type="WarningType"), @ApiImplicitParam(name="warningGroupId", value="WARNING_GROUP_ID", dataType="Int", example="100"), @ApiImplicitParam(name="failureStrategy", value="FAILURE_STRATEGY", type="FailureStrategy"), @ApiImplicitParam(name="receivers", value="RECEIVERS", type="String"), @ApiImplicitParam(name="receiversCc", value="RECEIVERS_CC", type="String"), @ApiImplicitParam(name="workerGroupId", value="WORKER_GROUP_ID", dataType="Int", example="100"), @ApiImplicitParam(name="processInstancePriority", value="PROCESS_INSTANCE_PRIORITY", type="Priority")})
    @PostMapping(value={"/create"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_SCHEDULE_ERROR)
    public Result createSchedule(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectName", value="PROJECT_NAME", required=true) @PathVariable String projectName, @RequestParam(value="processDefinitionId") Integer processDefinitionId, @RequestParam(value="schedule") String schedule, @RequestParam(value="warningType", required=false, defaultValue="NONE") WarningType warningType, @RequestParam(value="warningGroupId", required=false, defaultValue="1") int warningGroupId, @RequestParam(value="failureStrategy", required=false, defaultValue="CONTINUE") FailureStrategy failureStrategy, @RequestParam(value="receivers", required=false) String receivers, @RequestParam(value="receiversCc", required=false) String receiversCc, @RequestParam(value="workerGroup", required=false, defaultValue="default") String workerGroup, @RequestParam(value="processInstancePriority", required=false) Priority processInstancePriority) throws IOException {
        logger.info("login user {}, project name: {}, process name: {}, create schedule: {}, warning type: {}, warning group id: {},failure policy: {},receivers : {},receiversCc : {},processInstancePriority : {}, workGroupId:{}", new Object[]{loginUser.getUserName(), projectName, processDefinitionId, schedule, warningType, warningGroupId, failureStrategy, receivers, receiversCc, processInstancePriority, workerGroup});
        Map<String, Object> result = this.schedulerService.insertSchedule(loginUser, projectName, processDefinitionId, schedule, warningType, warningGroupId, failureStrategy, receivers, receiversCc, processInstancePriority, workerGroup);
        return this.returnDataList(result);
    }

    @ApiOperation(value="updateSchedule", notes="UPDATE_SCHEDULE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="SCHEDULE_ID", required=true, dataType="Int", example="100"), @ApiImplicitParam(name="schedule", value="SCHEDULE", dataType="String", example="{'startTime':'2019-06-10 00:00:00','endTime':'2019-06-13 00:00:00','crontab':'0 0 3/6 * * ? *'}"), @ApiImplicitParam(name="warningType", value="WARNING_TYPE", type="WarningType"), @ApiImplicitParam(name="warningGroupId", value="WARNING_GROUP_ID", dataType="Int", example="100"), @ApiImplicitParam(name="failureStrategy", value="FAILURE_STRATEGY", type="FailureStrategy"), @ApiImplicitParam(name="receivers", value="RECEIVERS", type="String"), @ApiImplicitParam(name="receiversCc", value="RECEIVERS_CC", type="String"), @ApiImplicitParam(name="workerGroupId", value="WORKER_GROUP_ID", dataType="Int", example="100"), @ApiImplicitParam(name="processInstancePriority", value="PROCESS_INSTANCE_PRIORITY", type="Priority")})
    @PostMapping(value={"/update"})
    @ApiException(value=Status.UPDATE_SCHEDULE_ERROR)
    public Result updateSchedule(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectName", value="PROJECT_NAME", required=true) @PathVariable String projectName, @RequestParam(value="id") Integer id, @RequestParam(value="schedule") String schedule, @RequestParam(value="warningType", required=false, defaultValue="NONE") WarningType warningType, @RequestParam(value="warningGroupId", required=false) int warningGroupId, @RequestParam(value="failureStrategy", required=false, defaultValue="END") FailureStrategy failureStrategy, @RequestParam(value="receivers", required=false) String receivers, @RequestParam(value="receiversCc", required=false) String receiversCc, @RequestParam(value="workerGroup", required=false, defaultValue="default") String workerGroup, @RequestParam(value="processInstancePriority", required=false) Priority processInstancePriority) throws IOException {
        logger.info("login user {}, project name: {},id: {}, updateProcessInstance schedule: {}, notify type: {}, notify mails: {}, failure policy: {},receivers : {},receiversCc : {},processInstancePriority : {},workerGroupId:{}", new Object[]{loginUser.getUserName(), projectName, id, schedule, warningType, warningGroupId, failureStrategy, receivers, receiversCc, processInstancePriority, workerGroup});
        Map<String, Object> result = this.schedulerService.updateSchedule(loginUser, projectName, id, schedule, warningType, warningGroupId, failureStrategy, receivers, receiversCc, null, processInstancePriority, workerGroup);
        return this.returnDataList(result);
    }

    @ApiOperation(value="online", notes="ONLINE_SCHEDULE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="SCHEDULE_ID", required=true, dataType="Int", example="100")})
    @PostMapping(value={"/online"})
    @ApiException(value=Status.PUBLISH_SCHEDULE_ONLINE_ERROR)
    public Result online(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectName", value="PROJECT_NAME", required=true) @PathVariable(value="projectName") String projectName, @RequestParam(value="id") Integer id) {
        logger.info("login user {}, schedule setScheduleState, project name: {}, id: {}", new Object[]{loginUser.getUserName(), projectName, id});
        Map<String, Object> result = this.schedulerService.setScheduleState(loginUser, projectName, id, ReleaseState.ONLINE);
        return this.returnDataList(result);
    }

    @ApiOperation(value="offline", notes="OFFLINE_SCHEDULE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="SCHEDULE_ID", required=true, dataType="Int", example="100")})
    @PostMapping(value={"/offline"})
    @ApiException(value=Status.OFFLINE_SCHEDULE_ERROR)
    public Result offline(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectName", value="PROJECT_NAME", required=true) @PathVariable(value="projectName") String projectName, @RequestParam(value="id") Integer id) {
        logger.info("login user {}, schedule offline, project name: {}, process definition id: {}", new Object[]{loginUser.getUserName(), projectName, id});
        Map<String, Object> result = this.schedulerService.setScheduleState(loginUser, projectName, id, ReleaseState.OFFLINE);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryScheduleListPaging", notes="QUERY_SCHEDULE_LIST_PAGING_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processDefinitionId", value="PROCESS_DEFINITION_ID", required=true, dataType="Int", example="100"), @ApiImplicitParam(name="searchVal", value="SEARCH_VAL", type="String"), @ApiImplicitParam(name="pageNo", value="PAGE_NO", dataType="Int", example="100"), @ApiImplicitParam(name="pageSize", value="PAGE_SIZE", dataType="Int", example="100")})
    @GetMapping(value={"/list-paging"})
    @ApiException(value=Status.QUERY_SCHEDULE_LIST_PAGING_ERROR)
    public Result queryScheduleListPaging(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectName", value="PROJECT_NAME", required=true) @PathVariable String projectName, @RequestParam Integer processDefinitionId, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize) {
        logger.info("login user {}, query schedule, project name: {}, process definition id: {}", new Object[]{loginUser.getUserName(), projectName, processDefinitionId});
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        Map<String, Object> result = this.schedulerService.querySchedule(loginUser, projectName, processDefinitionId, searchVal, pageNo, pageSize);
        return this.returnDataListPaging(result);
    }

    @ApiOperation(value="deleteScheduleById", notes="OFFLINE_SCHEDULE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="scheduleId", value="SCHEDULE_ID", required=true, dataType="Int", example="100")})
    @GetMapping(value={"/delete"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_SCHEDULE_CRON_BY_ID_ERROR)
    public Result deleteScheduleById(@RequestAttribute(value="session.user") User loginUser, @PathVariable String projectName, @RequestParam(value="scheduleId") Integer scheduleId) {
        logger.info("delete schedule by id, login user:{}, project name:{}, schedule id:{}", new Object[]{loginUser.getUserName(), projectName, scheduleId});
        Map<String, Object> result = this.schedulerService.deleteScheduleById(loginUser, projectName, scheduleId);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryScheduleList", notes="QUERY_SCHEDULE_LIST_NOTES")
    @PostMapping(value={"/list"})
    @ApiException(value=Status.QUERY_SCHEDULE_LIST_ERROR)
    public Result queryScheduleList(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectName", value="PROJECT_NAME", required=true) @PathVariable String projectName) {
        logger.info("login user {}, query schedule list, project name: {}", (Object)loginUser.getUserName(), (Object)projectName);
        Map<String, Object> result = this.schedulerService.queryScheduleList(loginUser, projectName);
        return this.returnDataList(result);
    }

    @ApiOperation(value="previewSchedule", notes="PREVIEW_SCHEDULE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="schedule", value="SCHEDULE", dataType="String", example="{'startTime':'2019-06-10 00:00:00','endTime':'2019-06-13 00:00:00','crontab':'0 0 3/6 * * ? *'}")})
    @PostMapping(value={"/preview"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.PREVIEW_SCHEDULE_ERROR)
    public Result previewSchedule(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectName", value="PROJECT_NAME", required=true) @PathVariable String projectName, @RequestParam(value="schedule") String schedule) {
        logger.info("login user {}, project name: {}, preview schedule: {}", new Object[]{loginUser.getUserName(), projectName, schedule});
        Map<String, Object> result = this.schedulerService.previewSchedule(loginUser, projectName, schedule);
        return this.returnDataList(result);
    }
}

