/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.TenantService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.dao.entity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"TENANT_TAG"}, position=1)
@RestController
@RequestMapping(value={"/tenant"})
public class TenantController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(TenantController.class);
    @Autowired
    private TenantService tenantService;

    @ApiOperation(value="createTenant", notes="CREATE_TENANT_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tenantCode", value="TENANT_CODE", required=true, dataType="String"), @ApiImplicitParam(name="tenantName", value="TENANT_NAME", required=true, dataType="String"), @ApiImplicitParam(name="queueId", value="QUEUE_ID", required=true, dataType="Int", example="100"), @ApiImplicitParam(name="description", value="TENANT_DESC", dataType="String")})
    @PostMapping(value={"/create"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_TENANT_ERROR)
    public Result createTenant(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="tenantCode") String tenantCode, @RequestParam(value="tenantName") String tenantName, @RequestParam(value="queueId") int queueId, @RequestParam(value="description", required=false) String description) throws Exception {
        logger.info("login user {}, create tenant, tenantCode: {}, tenantName: {}, queueId: {}, desc: {}", new Object[]{loginUser.getUserName(), tenantCode, tenantName, queueId, description});
        Map<String, Object> result = this.tenantService.createTenant(loginUser, tenantCode, tenantName, queueId, description);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryTenantlistPaging", notes="QUERY_TENANT_LIST_PAGING_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="searchVal", value="SEARCH_VAL", dataType="String"), @ApiImplicitParam(name="pageNo", value="PAGE_NO", dataType="Int", example="1"), @ApiImplicitParam(name="pageSize", value="PAGE_SIZE", dataType="Int", example="20")})
    @GetMapping(value={"/list-paging"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_TENANT_LIST_PAGING_ERROR)
    public Result queryTenantlistPaging(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="pageSize") Integer pageSize) {
        logger.info("login user {}, list paging, pageNo: {}, searchVal: {}, pageSize: {}", new Object[]{loginUser.getUserName(), pageNo, searchVal, pageSize});
        Map<String, Object> result = this.checkPageParams(pageNo, pageSize);
        if (result.get("status") != Status.SUCCESS) {
            return this.returnDataListPaging(result);
        }
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        result = this.tenantService.queryTenantList(loginUser, searchVal, pageNo, pageSize);
        return this.returnDataListPaging(result);
    }

    @ApiOperation(value="queryTenantlist", notes="QUERY_TENANT_LIST_NOTES")
    @GetMapping(value={"/list"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_TENANT_LIST_ERROR)
    public Result queryTenantlist(@ApiIgnore @RequestAttribute(value="session.user") User loginUser) {
        logger.info("login user {}, query tenant list", (Object)loginUser.getUserName());
        Map<String, Object> result = this.tenantService.queryTenantList(loginUser);
        return this.returnDataList(result);
    }

    @ApiOperation(value="updateTenant", notes="UPDATE_TENANT_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ID", value="TENANT_ID", required=true, dataType="Int", example="100"), @ApiImplicitParam(name="tenantCode", value="TENANT_CODE", required=true, dataType="String"), @ApiImplicitParam(name="tenantName", value="TENANT_NAME", required=true, dataType="String"), @ApiImplicitParam(name="queueId", value="QUEUE_ID", required=true, dataType="Int", example="100"), @ApiImplicitParam(name="description", value="TENANT_DESC", type="String")})
    @PostMapping(value={"/update"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UPDATE_TENANT_ERROR)
    public Result updateTenant(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="id") int id, @RequestParam(value="tenantCode") String tenantCode, @RequestParam(value="tenantName") String tenantName, @RequestParam(value="queueId") int queueId, @RequestParam(value="description", required=false) String description) throws Exception {
        logger.info("login user {}, updateProcessInstance tenant, tenantCode: {}, tenantName: {}, queueId: {}, description: {}", new Object[]{loginUser.getUserName(), tenantCode, tenantName, queueId, description});
        Map<String, Object> result = this.tenantService.updateTenant(loginUser, id, tenantCode, tenantName, queueId, description);
        return this.returnDataList(result);
    }

    @ApiOperation(value="deleteTenantById", notes="DELETE_TENANT_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ID", value="TENANT_ID", required=true, dataType="Int", example="100")})
    @PostMapping(value={"/delete"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_TENANT_BY_ID_ERROR)
    public Result deleteTenantById(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="id") int id) throws Exception {
        logger.info("login user {}, delete tenant, tenantId: {},", (Object)loginUser.getUserName(), (Object)id);
        Map<String, Object> result = this.tenantService.deleteTenantById(loginUser, id);
        return this.returnDataList(result);
    }

    @ApiOperation(value="verifyTenantCode", notes="VERIFY_TENANT_CODE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tenantCode", value="TENANT_CODE", required=true, dataType="String")})
    @GetMapping(value={"/verify-tenant-code"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.VERIFY_TENANT_CODE_ERROR)
    public Result verifyTenantCode(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="tenantCode") String tenantCode) {
        logger.info("login user {}, verfiy tenant code: {}", (Object)loginUser.getUserName(), (Object)tenantCode);
        return this.tenantService.verifyTenantCode(tenantCode);
    }
}

