/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.BaseService;
import org.apache.dolphinscheduler.api.service.UserAlertGroupService;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.common.enums.AlertType;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.dao.entity.AlertGroup;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.entity.UserAlertGroup;
import org.apache.dolphinscheduler.dao.mapper.AlertGroupMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AlertGroupService
extends BaseService {
    private static final Logger logger = LoggerFactory.getLogger(AlertGroupService.class);
    @Autowired
    private AlertGroupMapper alertGroupMapper;
    @Autowired
    private UserAlertGroupService userAlertGroupService;

    public HashMap<String, Object> queryAlertgroup() {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        List alertGroups = this.alertGroupMapper.queryAllGroupList();
        result.put("data", alertGroups);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> listPaging(User loginUser, String searchVal, Integer pageNo, Integer pageSize) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        if (this.checkAdmin(loginUser, result)) {
            return result;
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage alertGroupIPage = this.alertGroupMapper.queryAlertGroupPage(page, searchVal);
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        pageInfo.setTotalCount((int)alertGroupIPage.getTotal());
        pageInfo.setLists(alertGroupIPage.getRecords());
        result.put("data", pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> createAlertgroup(User loginUser, String groupName, AlertType groupType, String desc) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        if (this.checkAdmin(loginUser, result)) {
            return result;
        }
        AlertGroup alertGroup = new AlertGroup();
        Date now = new Date();
        alertGroup.setGroupName(groupName);
        alertGroup.setGroupType(groupType);
        alertGroup.setDescription(desc);
        alertGroup.setCreateTime(now);
        alertGroup.setUpdateTime(now);
        int insert = this.alertGroupMapper.insert((Object)alertGroup);
        if (insert > 0) {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        } else {
            this.putMsg(result, Status.CREATE_ALERT_GROUP_ERROR, new Object[0]);
        }
        return result;
    }

    public Map<String, Object> updateAlertgroup(User loginUser, int id, String groupName, AlertType groupType, String desc) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        if (this.checkAdmin(loginUser, result)) {
            return result;
        }
        AlertGroup alertGroup = (AlertGroup)this.alertGroupMapper.selectById((Serializable)Integer.valueOf(id));
        if (alertGroup == null) {
            this.putMsg(result, Status.ALERT_GROUP_NOT_EXIST, new Object[0]);
            return result;
        }
        Date now = new Date();
        if (StringUtils.isNotEmpty((CharSequence)groupName)) {
            alertGroup.setGroupName(groupName);
        }
        if (groupType != null) {
            alertGroup.setGroupType(groupType);
        }
        alertGroup.setDescription(desc);
        alertGroup.setUpdateTime(now);
        this.alertGroupMapper.updateById((Object)alertGroup);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public Map<String, Object> delAlertgroupById(User loginUser, int id) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        result.put("status", false);
        if (this.checkAdmin(loginUser, result)) {
            return result;
        }
        AlertGroup alertGroup = (AlertGroup)this.alertGroupMapper.selectById((Serializable)Integer.valueOf(id));
        if (alertGroup == null) {
            this.putMsg(result, Status.ALERT_GROUP_NOT_EXIST, new Object[0]);
            return result;
        }
        this.userAlertGroupService.deleteByAlertGroupId(id);
        this.alertGroupMapper.deleteById((Serializable)Integer.valueOf(id));
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> grantUser(User loginUser, int alertgroupId, String userIds) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        result.put("status", false);
        if (this.checkAdmin(loginUser, result)) {
            return result;
        }
        this.userAlertGroupService.deleteByAlertGroupId(alertgroupId);
        if (StringUtils.isEmpty((CharSequence)userIds)) {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
            return result;
        }
        String[] userIdsArr = userIds.split(",");
        Date now = new Date();
        ArrayList<UserAlertGroup> alertGroups = new ArrayList<UserAlertGroup>(userIds.length());
        for (String userId : userIdsArr) {
            UserAlertGroup userAlertGroup = new UserAlertGroup();
            userAlertGroup.setAlertgroupId(alertgroupId);
            userAlertGroup.setUserId(Integer.parseInt(userId));
            userAlertGroup.setCreateTime(now);
            userAlertGroup.setUpdateTime(now);
            alertGroups.add(userAlertGroup);
        }
        if (CollectionUtils.isNotEmpty(alertGroups)) {
            this.userAlertGroupService.saveBatch(alertGroups);
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public boolean existGroupName(String groupName) {
        List alertGroup = this.alertGroupMapper.queryByGroupName(groupName);
        return CollectionUtils.isNotEmpty((Collection)alertGroup);
    }
}

