/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dolphinscheduler.api.dto.ScheduleParam;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.BaseService;
import org.apache.dolphinscheduler.api.service.ExecutorService;
import org.apache.dolphinscheduler.api.service.MonitorService;
import org.apache.dolphinscheduler.api.service.ProjectService;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.common.enums.FailureStrategy;
import org.apache.dolphinscheduler.common.enums.Priority;
import org.apache.dolphinscheduler.common.enums.ReleaseState;
import org.apache.dolphinscheduler.common.enums.UserType;
import org.apache.dolphinscheduler.common.enums.WarningType;
import org.apache.dolphinscheduler.common.model.Server;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.Schedule;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.ScheduleMapper;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.apache.dolphinscheduler.service.quartz.ProcessScheduleJob;
import org.apache.dolphinscheduler.service.quartz.QuartzExecutors;
import org.apache.dolphinscheduler.service.quartz.cron.CronUtils;
import org.quartz.CronExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SchedulerService
extends BaseService {
    private static final Logger logger = LoggerFactory.getLogger(SchedulerService.class);
    @Autowired
    private ProjectService projectService;
    @Autowired
    private ExecutorService executorService;
    @Autowired
    private MonitorService monitorService;
    @Autowired
    private ProcessService processService;
    @Autowired
    private ScheduleMapper scheduleMapper;
    @Autowired
    private ProjectMapper projectMapper;
    @Autowired
    private ProcessDefinitionMapper processDefinitionMapper;

    @Transactional(rollbackFor={Exception.class})
    public Map<String, Object> insertSchedule(User loginUser, String projectName, Integer processDefineId, String schedule, WarningType warningType, int warningGroupId, FailureStrategy failureStrategy, String receivers, String receiversCc, Priority processInstancePriority, String workerGroup) throws IOException {
        Map<String, Object> result = new HashMap<String, Object>(5);
        Project project = this.projectMapper.queryByName(projectName);
        boolean hasProjectAndPerm = this.projectService.hasProjectAndPerm(loginUser, project, result);
        if (!hasProjectAndPerm) {
            return result;
        }
        ProcessDefinition processDefinition = this.processService.findProcessDefineById(processDefineId.intValue());
        result = this.executorService.checkProcessDefinitionValid(processDefinition, processDefineId);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        Schedule scheduleObj = new Schedule();
        Date now = new Date();
        scheduleObj.setProjectName(projectName);
        scheduleObj.setProcessDefinitionId(processDefinition.getId());
        scheduleObj.setProcessDefinitionName(processDefinition.getName());
        ScheduleParam scheduleParam = (ScheduleParam)JSONUtils.parseObject((String)schedule, ScheduleParam.class);
        if (DateUtils.differSec((Date)scheduleParam.getStartTime(), (Date)scheduleParam.getEndTime()) == 0L) {
            logger.warn("The start time must not be the same as the end");
            this.putMsg(result, Status.SCHEDULE_START_TIME_END_TIME_SAME, new Object[0]);
            return result;
        }
        scheduleObj.setStartTime(scheduleParam.getStartTime());
        scheduleObj.setEndTime(scheduleParam.getEndTime());
        if (!CronExpression.isValidExpression((String)scheduleParam.getCrontab())) {
            logger.error(scheduleParam.getCrontab() + " verify failure");
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, scheduleParam.getCrontab());
            return result;
        }
        scheduleObj.setCrontab(scheduleParam.getCrontab());
        scheduleObj.setWarningType(warningType);
        scheduleObj.setWarningGroupId(warningGroupId);
        scheduleObj.setFailureStrategy(failureStrategy);
        scheduleObj.setCreateTime(now);
        scheduleObj.setUpdateTime(now);
        scheduleObj.setUserId(loginUser.getId());
        scheduleObj.setUserName(loginUser.getUserName());
        scheduleObj.setReleaseState(ReleaseState.OFFLINE);
        scheduleObj.setProcessInstancePriority(processInstancePriority);
        scheduleObj.setWorkerGroup(workerGroup);
        this.scheduleMapper.insert((Object)scheduleObj);
        processDefinition.setReceivers(receivers);
        processDefinition.setReceiversCc(receiversCc);
        this.processDefinitionMapper.updateById((Object)processDefinition);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        result.put("scheduleId", scheduleObj.getId());
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public Map<String, Object> updateSchedule(User loginUser, String projectName, Integer id, String scheduleExpression, WarningType warningType, int warningGroupId, FailureStrategy failureStrategy, String receivers, String receiversCc, ReleaseState scheduleStatus, Priority processInstancePriority, String workerGroup) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        Project project = this.projectMapper.queryByName(projectName);
        boolean hasProjectAndPerm = this.projectService.hasProjectAndPerm(loginUser, project, result);
        if (!hasProjectAndPerm) {
            return result;
        }
        Schedule schedule = (Schedule)this.scheduleMapper.selectById((Serializable)id);
        if (schedule == null) {
            this.putMsg(result, Status.SCHEDULE_CRON_NOT_EXISTS, id);
            return result;
        }
        ProcessDefinition processDefinition = this.processService.findProcessDefineById(schedule.getProcessDefinitionId());
        if (processDefinition == null) {
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, schedule.getProcessDefinitionId());
            return result;
        }
        if (this.checkValid(result, schedule.getReleaseState() == ReleaseState.ONLINE, Status.SCHEDULE_CRON_ONLINE_FORBID_UPDATE)) {
            return result;
        }
        Date now = new Date();
        if (StringUtils.isNotEmpty((CharSequence)scheduleExpression)) {
            ScheduleParam scheduleParam = (ScheduleParam)JSONUtils.parseObject((String)scheduleExpression, ScheduleParam.class);
            if (DateUtils.differSec((Date)scheduleParam.getStartTime(), (Date)scheduleParam.getEndTime()) == 0L) {
                logger.warn("The start time must not be the same as the end");
                this.putMsg(result, Status.SCHEDULE_START_TIME_END_TIME_SAME, new Object[0]);
                return result;
            }
            schedule.setStartTime(scheduleParam.getStartTime());
            schedule.setEndTime(scheduleParam.getEndTime());
            if (!CronExpression.isValidExpression((String)scheduleParam.getCrontab())) {
                this.putMsg(result, Status.SCHEDULE_CRON_CHECK_FAILED, scheduleParam.getCrontab());
                return result;
            }
            schedule.setCrontab(scheduleParam.getCrontab());
        }
        if (warningType != null) {
            schedule.setWarningType(warningType);
        }
        schedule.setWarningGroupId(warningGroupId);
        if (failureStrategy != null) {
            schedule.setFailureStrategy(failureStrategy);
        }
        if (scheduleStatus != null) {
            schedule.setReleaseState(scheduleStatus);
        }
        schedule.setWorkerGroup(workerGroup);
        schedule.setUpdateTime(now);
        schedule.setProcessInstancePriority(processInstancePriority);
        this.scheduleMapper.updateById((Object)schedule);
        processDefinition.setReceivers(receivers);
        processDefinition.setReceiversCc(receiversCc);
        this.processDefinitionMapper.updateById((Object)processDefinition);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public Map<String, Object> setScheduleState(User loginUser, String projectName, Integer id, ReleaseState scheduleStatus) {
        List<Server> masterServers;
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        Project project = this.projectMapper.queryByName(projectName);
        boolean hasProjectAndPerm = this.projectService.hasProjectAndPerm(loginUser, project, result);
        if (!hasProjectAndPerm) {
            return result;
        }
        Schedule scheduleObj = (Schedule)this.scheduleMapper.selectById((Serializable)id);
        if (scheduleObj == null) {
            this.putMsg(result, Status.SCHEDULE_CRON_NOT_EXISTS, id);
            return result;
        }
        if (scheduleObj.getReleaseState() == scheduleStatus) {
            logger.info("schedule release is already {},needn't to change schedule id: {} from {} to {}", new Object[]{scheduleObj.getReleaseState(), scheduleObj.getId(), scheduleObj.getReleaseState(), scheduleStatus});
            this.putMsg(result, Status.SCHEDULE_CRON_REALEASE_NEED_NOT_CHANGE, scheduleStatus);
            return result;
        }
        ProcessDefinition processDefinition = this.processService.findProcessDefineById(scheduleObj.getProcessDefinitionId());
        if (processDefinition == null) {
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, scheduleObj.getProcessDefinitionId());
            return result;
        }
        if (scheduleStatus == ReleaseState.ONLINE) {
            List subProcessDefinitionList;
            if (processDefinition.getReleaseState() != ReleaseState.ONLINE) {
                ProcessDefinition definition = (ProcessDefinition)this.processDefinitionMapper.selectById((Serializable)Integer.valueOf(scheduleObj.getProcessDefinitionId()));
                logger.info("not release process definition id: {} , name : {}", (Object)processDefinition.getId(), (Object)processDefinition.getName());
                this.putMsg(result, Status.PROCESS_DEFINE_NOT_RELEASE, definition.getName());
                return result;
            }
            ArrayList subProcessDefineIds = new ArrayList();
            this.processService.recurseFindSubProcessId(scheduleObj.getProcessDefinitionId(), subProcessDefineIds);
            Integer[] idArray = subProcessDefineIds.toArray(new Integer[subProcessDefineIds.size()]);
            if (subProcessDefineIds.size() > 0 && (subProcessDefinitionList = this.processDefinitionMapper.queryDefinitionListByIdList(idArray)) != null && subProcessDefinitionList.size() > 0) {
                for (ProcessDefinition subProcessDefinition : subProcessDefinitionList) {
                    if (subProcessDefinition.getReleaseState() == ReleaseState.ONLINE) continue;
                    logger.info("not release process definition id: {} , name : {}", (Object)subProcessDefinition.getId(), (Object)subProcessDefinition.getName());
                    this.putMsg(result, Status.PROCESS_DEFINE_NOT_RELEASE, subProcessDefinition.getId());
                    return result;
                }
            }
        }
        if ((masterServers = this.monitorService.getServerListFromZK(true)).size() == 0) {
            this.putMsg(result, Status.MASTER_NOT_EXISTS, new Object[0]);
            return result;
        }
        scheduleObj.setReleaseState(scheduleStatus);
        this.scheduleMapper.updateById((Object)scheduleObj);
        try {
            switch (scheduleStatus) {
                case ONLINE: {
                    logger.info("Call master client set schedule online, project id: {}, flow id: {},host: {}", new Object[]{project.getId(), processDefinition.getId(), masterServers});
                    this.setSchedule(project.getId(), id);
                    break;
                }
                case OFFLINE: {
                    logger.info("Call master client set schedule offline, project id: {}, flow id: {},host: {}", new Object[]{project.getId(), processDefinition.getId(), masterServers});
                    SchedulerService.deleteSchedule(project.getId(), id);
                    break;
                }
                default: {
                    this.putMsg(result, Status.SCHEDULE_STATUS_UNKNOWN, scheduleStatus.toString());
                    return result;
                }
            }
        }
        catch (Exception e) {
            result.put("msg", scheduleStatus == ReleaseState.ONLINE ? "set online failure" : "set offline failure");
            throw new RuntimeException(result.get("msg").toString());
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> querySchedule(User loginUser, String projectName, Integer processDefineId, String searchVal, Integer pageNo, Integer pageSize) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Project project = this.projectMapper.queryByName(projectName);
        boolean hasProjectAndPerm = this.projectService.hasProjectAndPerm(loginUser, project, result);
        if (!hasProjectAndPerm) {
            return result;
        }
        ProcessDefinition processDefinition = this.processService.findProcessDefineById(processDefineId.intValue());
        if (processDefinition == null) {
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, processDefineId);
            return result;
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage scheduleIPage = this.scheduleMapper.queryByProcessDefineIdPaging((IPage)page, processDefineId.intValue(), searchVal);
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        pageInfo.setTotalCount((int)scheduleIPage.getTotal());
        pageInfo.setLists(scheduleIPage.getRecords());
        result.put("data", pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> queryScheduleList(User loginUser, String projectName) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        Project project = this.projectMapper.queryByName(projectName);
        boolean hasProjectAndPerm = this.projectService.hasProjectAndPerm(loginUser, project, result);
        if (!hasProjectAndPerm) {
            return result;
        }
        List schedules = this.scheduleMapper.querySchedulerListByProjectName(projectName);
        result.put("data", schedules);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public void setSchedule(int projectId, int scheduleId) throws RuntimeException {
        logger.info("set schedule, project id: {}, scheduleId: {}", (Object)projectId, (Object)scheduleId);
        Schedule schedule = this.processService.querySchedule(scheduleId);
        if (schedule == null) {
            logger.warn("process schedule info not exists");
            return;
        }
        Date startDate = schedule.getStartTime();
        Date endDate = schedule.getEndTime();
        String jobName = QuartzExecutors.buildJobName((int)scheduleId);
        String jobGroupName = QuartzExecutors.buildJobGroupName((int)projectId);
        Map dataMap = QuartzExecutors.buildDataMap((int)projectId, (int)scheduleId, (Schedule)schedule);
        QuartzExecutors.getInstance().addJob(ProcessScheduleJob.class, jobName, jobGroupName, startDate, endDate, schedule.getCrontab(), dataMap);
    }

    public static void deleteSchedule(int projectId, int scheduleId) throws RuntimeException {
        logger.info("delete schedules of project id:{}, schedule id:{}", (Object)projectId, (Object)scheduleId);
        String jobName = QuartzExecutors.buildJobName((int)scheduleId);
        String jobGroupName = QuartzExecutors.buildJobGroupName((int)projectId);
        if (!QuartzExecutors.getInstance().deleteJob(jobName, jobGroupName)) {
            logger.warn("set offline failure:projectId:{},scheduleId:{}", (Object)projectId, (Object)scheduleId);
            throw new RuntimeException(String.format("set offline failure", new Object[0]));
        }
    }

    private boolean checkValid(Map<String, Object> result, boolean bool, Status status) {
        if (bool) {
            this.putMsg(result, status, new Object[0]);
            return true;
        }
        return false;
    }

    public Map<String, Object> deleteScheduleById(User loginUser, String projectName, Integer scheduleId) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        Project project = this.projectMapper.queryByName(projectName);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectName);
        Status resultEnum = (Status)((Object)checkResult.get("status"));
        if (resultEnum != Status.SUCCESS) {
            return checkResult;
        }
        Schedule schedule = (Schedule)this.scheduleMapper.selectById((Serializable)scheduleId);
        if (schedule == null) {
            this.putMsg(result, Status.SCHEDULE_CRON_NOT_EXISTS, scheduleId);
            return result;
        }
        if (loginUser.getId() != schedule.getUserId() && loginUser.getUserType() != UserType.ADMIN_USER) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        if (schedule.getReleaseState() == ReleaseState.ONLINE) {
            this.putMsg(result, Status.SCHEDULE_CRON_STATE_ONLINE, schedule.getId());
            return result;
        }
        int delete = this.scheduleMapper.deleteById((Serializable)scheduleId);
        if (delete > 0) {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        } else {
            this.putMsg(result, Status.DELETE_SCHEDULE_CRON_BY_ID_ERROR, new Object[0]);
        }
        return result;
    }

    public Map<String, Object> previewSchedule(User loginUser, String projectName, String schedule) {
        CronExpression cronExpression;
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        Date now = new Date();
        ScheduleParam scheduleParam = (ScheduleParam)JSONUtils.parseObject((String)schedule, ScheduleParam.class);
        Date startTime = now.after(scheduleParam.getStartTime()) ? now : scheduleParam.getStartTime();
        Date endTime = scheduleParam.getEndTime();
        try {
            cronExpression = CronUtils.parse2CronExpression((String)scheduleParam.getCrontab());
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.putMsg(result, Status.PARSE_TO_CRON_EXPRESSION_ERROR, new Object[0]);
            return result;
        }
        List selfFireDateList = CronUtils.getSelfFireDateList((Date)startTime, (Date)endTime, (CronExpression)cronExpression, (int)5);
        result.put("data", selfFireDateList.stream().map(t -> DateUtils.dateToString((Date)t)));
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }
}

