/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.BaseService;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.UdfType;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.dao.entity.Resource;
import org.apache.dolphinscheduler.dao.entity.UdfFunc;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.ResourceMapper;
import org.apache.dolphinscheduler.dao.mapper.UDFUserMapper;
import org.apache.dolphinscheduler.dao.mapper.UdfFuncMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UdfFuncService
extends BaseService {
    private static final Logger logger = LoggerFactory.getLogger(UdfFuncService.class);
    @Autowired
    private ResourceMapper resourceMapper;
    @Autowired
    private UdfFuncMapper udfFuncMapper;
    @Autowired
    private UDFUserMapper udfUserMapper;

    public Result createUdfFunction(User loginUser, String funcName, String className, String argTypes, String database, String desc, UdfType type, int resourceId) {
        Result result = new Result();
        if (!PropertyUtils.getResUploadStartupState().booleanValue()) {
            logger.error("resource upload startup state: {}", (Object)PropertyUtils.getResUploadStartupState());
            this.putMsg(result, Status.HDFS_NOT_STARTUP, new Object[0]);
            return result;
        }
        if (this.checkUdfFuncNameExists(funcName)) {
            logger.error("udf func {} has exist, can't recreate", (Object)funcName);
            this.putMsg(result, Status.UDF_FUNCTION_EXISTS, new Object[0]);
            return result;
        }
        Resource resource = (Resource)this.resourceMapper.selectById((Serializable)Integer.valueOf(resourceId));
        if (resource == null) {
            logger.error("resourceId {} is not exist", (Object)resourceId);
            this.putMsg(result, Status.RESOURCE_NOT_EXIST, new Object[0]);
            return result;
        }
        UdfFunc udf = new UdfFunc();
        Date now = new Date();
        udf.setUserId(loginUser.getId());
        udf.setFuncName(funcName);
        udf.setClassName(className);
        if (StringUtils.isNotEmpty((CharSequence)argTypes)) {
            udf.setArgTypes(argTypes);
        }
        if (StringUtils.isNotEmpty((CharSequence)database)) {
            udf.setDatabase(database);
        }
        udf.setDescription(desc);
        udf.setResourceId(resourceId);
        udf.setResourceName(resource.getFullName());
        udf.setType(type);
        udf.setCreateTime(now);
        udf.setUpdateTime(now);
        this.udfFuncMapper.insert((Object)udf);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private boolean checkUdfFuncNameExists(String name) {
        List resource = this.udfFuncMapper.queryUdfByIdStr(null, name);
        return resource != null && resource.size() > 0;
    }

    public Map<String, Object> queryUdfFuncDetail(int id) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        UdfFunc udfFunc = (UdfFunc)this.udfFuncMapper.selectById((Serializable)Integer.valueOf(id));
        if (udfFunc == null) {
            this.putMsg(result, Status.RESOURCE_NOT_EXIST, new Object[0]);
            return result;
        }
        result.put("data", udfFunc);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> updateUdfFunc(int udfFuncId, String funcName, String className, String argTypes, String database, String desc, UdfType type, int resourceId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        UdfFunc udf = this.udfFuncMapper.selectUdfById(udfFuncId);
        if (udf == null) {
            result.put("status", (Object)Status.UDF_FUNCTION_NOT_EXIST);
            result.put("msg", Status.UDF_FUNCTION_NOT_EXIST.getMsg());
            return result;
        }
        if (!PropertyUtils.getResUploadStartupState().booleanValue()) {
            logger.error("resource upload startup state: {}", (Object)PropertyUtils.getResUploadStartupState());
            this.putMsg(result, Status.HDFS_NOT_STARTUP, new Object[0]);
            return result;
        }
        if (!funcName.equals(udf.getFuncName()) && this.checkUdfFuncNameExists(funcName)) {
            logger.error("UdfFunc {} has exist, can't create again.", (Object)funcName);
            result.put("status", (Object)Status.UDF_FUNCTION_EXISTS);
            result.put("msg", Status.UDF_FUNCTION_EXISTS.getMsg());
            return result;
        }
        Resource resource = (Resource)this.resourceMapper.selectById((Serializable)Integer.valueOf(resourceId));
        if (resource == null) {
            logger.error("resourceId {} is not exist", (Object)resourceId);
            result.put("status", (Object)Status.RESOURCE_NOT_EXIST);
            result.put("msg", Status.RESOURCE_NOT_EXIST.getMsg());
            return result;
        }
        Date now = new Date();
        udf.setFuncName(funcName);
        udf.setClassName(className);
        udf.setArgTypes(argTypes);
        if (StringUtils.isNotEmpty((CharSequence)database)) {
            udf.setDatabase(database);
        }
        udf.setDescription(desc);
        udf.setResourceId(resourceId);
        udf.setResourceName(resource.getFullName());
        udf.setType(type);
        udf.setUpdateTime(now);
        this.udfFuncMapper.updateById((Object)udf);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> queryUdfFuncListPaging(User loginUser, String searchVal, Integer pageNo, Integer pageSize) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        IPage<UdfFunc> udfFuncList = this.getUdfFuncsPage(loginUser, searchVal, pageSize, pageNo);
        pageInfo.setTotalCount((int)udfFuncList.getTotal());
        pageInfo.setLists(udfFuncList.getRecords());
        result.put("data", pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private IPage<UdfFunc> getUdfFuncsPage(User loginUser, String searchVal, Integer pageSize, int pageNo) {
        int userId = loginUser.getId();
        if (this.isAdmin(loginUser)) {
            userId = 0;
        }
        Page page = new Page((long)pageNo, (long)pageSize.intValue());
        return this.udfFuncMapper.queryUdfFuncPaging((IPage)page, userId, searchVal);
    }

    public Map<String, Object> queryResourceList(User loginUser, Integer type) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        List udfFuncList = this.udfFuncMapper.getUdfFuncByType(loginUser.getId(), type);
        result.put("data", udfFuncList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public Result delete(int id) {
        Result result = new Result();
        this.udfFuncMapper.deleteById((Serializable)Integer.valueOf(id));
        this.udfUserMapper.deleteByUdfFuncId(id);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Result verifyUdfFuncByName(String name) {
        Result result = new Result();
        if (this.checkUdfFuncNameExists(name)) {
            logger.error("UDF function name:{} has exist, can't create again.", (Object)name);
            this.putMsg(result, Status.UDF_FUNCTION_EXISTS, new Object[0]);
        } else {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }
}

