/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.BaseService;
import org.apache.dolphinscheduler.api.utils.ZookeeperMonitor;
import org.apache.dolphinscheduler.common.enums.ZKNodeType;
import org.apache.dolphinscheduler.common.model.Server;
import org.apache.dolphinscheduler.common.model.WorkerServerModel;
import org.apache.dolphinscheduler.common.utils.Preconditions;
import org.apache.dolphinscheduler.dao.MonitorDBDao;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.entity.ZookeeperRecord;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MonitorService
extends BaseService {
    @Autowired
    private ZookeeperMonitor zookeeperMonitor;
    @Autowired
    private MonitorDBDao monitorDBDao;

    public Map<String, Object> queryDatabaseState(User loginUser) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        List monitorRecordList = this.monitorDBDao.queryDatabaseState();
        result.put("data", monitorRecordList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> queryMaster(User loginUser) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        List<Server> masterServers = this.getServerListFromZK(true);
        result.put("data", masterServers);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> queryZookeeperState(User loginUser) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        List<ZookeeperRecord> zookeeperRecordList = this.zookeeperMonitor.zookeeperInfoList();
        result.put("data", zookeeperRecordList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> queryWorker(User loginUser) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        List workerServers = this.getServerListFromZK(false).stream().map(server -> {
            WorkerServerModel model = new WorkerServerModel();
            model.setId(server.getId());
            model.setHost(server.getHost());
            model.setPort(server.getPort());
            model.setZkDirectories((Set)Sets.newHashSet((Object[])new String[]{server.getZkDirectory()}));
            model.setResInfo(server.getResInfo());
            model.setCreateTime(server.getCreateTime());
            model.setLastHeartbeatTime(server.getLastHeartbeatTime());
            return model;
        }).collect(Collectors.toList());
        Map workerHostPortServerMapping = workerServers.stream().collect(Collectors.toMap(worker -> {
            String[] s = ((String)worker.getZkDirectories().iterator().next()).split("/");
            return s[s.length - 1];
        }, Function.identity(), (oldOne, newOne) -> {
            oldOne.getZkDirectories().addAll(newOne.getZkDirectories());
            return oldOne;
        }));
        result.put("data", workerHostPortServerMapping.values());
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public List<Server> getServerListFromZK(boolean isMaster) {
        Preconditions.checkNotNull((Object)((Object)this.zookeeperMonitor));
        ZKNodeType zkNodeType = isMaster ? ZKNodeType.MASTER : ZKNodeType.WORKER;
        return this.zookeeperMonitor.getServersList(zkNodeType);
    }
}

