/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.utils.exportprocess;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.dolphinscheduler.api.utils.exportprocess.ProcessAddTaskParam;
import org.apache.dolphinscheduler.api.utils.exportprocess.TaskNodeParamFactory;
import org.apache.dolphinscheduler.common.enums.TaskType;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DependentParam
implements ProcessAddTaskParam,
InitializingBean {
    @Autowired
    ProcessDefinitionMapper processDefineMapper;
    @Autowired
    ProjectMapper projectMapper;

    @Override
    public JSONObject addExportSpecialParam(JSONObject taskNode) {
        JSONObject dependentParameters = JSONUtils.parseObject((String)taskNode.getString("dependence"));
        if (null != dependentParameters) {
            JSONArray dependTaskList = (JSONArray)dependentParameters.get((Object)"dependTaskList");
            for (int j = 0; j < dependTaskList.size(); ++j) {
                JSONObject dependentTaskModel = dependTaskList.getJSONObject(j);
                JSONArray dependItemList = (JSONArray)dependentTaskModel.get((Object)"dependItemList");
                for (int k = 0; k < dependItemList.size(); ++k) {
                    JSONObject dependentItem = dependItemList.getJSONObject(k);
                    int definitionId = dependentItem.getInteger("definitionId");
                    ProcessDefinition definition = this.processDefineMapper.queryByDefineId(definitionId);
                    if (null == definition) continue;
                    dependentItem.put("projectName", (Object)definition.getProjectName());
                    dependentItem.put("definitionName", (Object)definition.getName());
                }
            }
            taskNode.put("dependence", (Object)dependentParameters);
        }
        return taskNode;
    }

    @Override
    public JSONObject addImportSpecialParam(JSONObject taskNode) {
        JSONObject dependentParameters = JSONUtils.parseObject((String)taskNode.getString("dependence"));
        if (dependentParameters != null) {
            JSONArray dependTaskList = (JSONArray)dependentParameters.get((Object)"dependTaskList");
            for (int h = 0; h < dependTaskList.size(); ++h) {
                JSONObject dependentTaskModel = dependTaskList.getJSONObject(h);
                JSONArray dependItemList = (JSONArray)dependentTaskModel.get((Object)"dependItemList");
                for (int k = 0; k < dependItemList.size(); ++k) {
                    ProcessDefinition definition;
                    JSONObject dependentItem = dependItemList.getJSONObject(k);
                    Project dependentItemProject = this.projectMapper.queryByName(dependentItem.getString("projectName"));
                    if (dependentItemProject == null || (definition = this.processDefineMapper.queryByDefineName(dependentItemProject.getId(), dependentItem.getString("definitionName"))) == null) continue;
                    dependentItem.put("projectId", (Object)dependentItemProject.getId());
                    dependentItem.put("definitionId", (Object)definition.getId());
                }
            }
            taskNode.put("dependence", (Object)dependentParameters);
        }
        return taskNode;
    }

    public void afterPropertiesSet() {
        TaskNodeParamFactory.register(TaskType.DEPENDENT.name(), this);
    }
}

