/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.MonitorService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"MONITOR_TAG"}, position=1)
@RestController
@RequestMapping(value={"/monitor"})
public class MonitorController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(MonitorController.class);
    @Autowired
    private MonitorService monitorService;

    @ApiOperation(value="listMaster", notes="MASTER_LIST_NOTES")
    @GetMapping(value={"/master/list"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.LIST_MASTERS_ERROR)
    public Result listMaster(@ApiIgnore @RequestAttribute(value="session.user") User loginUser) {
        logger.info("login user: {}, query all master", (Object)loginUser.getUserName());
        logger.info("list master, user:{}", (Object)loginUser.getUserName());
        Map<String, Object> result = this.monitorService.queryMaster(loginUser);
        return this.returnDataList(result);
    }

    @ApiOperation(value="listWorker", notes="WORKER_LIST_NOTES")
    @GetMapping(value={"/worker/list"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.LIST_WORKERS_ERROR)
    public Result listWorker(@ApiIgnore @RequestAttribute(value="session.user") User loginUser) {
        logger.info("login user: {}, query all workers", (Object)loginUser.getUserName());
        Map<String, Object> result = this.monitorService.queryWorker(loginUser);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryDatabaseState", notes="QUERY_DATABASE_STATE_NOTES")
    @GetMapping(value={"/database"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_DATABASE_STATE_ERROR)
    public Result queryDatabaseState(@ApiIgnore @RequestAttribute(value="session.user") User loginUser) {
        logger.info("login user: {}, query database state", (Object)loginUser.getUserName());
        Map<String, Object> result = this.monitorService.queryDatabaseState(loginUser);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryZookeeperState", notes="QUERY_ZOOKEEPER_STATE_NOTES")
    @GetMapping(value={"/zookeeper/list"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_ZOOKEEPER_STATE_ERROR)
    public Result queryZookeeperState(@ApiIgnore @RequestAttribute(value="session.user") User loginUser) {
        logger.info("login user: {}, query zookeeper state", (Object)loginUser.getUserName());
        Map<String, Object> result = this.monitorService.queryZookeeperState(loginUser);
        return this.returnDataList(result);
    }
}

