/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.BaseService;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.common.enums.UserType;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.EncryptionUtils;
import org.apache.dolphinscheduler.dao.entity.AccessToken;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.AccessTokenMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AccessTokenService
extends BaseService {
    private static final Logger logger = LoggerFactory.getLogger(AccessTokenService.class);
    @Autowired
    private AccessTokenMapper accessTokenMapper;

    public Map<String, Object> queryAccessTokenList(User loginUser, String searchVal, Integer pageNo, Integer pageSize) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        int userId = loginUser.getId();
        if (loginUser.getUserType() == UserType.ADMIN_USER) {
            userId = 0;
        }
        IPage accessTokenList = this.accessTokenMapper.selectAccessTokenPage(page, searchVal, userId);
        pageInfo.setTotalCount((int)accessTokenList.getTotal());
        pageInfo.setLists(accessTokenList.getRecords());
        result.put("data", pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> createToken(User loginUser, int userId, String expireTime, String token) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        if (!this.hasPerm(loginUser, userId)) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        if (userId <= 0) {
            throw new IllegalArgumentException("User id should not less than or equals to 0.");
        }
        AccessToken accessToken = new AccessToken();
        accessToken.setUserId(userId);
        accessToken.setExpireTime(DateUtils.stringToDate((String)expireTime));
        accessToken.setToken(token);
        accessToken.setCreateTime(new Date());
        accessToken.setUpdateTime(new Date());
        int insert = this.accessTokenMapper.insert((Object)accessToken);
        if (insert > 0) {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        } else {
            this.putMsg(result, Status.CREATE_ACCESS_TOKEN_ERROR, new Object[0]);
        }
        return result;
    }

    public Map<String, Object> generateToken(User loginUser, int userId, String expireTime) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        if (!this.hasPerm(loginUser, userId)) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        String token = EncryptionUtils.getMd5((String)(userId + expireTime + String.valueOf(System.currentTimeMillis())));
        result.put("data", token);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> delAccessTokenById(User loginUser, int id) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        AccessToken accessToken = (AccessToken)this.accessTokenMapper.selectById((Serializable)Integer.valueOf(id));
        if (accessToken == null) {
            logger.error("access token not exist,  access token id {}", (Object)id);
            this.putMsg(result, Status.ACCESS_TOKEN_NOT_EXIST, new Object[0]);
            return result;
        }
        if (!this.hasPerm(loginUser, accessToken.getUserId())) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        this.accessTokenMapper.deleteById((Serializable)Integer.valueOf(id));
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> updateToken(User loginUser, int id, int userId, String expireTime, String token) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        if (!this.hasPerm(loginUser, userId)) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        AccessToken accessToken = (AccessToken)this.accessTokenMapper.selectById((Serializable)Integer.valueOf(id));
        if (accessToken == null) {
            logger.error("access token not exist,  access token id {}", (Object)id);
            this.putMsg(result, Status.ACCESS_TOKEN_NOT_EXIST, new Object[0]);
            return result;
        }
        accessToken.setUserId(userId);
        accessToken.setExpireTime(DateUtils.stringToDate((String)expireTime));
        accessToken.setToken(token);
        accessToken.setUpdateTime(new Date());
        this.accessTokenMapper.updateById((Object)accessToken);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }
}

