/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service;

import java.text.MessageFormat;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.UserType;
import org.apache.dolphinscheduler.common.utils.HadoopUtils;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.dao.entity.User;

public class BaseService {
    protected boolean isAdmin(User user) {
        return user.getUserType() == UserType.ADMIN_USER;
    }

    protected boolean checkAdmin(User loginUser, Map<String, Object> result) {
        if (!this.isAdmin(loginUser)) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return true;
        }
        return false;
    }

    protected void putMsg(Map<String, Object> result, Status status, Object ... statusParams) {
        result.put("status", (Object)status);
        if (statusParams != null && statusParams.length > 0) {
            result.put("msg", MessageFormat.format(status.getMsg(), statusParams));
        } else {
            result.put("msg", status.getMsg());
        }
    }

    protected void putMsg(Result result, Status status, Object ... statusParams) {
        result.setCode(status.getCode());
        if (statusParams != null && statusParams.length > 0) {
            result.setMsg(MessageFormat.format(status.getMsg(), statusParams));
        } else {
            result.setMsg(status.getMsg());
        }
    }

    protected boolean check(Map<String, Object> result, boolean bool, Status userNoOperationPerm) {
        if (bool) {
            result.put("status", (Object)userNoOperationPerm);
            result.put("msg", userNoOperationPerm.getMsg());
            return true;
        }
        return false;
    }

    public static Cookie getCookie(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null && cookies.length > 0) {
            for (Cookie cookie : cookies) {
                if (!StringUtils.isNotEmpty((CharSequence)name) || !name.equalsIgnoreCase(cookie.getName())) continue;
                return cookie;
            }
        }
        return null;
    }

    protected void createTenantDirIfNotExists(String tenantCode) throws Exception {
        String resourcePath = HadoopUtils.getHdfsResDir((String)tenantCode);
        String udfsPath = HadoopUtils.getHdfsUdfDir((String)tenantCode);
        HadoopUtils.getInstance().mkdir(resourcePath);
        HadoopUtils.getInstance().mkdir(udfsPath);
    }

    protected boolean hasPerm(User operateUser, int createUserId) {
        return operateUser.getId() == createUserId || this.isAdmin(operateUser);
    }
}

