/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dolphinscheduler.api.dto.CommandStateCount;
import org.apache.dolphinscheduler.api.dto.DefineUserDto;
import org.apache.dolphinscheduler.api.dto.TaskCountDto;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.BaseService;
import org.apache.dolphinscheduler.api.service.ProjectService;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.UserType;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.dao.entity.CommandCount;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.CommandMapper;
import org.apache.dolphinscheduler.dao.mapper.ErrorCommandMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessInstanceMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskInstanceMapper;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataAnalysisService
extends BaseService {
    private static final Logger logger = LoggerFactory.getLogger(DataAnalysisService.class);
    @Autowired
    ProjectMapper projectMapper;
    @Autowired
    ProjectService projectService;
    @Autowired
    ProcessInstanceMapper processInstanceMapper;
    @Autowired
    ProcessDefinitionMapper processDefinitionMapper;
    @Autowired
    CommandMapper commandMapper;
    @Autowired
    ErrorCommandMapper errorCommandMapper;
    @Autowired
    TaskInstanceMapper taskInstanceMapper;
    @Autowired
    ProcessService processService;

    public Map<String, Object> countTaskStateByProject(User loginUser, int projectId, String startDate, String endDate) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        boolean checkProject = this.checkProject(loginUser, projectId, result);
        if (!checkProject) {
            return result;
        }
        Date start = null;
        Date end = null;
        try {
            start = DateUtils.getScheduleDate((String)startDate);
            end = DateUtils.getScheduleDate((String)endDate);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.putErrorRequestParamsMsg(result);
            return result;
        }
        Integer[] projectIds = this.getProjectIdsArrays(loginUser, projectId);
        List taskInstanceStateCounts = this.taskInstanceMapper.countTaskInstanceStateByUser(start, end, projectIds);
        if (taskInstanceStateCounts != null) {
            TaskCountDto taskCountResult = new TaskCountDto(taskInstanceStateCounts);
            result.put("data", taskCountResult);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    private void putErrorRequestParamsMsg(Map<String, Object> result) {
        result.put("status", (Object)Status.REQUEST_PARAMS_NOT_VALID_ERROR);
        result.put("msg", MessageFormat.format(Status.REQUEST_PARAMS_NOT_VALID_ERROR.getMsg(), "startDate,endDate"));
    }

    public Map<String, Object> countProcessInstanceStateByProject(User loginUser, int projectId, String startDate, String endDate) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        boolean checkProject = this.checkProject(loginUser, projectId, result);
        if (!checkProject) {
            return result;
        }
        Date start = null;
        Date end = null;
        try {
            start = DateUtils.getScheduleDate((String)startDate);
            end = DateUtils.getScheduleDate((String)endDate);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.putErrorRequestParamsMsg(result);
            return result;
        }
        Integer[] projectIdArray = this.getProjectIdsArrays(loginUser, projectId);
        List processInstanceStateCounts = this.processInstanceMapper.countInstanceStateByUser(start, end, projectIdArray);
        if (processInstanceStateCounts != null) {
            TaskCountDto taskCountResult = new TaskCountDto(processInstanceStateCounts);
            result.put("data", taskCountResult);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    public Map<String, Object> countDefinitionByUser(User loginUser, int projectId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Integer[] projectIdArray = this.getProjectIdsArrays(loginUser, projectId);
        List defineGroupByUsers = this.processDefinitionMapper.countDefinitionGroupByUser(Integer.valueOf(loginUser.getId()), projectIdArray, this.isAdmin(loginUser));
        DefineUserDto dto = new DefineUserDto(defineGroupByUsers);
        result.put("data", dto);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> countCommandState(User loginUser, int projectId, String startDate, String endDate) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        boolean checkProject = this.checkProject(loginUser, projectId, result);
        if (!checkProject) {
            return result;
        }
        Date start = null;
        Date end = null;
        if (startDate != null && endDate != null) {
            try {
                start = DateUtils.getScheduleDate((String)startDate);
                end = DateUtils.getScheduleDate((String)endDate);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                this.putErrorRequestParamsMsg(result);
                return result;
            }
        }
        Integer[] projectIdArray = this.getProjectIdsArrays(loginUser, projectId);
        List commandStateCounts = this.commandMapper.countCommandState(loginUser.getId(), start, end, projectIdArray);
        List errorCommandStateCounts = this.errorCommandMapper.countCommandState(start, end, projectIdArray);
        HashMap dataMap = new HashMap();
        HashMap<String, Integer> commonCommand = new HashMap<String, Integer>();
        commonCommand.put("commandState", 0);
        commonCommand.put("errorCommandState", 0);
        dataMap.put(CommandType.START_PROCESS, commonCommand);
        dataMap.put(CommandType.START_CURRENT_TASK_PROCESS, commonCommand);
        dataMap.put(CommandType.RECOVER_TOLERANCE_FAULT_PROCESS, commonCommand);
        dataMap.put(CommandType.RECOVER_SUSPENDED_PROCESS, commonCommand);
        dataMap.put(CommandType.START_FAILURE_TASK_PROCESS, commonCommand);
        dataMap.put(CommandType.COMPLEMENT_DATA, commonCommand);
        dataMap.put(CommandType.SCHEDULER, commonCommand);
        dataMap.put(CommandType.REPEAT_RUNNING, commonCommand);
        dataMap.put(CommandType.PAUSE, commonCommand);
        dataMap.put(CommandType.STOP, commonCommand);
        dataMap.put(CommandType.RECOVER_WAITTING_THREAD, commonCommand);
        for (CommandCount executeStatusCount : commandStateCounts) {
            HashMap<String, Integer> commandStateCountsMap = new HashMap<String, Integer>((Map)dataMap.get(executeStatusCount.getCommandType()));
            commandStateCountsMap.put("commandState", executeStatusCount.getCount());
            dataMap.put(executeStatusCount.getCommandType(), commandStateCountsMap);
        }
        for (CommandCount errorExecutionStatus : errorCommandStateCounts) {
            HashMap<String, Integer> errorCommandStateCountsMap = new HashMap<String, Integer>((Map)dataMap.get(errorExecutionStatus.getCommandType()));
            errorCommandStateCountsMap.put("errorCommandState", errorExecutionStatus.getCount());
            dataMap.put(errorExecutionStatus.getCommandType(), errorCommandStateCountsMap);
        }
        ArrayList<CommandStateCount> list = new ArrayList<CommandStateCount>();
        for (Map.Entry next : dataMap.entrySet()) {
            CommandStateCount commandStateCount = new CommandStateCount((Integer)((Map)next.getValue()).get("errorCommandState"), (Integer)((Map)next.getValue()).get("commandState"), (CommandType)next.getKey());
            list.add(commandStateCount);
        }
        result.put("data", list);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private Integer[] getProjectIdsArrays(User loginUser, int projectId) {
        List<Integer> projectIds = new ArrayList<Integer>();
        if (projectId != 0) {
            projectIds.add(projectId);
        } else if (loginUser.getUserType() == UserType.GENERAL_USER && (projectIds = this.processService.getProjectIdListHavePerm(loginUser.getId())).size() == 0) {
            projectIds.add(0);
        }
        return projectIds.toArray(new Integer[projectIds.size()]);
    }

    public Map<String, Object> countQueueState(User loginUser, int projectId) {
        String[] splits;
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        boolean checkProject = this.checkProject(loginUser, projectId, result);
        if (!checkProject) {
            return result;
        }
        ArrayList tasksQueueList = new ArrayList();
        ArrayList tasksKillList = new ArrayList();
        HashMap<String, Integer> dataMap = new HashMap<String, Integer>();
        if (loginUser.getUserType() == UserType.ADMIN_USER) {
            dataMap.put("taskQueue", tasksQueueList.size());
            dataMap.put("taskKill", tasksKillList.size());
            result.put("data", dataMap);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
            return result;
        }
        int[] tasksQueueIds = new int[tasksQueueList.size()];
        int[] tasksKillIds = new int[tasksKillList.size()];
        int i = 0;
        for (String taskQueueStr : tasksQueueList) {
            if (!StringUtils.isNotEmpty((CharSequence)taskQueueStr) || (splits = taskQueueStr.split("_")).length < 4) continue;
            tasksQueueIds[i++] = Integer.parseInt(splits[3]);
        }
        i = 0;
        for (String taskKillStr : tasksKillList) {
            if (!StringUtils.isNotEmpty((CharSequence)taskKillStr) || (splits = taskKillStr.split("-")).length != 2) continue;
            tasksKillIds[i++] = Integer.parseInt(splits[1]);
        }
        Integer taskQueueCount = 0;
        Integer taskKillCount = 0;
        Integer[] projectIds = this.getProjectIdsArrays(loginUser, projectId);
        if (tasksQueueIds.length != 0) {
            taskQueueCount = this.taskInstanceMapper.countTask(projectIds, tasksQueueIds);
        }
        if (tasksKillIds.length != 0) {
            taskKillCount = this.taskInstanceMapper.countTask(projectIds, tasksKillIds);
        }
        dataMap.put("taskQueue", taskQueueCount);
        dataMap.put("taskKill", taskKillCount);
        result.put("data", dataMap);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private boolean checkProject(User loginUser, int projectId, Map<String, Object> result) {
        if (projectId != 0) {
            Project project = (Project)this.projectMapper.selectById((Serializable)Integer.valueOf(projectId));
            return this.projectService.hasProjectAndPerm(loginUser, project, result);
        }
        return true;
    }
}

